# $Date: 1995/06/28 11:32:34 $  $Author: zimmerma $  $Revision: 1.23 $ #

#++
factor-- return the factorization of multivariate polynomial in Z or
         factorization of univariate polynomial in Zp, output is given in form
         [u, f1, e1, ..., fn, en], (p=u*f1^e1*...*fn^en, u is the constant
         content), fi has the same form of input p. 

factor(p)
p - an expression or a polynomial
++#

factor:=proc(p)
local cc, f, factors, ff, fn, fu, i, j, k, n, pform, pp, q, t, xx;
begin
    if args(0) <> 1 then
       error("one argument expected");
    end_if;
    # test the type of the input expression, and #
    # change the suitable one to polynomial form # 
    case type(p)
    of "_plus" do p:=poly(p); 
		  if p = FAIL then error("not a polynomial") end_if;
                  pform:=FALSE;
                  # fall through #;
    of DOM_POLY do if degree(p) = 0 then return([expr(p)]) end_if;
		   # remove indets which have 0 degree #
		   xx:= op(p,2);
		   f:= map(xx, fun((
		     if degree(p,args(1))<>0 then args(1) else null() end_if)));
		   if f <> xx then
		      p:= factor(poly(p,f));
		      if pform = FALSE then
			 return([p[1], (expr(p[2*i]), p[2*i+1])
				       $ hold(i)=1..(nops(p) div 2) ]);
		      end_if;
		      return([p[1], (poly(p[2*i],xx), p[2*i+1])
				    $ hold(i)=1..(nops(p) div 2) ]);
		   end_if;
                   if nterms(p)=1 then
		      if pform = FALSE then
			 return([lcoeff(p), (xx[i], degree(p,xx[i]))
					    $ hold(i)=1..(nops(p) div 2) ]);
		      end_if;
                      return([lcoeff(p),(poly(xx[i],op(p,2..3)),
                              degree(p,xx[i]))$hold(i)=1..nops(xx)]);
                   end_if;
                   if pform <> FALSE then pform:=TRUE end_if;
                   break;
    of "_power" do f:=factor(op(p,1));
                   n:=op(p,2);
                   # PZ : deleted because n can be symbolic #
		   # if n<0 then error("not a polynomial") end_if; #
                   return(subsop(f,1=f[1]^n,((2*i+1)=n*f[2*i+1])$hold(i)=1..(nops(f)-1)/2));
    of "_mult" do n:=nops(p);
                  (fu[i]:=factor(op(p,i)))$hold(i)=1..n;
                  # fn:=[op(fu[1],i)$hold(i)=2..nops(fu[1])]; #
                  fn:=fu[1];
                  for i from 2 to n do
                      fn[1]:=fn[1]*op(fu[i],1); # collect scalars #
                      for j from 1 to (nops(fu[i])-1)/2 do
                          cc:=0;  
                          ff:=op(fu[i],2*j); 
                          for k from 1 to nops(fn) div 2 do
                              if ff=fn[2*k] then 
                                 cc:=1;
                                 break;
                              end_if;
                          end_for;
                          if cc=1 then 
                             # fn:=subsop(fn,2*k=op(fn,2*k)+op(fu[i],2*j+1)); #
			     fn[2*k+1]:=fn[2*k+1]+op(fu[i],2*j+1);
                          else fn:=append(fn,ff,op(fu[i],2*j+1));
                          end_if;
                      end_for;
                  end_for;
                  return(fn);
    of DOM_INT do
    of DOM_RAT do
	      return([p]);
    of DOM_IDENT do
    of "_index" do
	      return([1,p,1]);
    otherwise
	      if p::factor <> FAIL then return(p::factor(p))
              else return([1,p,1]) end_if;
    end_case;
    if (q:=op(p,3))<>Expr then
       if op(q,0)<>IntMod then
          if q::constructor=IntegerMod then
             xx:=IntMod(op(q::constructor_args));
             return(subs(factor(subsop(p,3=xx)),xx=q))
          elif q::constructor=AlgebraicExtension then
             if nops(op(p,2))<>1 then
                error("can't factor multivariate polynomials over algebraic extensions")
             else return(faclib::algfactor(p))
             end_if
          else error("can't factor over domains")
          end_if
       end_if;
       # factorization in Zp for univariate polynomial #
       if isprime((q:=op(p,[3,1]))) then 
          if nops((xx:=op(p,2)))=1 then
             ff:=[lcoeff(p)];
             p:=multcoeffs(p,1/op(ff));
             if degree((t:=nthterm(p,nterms(p))))<>0 then 
                ff:=append(ff,poly(op(xx),xx,IntMod(q)),degree(t));
                p:=divide(p,t,Exact);
             end_if;
             if degree(p)=1 then 
                return(append(ff,p,1));
             else return(ff.faclib::factor_mod(p,op(xx),q));
             end_if;
          else error("Only for univariate case");
          end_if;
       else error("Modulus must be a prime number");
       end_if;
    else # op(p,3)=Expr #
         if not testtype(p, Type::PolyOf(Type::Rational)) then 
           # try with maprat #
           if traperror((p:=maprat(expr(p),factor)))=0 then
              if pform then return([p[1], (poly(p[2*i],xx), p[2*i+1])
                                       $ hold(i)=1..(nops(p) div 2) ]);
              else return(p)
              end_if
           else error("Only for polynomial with rational coefficients")
           end_if
         end_if;
         # factorization in Z #
         factors:=[icontent(p)*sign(lcoeff(p))];
         p:=multcoeffs(p,1/op(factors)); 
         if op((t:=faclib::monomial(p)),1)<>[] then
            factors:=factors.op(t,1);
	    p:= divide(p, poly(op(t,2), op(p,2..3)), Exact);
            # PZ : added the following line because divide does not
              reduce the number of indets, which causes a loop
              for example with factor(a^2*k-2*a*k+k) #
            p:=poly(expr(p));
         end_if;
         pp:=faclib::pfactor(p,0);
         # check sign #
         if expr(poly(_mult(_power(expr(op(pp,2*i-1)),op(pp,2*i))\
                         $hold(i)=1..nops(pp)/2)))<>expr(p) then 
            factors[1]:= -factors[1];
         end_if; 
    end_if;
    if pform then 
       return(factors.pp);
    else
       # change to expression form #
       factors:=factors.pp;
       return(subsop(factors,((2*i)=expr(op(factors,2*i)))\
                                    $hold(i)=1..(nops(factors)-1)/2)); 
    end_if;        
end_proc:             

Factor := proc(p) local l,i;
begin
   if p::Factor <> FAIL then return( p::Factor(p) ) 
   elif traperror((l:=factor(p)))=0 then
      if l[1]=1 then
         if nops(l)=3 then l[2]^l[3]
         else hold(_mult)(l[2*i]^l[2*i+1]$i=1..nops(l) div 2)
         end_if
      else hold(_mult)(l[1],l[2*i]^l[2*i+1]$i=1..nops(l) div 2)
      end_if
   elif traperror((l:=numer(p),denom(p)))=0 then 
      if l[2]=1 then error("rational function with denominator 1") end_if;
      Factor(l[1])/Factor(l[2])
   else error("neither a polynomial nor a rational function")
   end_if
end_proc:

# end of file #
