# $Date: 1994/09/01 11:00:28 $  $Author: kg $  $Revision: 1.3 $ #
# kg, 15/07/94 #

#++
fun -- create a pure function

fun(e [,Named])

e     - expression, a function of args(1),...args(n)
Named - option

fun views the expression e as a function of the indeterminates args(i)
and returns either a 'pure function' computing that function.

A pure function is a special form of procedure which evaluates in the
context of the caller and is faster than procedures.

If the option 'Named' is used the function created has a name, otherwise
it is anonymous and printed as 'fun(...)'.

The arguments are not evaluated!

Examples:

f:= fun(sin(args(1)^2+args(2)^2));		-> fun(...)
f(x,1);						-> sin(x^2+1)

f:= fun(sin(args(1)^2+args(2)^2), Named);	-> fun(sin(args(1)^2+args(2)^2)
f(x,1);						-> sin(x^2+1)
++#

fun:= proc(e)
    option hold;
begin
    case args(0)
    of 1 do
	newpurefunc("fun(...)", NIL, e);
	break;
    of 2 do
	if args(2) <> hold(Named) then error("unknown option") end_if;
	newpurefunc("fun(".expr2text(e).")", NIL, e);
	break;
    otherwise
	error("wrong no of args")
    end_case
end_proc:

# end of file #
