# computes the gcd of A and B with respect to x,
  using the extended Euclidean algorithm 
  PZ, 14/10/1994
#

gcdex := proc(A,B,x)
local s,t,u,v,q,a,b,tmp;
begin
   if A::gcdex <> FAIL then return(A::gcdex(args())) end_if;
   if B::gcdex <> FAIL then return(B::gcdex(args())) end_if;
   if type(A)=DOM_POLY then a:=A;b:=B
   else a:=poly(A,[x]); b:=poly(B,[x])
   end_if;
   s:=a^0; t:=s-s; u:=t; v:=s;
   # loop invariant : a = s*A+t*B, b = u*A+v*B #
   while not iszero(b) do
      q:=divide(a,b); a:=b; b:=mapcoeffs(q[2],normal);
      q:=mapcoeffs(q[1],normal);
      tmp:=s; s:=u; u:=tmp-q*u;
      tmp:=t; t:=v; v:=tmp-q*v;
   end_while;
   tmp:=1/lcoeff(a);
   s:=multcoeffs(a,tmp),multcoeffs(s,tmp),multcoeffs(t,tmp);
   if type(A)=DOM_POLY then s else
      s:=map([s],expr); # 27/4/95: had to split because of eval problem #
      op(map(s,normal))
   end_if
end_proc:


