
#++
int -- integration

int(f,x)

f - expression
x - identifier

This is merely a front end for indefinite integration via intlib::int.
Definite integration is not implemented yet.
++#

proc() begin

int:= fun((
   if args(0) <> 2 then error("wrong no of args") end_if;
   if (args(1))::int <> FAIL then return((args(1))::int(args())) end_if;
   if type(args(2))=DOM_IDENT then # indefinite integration #
      loadlib("intlib");
      intlib::int(args())
   else
      if testargs() then
	 if type(args(2)) <> "_equal" then
	    error("illegal second argument in int(...)")
	 end_if;
	 if domtype(op(args(2),1)) <> DOM_IDENT then
	    error("no integration variable")
	 end_if;
	 if type(op(args(2),2)) <> "_range" then
	    error("no range of integration")
	 end_if;
	 if has(op(args(2),2), op(args(2),1)) then
	    error("range depends upon integration variable")
	 end_if
      end_if;
      int_definite(args(1),op(args(2),1),op(op(args(2),2)));
   end_if
)):

int_definite := proc(f,x,a,b) # int(f,x=a..b) #
local i;
begin
   if testtype(f,Type::PolyExpr(x)) then # no singularity possible #
      f:=poly(f,[x]);
      _plus(coeff(f,i)*(b^(i+1)-a^(i+1))/(i+1) $ i=0..degree(f))
   else hold(int)(f,x=a..b) 
   end_if
end_proc:

int:= funcattr(int, "type", "int"):
int:= funcattr(int, "print", "int"):

# diff-attribute of int #

int:= funcattr(int, "diff",
    proc(f)
	local i, a, u;
    begin
	if args(0) = 1 then return(f) end_if;

	a:= [];
	u:= [];
	for i from 2 to args(0) do
	    if has(op(f,2), args(i)) then
		a:= append(a, args(i))
	    else
		u:= append(u, args(i))
	    end_if
	end_for;

	# exchange diff and int #
	if nops(u) <> 0 then
	    return(diff(int(diff(op(f,1), op(u)), op(f,2)), op(a)))
	end_if;

	i:= contains(a, op(f,2));
	if i = 0 then
	    # diff(int(g,t=a..b),y) #
	    if contains(a, op(f,[2,1])) = 0 then
		# diff(int(g,t=a(x)..b(x)),x) #
		hold(diff)(args())
	    else # diff(int(g,x=a..b),x) #
		0
	    end_if
	else # diff(int(g,x),x) #
	    a[i]:= NIL;
	    diff(op(f,1), op(a))
	end_if
    end_proc):

# float-attribute of int (numerical integration) #

int:= funcattr(int, "float", proc(f, x) local r; begin
   loadlib("intlib");
   r := intlib::numint(f,x);
   if r = FAIL then hold(int)(f, x) else r end_if
end_proc):

end_proc():

# end of file #
