# $Date: 1995/05/17 08:47:08 $  $Author: kg $  $Revision: 1.15 $ #

#++
loadproc -- load an object from file on demand

loadproc(p, l, f [,c [,d,...]])

p - an expression
l - a path name
f - a file name without suffix
c - a function (optional)
d - data (optional)

loadproc on demand reads in the file f containing the definition of
the object p. On demand means: the file is read when the result
of the loadproc-call is evaluated for the first time. The argument
p is not evaluated.

After the result of the loadproc-call is evaluated and the file is
read p is evaluated and returned instead of the result of the
loadproc-call.

The typical use is loading a procedure p on demand as in
    p:= loadproc(p, "LIB/", "p");
Here the definition of p is read when p is evaluated for the first
time.

The file name f must not contain a suffix. First the binary file
	l."BIN/".f.".mb"
is searched for. If this binary file doesn't exist the t file
	l.f.".mu"
is searched for.

Note that the varaible LIB_PATH is used to locate the file.

If the additional options c and d,... are given, the expression 'c(d,...)'
is evaluated after p is read from file, but before p is executed. The
callback function c may be used to change p in a certain way after it is
read from file.
++#

proc()
    local D;
begin
 
loadproc := proc()
    option hold;
begin
    if testargs() then
	if args(0) < 3 then
	    error("wrong no of arguments")
	end_if;

	case domtype(args(1))
	of DOM_IDENT do
	of DOM_EXPR do
	    break;
	otherwise
	    error("wrong procedure name")
	end_case;
    end_if;

    new(stdlib::LoadProc, args(1), 
        op(context([args(2..args(0))])))
end_proc:


# LoadProc -- domain to load library functions on demand #

D:= domain():
D::name := "stdlib::LoadProc":

D::new := proc()
    name loadproc;
begin
    new(stdlib::LoadProc, args())
end_proc:

D::read_file:= proc(path, fnam)
    name loadproc;
    local p, f, at, af;
begin
    for p in LIB_PATH do
	# read file, try mb-file first, then mu-file #
	f:= fopen(p.path.stdlib::BinPath.fnam.".mb");
	if f <> FAIL then
	    fread(f);
	    fclose(f);
	    break;
	end_if;

	f:= fopen(p.path.fnam.".mu");
	if f = FAIL then next end_if;
    
	# un-install actual aliases #
	at:= stdlib::Alias;
	af:= (if domtype(_dom_alias_element_) = DOM_IDENT then FAIL
	      else _dom_alias_element_ end_if);
	stdlib::Alias:= FAIL;
	_dom_alias_element_:= NIL;

	fread(f);
	fclose(f);
	    
	# re-install actual aliases #
	stdlib::Alias:= at;
	_dom_alias_element_:= (if af = FAIL then NIL else af end_if);
	break
    end_for;

    if f = FAIL then
        error("can't read file '".path.fnam.".mu'")
    end_if
end_proc:

D::evaluate := proc()
    name loadproc;
begin
    (stdlib::LoadProc)::read_file(op(args(1),2), op(args(1),3));
    if nops(args(1)) > 3 then
	op(args(1),4)(op(args(1), 5..nops(args(1))))
    end_if;
    context(op(args(1),1))
end_proc:

D::func_call := proc()
    name loadproc;
begin
    (stdlib::LoadProc)::read_file(op(args(1),2), op(args(1),3));
    if nops(args(1)) > 3 then
	op(args(1),4)(op(args(1), 5..nops(args(1))))
    end_if;
    context(op(args(1),1)(args(2..args(0))))
end_proc:

D::set_func_call := proc()
    name loadproc;
begin
    (stdlib::LoadProc)::read_file(op(args(1),2), op(args(1),3));
    if nops(args(1)) > 3 then
	op(args(1),4)(op(args(1), 5..nops(args(1))))
    end_if;
    context(subsop(hold((f(a):=v)), [1,0]=op(args(1),1),
	    [1,1]=(args(2..args(0)-1)), 2=args(args(0))));
    context(op(args(1),1))
end_proc:

D::posteval := proc()
    name loadproc;
begin
    (stdlib::LoadProc)::read_file(op(args(1),2), op(args(1),3));
    if nops(args(1)) > 3 then
	op(args(1),4)(op(args(1), 5..nops(args(1))))
    end_if;
    context(op(args(1),1))
end_proc:

stdlib::LoadProc:= D:
null():
end_proc():

# end of file #
