# $Date: 1994/05/31 13:26:22 $  $Author: linus $  $Revision: 1.1 $ #

#
|                                                             
| Library-Routine plot2d().
|                                                             
|
|                                                             
| Diese Datei enth"alt die Library-Routinen plot2d(),
| die notwendig sind, um die verschiedenen im Hand- 
| buch aufgelisteten Grafikbefehle zu vereinbaren.            
| Die Argumente dieser Befehle werden so ge"andert,
| dass die Kernroutine plot() die richtigen Werte an
| das Grafiktool liefert.                                                    
|                                                             
|
|                                                             
| Autor: Thorsten Schulze                                     
|                                                             
| letzte "Anderung : 26.1.93                                  
|                                                             
#





plot2d := proc()
#  
|  Dieses ist die Library-Routine, die einen plot2d-Befehl in
|  einen plot-Befehl umwandelt.
|  Bei der Umwandlung ist darauf zu achten, dass einige der
|  2D-Optionen sich von den 3D-Optionen unterscheiden. In die-
|  sen F"allen muss die 2D-Option in eine 3D-Option umgewandelt
|  werden. Dabei werden aus dieser Library-Routine keine Fehler-
|  meldungen ausgegeben. Diese werden sowieso im plot-Befehl 
|  erzeugt. Ferner wird nicht "uberpr"uft, ob Optionen richtig 
|  eingegeben wurden. Weiterhin wird auch nicht getestet, ob die
|  Optionen mehrfach spezifiziert werden.
|  Im einzelnen sind das die zu "andernden Optionen die folgenden :
|      
|    ViewingBox : Hier wird der Benutzer im 2D-Fall vier Werte
|                 eingeben. Der plot-Befehl hingegen verlangt
|                 sechs Werte. Die fehlenden zwei Werte werden
|                 erg"anzt, indem f"ur die z-Werte der ViewingBox 
|                 die Sequenz 0,0 an die y-Werte der ViewingBox 
|                 angeh"angt werden. Dieses passiert auch, wenn 
|                 der Benutzer mehr als vier Werte eingegeben hat.
|
|    Labels     : Im 2D-Fall gibt der Benutzer im allgemeinen
|                 zwei Zeichenketten als Beschriftungen f"ur die
|                 x- und y-Achse ein. Im Gegensatz dazu verlangt
|                 die zugeh"orige 3D-Option drei Zeichenketten.
|                 Hat der Benutzer also die Option Labels verwen-
|                 det, so wird eine leere Zeichenkette an die
|                 zweite Zeichenkette dieser Option angeh"angt.
|                 Dieses geschieht auch, wenn der Benutzer mehr
|                 als zwei Zeichenketten vereinbart hat. Die
|                 Fehlermeldung wird dann im plot-Befehl erzeugt.
|
|    Funktionen : Im 2D-Fall werden im allgemeinen zwei Funktionen
|                 angegeben. Im 3D-Fall hingegen ben"otigen wir
|                 drei Funktionen (Parametrisierungen). Dieses 
|                 wird erreicht, indem an die zweite Funktion die
|                 Funktion 0 angeh"angt wird.
|                 Dieses geschieht auch, wenn mehr als zwei Funkti-
|                 onen spezifiziert wurden. Die Fehlermeldung wird
|                 dann im plot-Befehl ausgegeben.
|
|  Zus"atzlich m"ussen wir daf"ur sorgen, dass die richtige Per-
|  spektive erzeugt wird. Dazu wird im plot-Befehl die folgende
|  Option aufgerufen:
|
|     CameraPoint = [0, -0.00001, 1]
|
|  Ferner muss dann noch die Dimension der Szene mit "ubergeben 
|  werden. Dieses erreichen wir durch die Option Dimension = 1,
|  welche im plot-Befehl die Dimension der Szene setzt.
|
#


local i, list, s, DIGITS;    # In list werden die Argumente des Aufrufes
                             | gespeichert und die zu "andernden Optionen
                             | des plot-Befehls werden ver"andert. Das 
                             | steht dann in der Sequenz s. DIGITS dient
                             | dazu, das globale DIGITS umzusetzen.
                             #

begin
  DIGITS := 10:
  #
  | Falls keine Argumente "ubergeben wurden, so wird
  | auch plot3d ohne Argumente aufgerufen.
  #

  if args(0) = 0 
  then
    plot(Dimension=2):
  else

    #
    | Festlegen der Perspektive und der Dimension
    #

    list[0] := Dimension = 2, CameraPoint = [0, -0.0001, 1.0]:
    s := list[0];
    
    #
    | Abarbeiten der Argumentenliste
    #

    for i from 1 to args(0) do
      list[i] := args(i):

      #
      | Test, um welche Option es sich handelt.
      | Hier werden nur die Optionen Labels,
      | ViewingBox und Mode=Curve getestet.
      | Alle anderen Optionen werden nicht ge-
      | pr"uft, denn das passiert sowieso im
      | anschliessenden plot-Aufruf.
      #

      case op(list[i],[1,1]) 
           of (Labels) do

              #
              | Die Option Labels wurde verwendet.
              | Falls die Anzahl der Operanden von list[i] gleich 2 ist,
              | "uberpr"ufe die Anzahl der Operanden des 2. Operanden von
              | list[i]. Ist diese gr"osser gleich 2, so h"ange
              | an den zweiten den String "" an.
              #

              if nops(list[i]) = 2 
              then
                if nops(op(list[i],2)) >= 2
                then
                  list[i] := subsop(list[i],[2,2]=(op(list[i],[2,2]),"")):
                end_if:
              end_if:
              break;
           of (ViewingBox) do

              #
              | Die Option ViewingBox wurde gew"ahlt.
              | Falls die Anzahl der Operanden von list[i] gleich 2 ist,
              | "uberpr"ufe die Anzahl der Operanden des 2. Operanden von
              | list[i]. Ist diese gr"osser gleich 4, so h"ange an den
              | vierten Operanden die Sequenz ,0,0 an.
              #

              if  nops(list[i]) = 2
              then
                if nops(op(list[i],2)) >= 4
                then
                  list[i] := subsop(list[i],[2,4]=(op(op(list[i],2),4),0,0)):
                end_if:
              end_if:
              break;
           of (Mode) do 

              #
              | Die Option Mode wurde verwendet.
              | Wir testen zun"achst, ob die Anzahl der Operanden in list[i]
              | gr"osser als 3 ist (Mode,Funktionen,Range,...). Danach pr"u-
              | fen wir, ob der zweite Operand des 1.Operanden von list[1]
              | gerade gleich Curve ist. Falls dem so ist, so testen wir, ob 
              | die Anzahl der Operanden des zweiten Operanden in list[i]
              | (das sind normalerweise die Funktionen) gr"osser gleich 2 ist.
              | Falls ja, so h"angen wir an den zweiten Operanden die Sequenz
              | ,0 an (das ist dann die z-Funktion).
              #

              if nops(list[i]) >= 3 
              then
                case (op(list[i],[1,2])) 
                     of (Curve) do
                        if nops(op(list[i],2)) >= 2
                        then
                          list[i] := subsop(list[i],[2,2]=(op(list[i],[2,2]),0)):
                        end_if:
                        break:
                end_case:
              end_if:
              break:
      end_case:
      s := s,list[i];
    end_for:
    plot(s);
  end_if:
end_proc:
