# $Date: 1995/02/23 09:35:44 $  $Author: kg $  $Revision: 1.4 $ #

profile := proc()
    local depth, fd, l, last_depth, pname, time, rtime, t,
          pop, push, init_stack, stack, stackpointer, 
          statistic, show_statistic, info, getline,
          float2string, sort, init, format, length, 
	  rprint, lprint, MAX_DEPTH, result, fname,
	  statistic2, show_statistic2, info2;
    option hold;
begin

    # Stackoperationen push , pop, init_stack                  #
    # Stack ist eine Tabelle. Tabellenindizes sind nat"urliche #
    # Zahlen. stackpointer zeigt auf oberstes Element. Ein-    #
    # im Stack sind Zeiten, die aus dem Datenfile stammen.     #

    pop := proc()
       begin 
            stackpointer := stackpointer - 1; 
            stack[stackpointer]
      end_proc:
    push := proc(elem)
      begin
           stack[stackpointer] := elem;
           stackpointer := stackpointer + 1; 
      end_proc:
    init_stack := proc()
        begin stackpointer := 0 end_proc:

    getline := proc()
        local a, b, c, d;
    begin
          if finput(fd, a, b, c, d) = null() then
             fclose(fd); return(null())
          end_if;
          a, b, c, d
    end_proc:

    # MAX_DEPTH ist der unterste Eintrag im Stack, also #
    # bottom of stack, und dient als Stopmarke beim Ab- #
    # bau des Stacks. Der Alg. l"auft nur dann korrekt, # 
    # wenn eine Prozedurtiefe von >= MAX_DEPTH niemals  #
    # erreicht wird. Bei dem hier gew"ahlten Wert 10000 #
    # ist davon aber auszugehen.                        #

    init := proc()
        begin
            init_stack(); MAX_DEPTH := 100000;
            push(-MAX_DEPTH-1); last_depth := MAX_DEPTH;
	    info := NIL;
    end_proc:

    # Profile-Protokoll. Informationen werden in der Tabelle   #
    # info gespeichert, die "uber den Prozedurnamen pname      #
    # indiziert wird. Jeder Eintrag der Tabelle ist eine Liste #
    # mit 3 Elementen, zum einem der Laufzeit innerhalb der    #
    # Prozedur pname , der Anzahl der Aufrufe der Prozedur     #
    # die ein Ergebnis durch Evaluierung des Prozedurrumpfes   #
    # berechneten, und der Anzahl der Prozeduraufrufe, die ein #
    # Ergebnis durch Lookup in der Remember-Tabelle berech-    #
    # neten. Die Laufzeit ist nur die Zeit, die direkt in der  #  
    # Prozedur verbracht wurde.                                #
 
    statistic := proc(pname, time, depth)
        local l;
      begin
            if domtype(info[pname]) = DOM_LIST then
 
                # Prozedur pname ist bereits vorhanden.        #
                # Addiere Zeit und erh"ohe Aufrufz"ahler um 1. #
 
                l := info[pname];  l[1] := l[1] + time;
 
                # Ist depth < 0, dann handelt es sich um einen #
                # Prozeduraufruf, dessen Wert durch ein Lookup #
                # in der Remember-Tabelle berechnet wurde.     #
 
                if depth < 0 then
                    l[3] := l[3] + 1
                else
                    l[2] := l[2] + 1
                end_if
 
             # Prozedur pname ist noch nicht vorhanden.           #   
             # Initialisiere Laufzeit mit time und Z"ahler mit 1. #
 
             elif depth < 0 then
                    l := [time, 0, 1]
             else
                    l := [time, 1, 0]
             end_if;
            info[pname] := l
      end_proc:

    statistic2 := proc(father, son)
    begin
	if domtype(info2[father][son]) = DOM_INT then
           info2[father][son] := info2[father][son] + 1;
        else
           info2[father][son] := 1
        end_if
    end_proc:

    show_statistic2 := proc()
	local i, j, len1, len2, father, son, PRETTY_PRINT;
    begin
	if domtype(info2) = DOM_IDENT then
           return()
        end_if;
        PRETTY_PRINT:=FALSE;
	print(Unquoted);
	for i in info2 do
            print(Unquoted, "<".op(i,1)."> calls");
	    len1 := max(strlen(op(i,[2,j,1])) $ hold(j) = 1 .. nops(op(i,2)));
	    len2 := max(length(op(i,[2,j,2])) $ hold(j) = 1 .. nops(op(i,2)));
            for j in op(i, 2) do
                print(Unquoted, "   ".rprint(op(j,1), len1)." : ".lprint(op(j,2), len2)." time(s)")
	    end_for;
	    print(Unquoted);
        end_for;
	print(Unquoted);
    end_proc:

    # Aufbereitung des Profile-Protokolls info f"ur die Bild-    #
    # schirmausgabe. Jede Zeile der Ausgabe enth"alt 6 Informa-  #
    # tionen, die an folgendem Beispiel erkl"art werden:         #
    # h: 32.5 % 13 ms total 3 calls 1 lookups 4.3 ms per call    #
    # Die Laufzeit, die direkt in der Prozedur h ben"otigt wurde #
    # betr"agt insgesamt 13 ms. Dies sind 32.5 % der Gesamtlauf- #
    # zeit. Die Prozedur wurde 3-mal aufgerufen. 4.3ms ist daher #
    # daher das Mittel der Laufzeit pro Aufruf der Prozedur h.   #
    # Das Ergebnis eines Aufrufes wurde durch ein Lookup in der  #
    # Remember-Tabelle der Prozedur h berechnet, 2 Ergebnisse    #
    # wurden durch Evaluierung des Prozedurrumpfes berechnet.    #

    show_statistic := proc()
       local PRETTY_PRINT,
             calls, cnt, i, out, time, total, total_time,
             time_seq, time_len, name_len, call_len, rcall_len;
       begin

	   PRETTY_PRINT := FALSE;

           cnt := sort(); # Beachte: info ist nun ein Feld! #

           time_seq := op(info[i], [2,1]) $ i = 1..cnt;
           total_time := _plus(time_seq);
           time_len := length(max(time_seq));
           name_len := max(strlen(op(info[i], 1)) $ hold(i)=1..cnt);
           call_len := length(
              max(op(info[i], [2,2]) + op(info[i], [2,3]) $ hold(i) = 1..cnt));
           rcall_len := length(max(op(info[i], [2,3]) $ hold(i) = 1..cnt));

	   print(Unquoted);
	   if total_time = 0 then
              print("Total time < 10 ms. No timing informations possible.");
              print("----------------------------------------------------");
              for i from cnt downto 1 do
		 calls := op(info[i], [2,2]) + op(info[i], [2,3]);
	         out := rprint(op(info[i], 1),  name_len).":";
	         out := out.lprint(calls, call_len)." call(s) ";
                 out := out.lprint(op(info[i], [2,3]), rcall_len)." lookup(s)";
                 print(Unquoted, out);
              end_for
	   else
	      total := 100.0 / total_time;
	      out := "Total time: ".total_time." ms"; print(Unquoted, out);
              print(Unquoted, format("", strlen(out), "-", TRUE));
              for i from cnt downto 1 do
                 calls := op(info[i], [2,2]) + op(info[i], [2,3]);
                 time := op(info[i], [2,1]);
                 out := rprint(op(info[i], 1),  name_len).":";
                 out := out.lprint(float2string(time*total,1), 5);
                 out := out." % ".lprint(time, time_len)." ms total ";
                 out := out.lprint(calls, call_len)." call(s) ";
                 out := out.lprint(op(info[i], [2,3]), rcall_len)." lookup(s) ";
                 out := out.float2string(float(time/calls),1);
                 out := out." ms/call";
		 print(Unquoted, out);
              end_for
	    end_if
       end_proc:

       # Konvertiere Gleitkommazahl f in eine Zeichenkette. #
       # Die Zeichenkette enth"lat alle Vorkommastellen,    #
       # und digits Nachkommastellen von f.                 #

       float2string := proc(f,digits)
          begin "".trunc(f).".".trunc(frac(f)*10^digits) end_proc:

       # Erzeugt Zeichenkette der L"ange width.               #
       # Ist strlen(string) < width, so wird der rechte Teil  #
       # der Zeichenkette mit fill_pattern aufgef"ullt, falls #
       # falls right = TRUE, sonst der linke Teil.            #  
 
       format := proc(string, width, fill_pattern, right)
           local i;
       begin
           string := "".string;
           for i from 1 to width - strlen(string) do
                 if right then
                     string := string.fill_pattern
                 else
                     string := fill_pattern.string
                 end_if
           end_for;
           string
       end_proc:
 
       rprint := proc(string, width)
          begin format(string, width, " ", TRUE) end_proc:
 
       lprint := proc(string, width)
          begin format(string, width, " ", FALSE) end_proc:
 
       length := proc(f)
            begin ceil(float(ln(f))/ln(10.0)) end_proc:
       length(0) := 1;

       # Sortiere Profile-Protokoll info mittels `straight- # 
       # insertion. Zu diesem Zweck wird die Tabelle info  #
       # in ein Feld umgewandelt (*). Sortiert wird bzgl.   #
       # der Laufzeit der einzelnen Prozeduren.             # 
       # (*) Vor sort(): info[pname] -> [time, calls]       #
       #     Nach  "   : info[i]    -> pname=[time, calls]  #

       sort := proc()
          local cnt, i, j, tmp, x;
          begin 
              cnt := nops(info);
              tmp := array(0..cnt); tmp[1] := op(info, 1);
              for i from 2 to cnt do
                    tmp[i] := op(info, i);  x:= tmp[i]; tmp[0] := x; j := i - 1;
                    while op(x,  [2,1]) < op(tmp[j], [2,1]) do 
                        tmp[j+1] := tmp[j]; j := j -1 
                    end_while;
                    tmp[j+1] := x
               end_for;
               info := tmp; cnt
       end_proc:

    #------------------ Hauptprogramm -------------------#

    if args(0) = 0 then
       return();
    end_if;

    fname := "prof".getpid().".dat";

    # Aufruf des internen generischen Profilers (gprof). #
    # Dieser schreibt die in der Datei PROFILE.README    #
    # beschriebenen Daten in die Datei profile.dat, die  #
    # nun im folgenden aufbereitet werden.               #

    result := gprof(context(args()), fname);

    init(); fd := fopen(fname);
    if fd = FAIL then error("could not open file ".fname) end_if;

    # Der wesentliche Algorithmus, der das Datenfile      # 
    # ausliest, und Laufzeiten der einzelnen Prozeduren   #
    # berechnet und aufbereitet.                          #

    while domtype((l := getline())) <> DOM_NULL do
         pname := l[1]; depth := abs(l[2]); time := l[3]; rtime := time;
         if depth > last_depth then
             push(-last_depth)
         elif depth < last_depth then
                repeat
                    while (t := pop()) >= 0 do
                         rtime := rtime - t;
                         statistic2(pname, pop());
                     end_while
                until -t <> last_depth end_repeat;
               push(t)
         end_if;
	 if rtime < 0 then
            time := time - rtime; rtime:=0;
         end_if;
         last_depth := depth; 
	 push(pname); push(time); 
         statistic(pname, rtime, l[2])
    end_while;
    if domtype(info) <> DOM_TABLE then
       print(Unquoted, "No timing informations available.");
    else
       show_statistic(); show_statistic2();
    end_if;

    gprof(NIL,fname); # Unlink profile #

    print(Unquoted, "");
    result

end_proc:
