# $Date: 1995/06/26 07:14:35 $ $Author: kg $ $Revision: 1.3.4.2 $ #

#++
resultant -- compute the resultant of two polynomials

resultant(p, q [, X] [, x])

p, q - polynomials or expressions
X    - list of indeterminates if p,q are expressions
x    - indeterminate

The resultant is computed via the subresultant algorithm.
++#

resultant:= proc(p, q)
    local x, X, T, i;
begin
    if args(0) < 2 then error("wrong no of args") end_if;

    # allow overloading #
    if domattr(p, "resultant") <> FAIL then
	return(domattr(p, "resultant")(args()))
    end_if;
    if domattr(q, "resultant") <> FAIL then
	return(domattr(q, "resultant")(args()))
    end_if;

    # args = polynomials? #
    if domtype(p) = DOM_POLY then
	T:= op(p,3); X:= op(p,2);
	if domtype(q) <> DOM_POLY then
	    error("no polynomial")
	end_if;
	if T <> op(q,3) or X <> op(q,2) then
	    error("polynomial types differ")
	end_if;
	if args(0) = 3 then
	    x:= args(3);
	    i:= contains(X, x);
	    if i = 0 then error("unknown indet") end_if;
	elif args(0) > 3 then error("wrong no of args")
	else i:= 1; x:= X[1];
	end_if;
	if nops(X) = 1 then
	    return(stdlib::presultant(p, q, stdlib::coeff_division([p, q])))
	end_if;
	X[i]:= NIL;
	T:= Poly(X, T);
	return(stdlib::presultant(poly(p, [x], T), poly(q, [x], T), T::divex));
    end_if;

    # parse args for expressions #
    case args(0)
    of 2 do
	X:= indets([p, q], RatExpr);
	if X = {} then X:= [hold(x)] else X:= [op(X)] end_if;
	x:= X[1];
	break;
    
    of 3 do
	if domtype(args(3)) = DOM_LIST then
	    X:= args(3);
	    x:= X[1];
	else
	    x:= args(3);
	    X:= [op(indets([p, q], RatExpr) union {x})];
	end_if;
	break;

    of 4 do
	X:= args(3);
	x:= args(4);
	if domtype(X) <> DOM_LIST then error("no indets list") end_if;
	break;

    otherwise error("wrong no of args");
    end_case;

    # special cases #
    case type(p)
    of "_mult" do
	return(resultant(op(p,1), q, X, x) *
	       resultant(subsop(p, 1=1), q, X, x));
    of "_power" do
	x:= resultant(op(p,1), q, X, x);
	return((if x = 0 then 0 else x^op(p,2) end_if));
    end_case;

    case type(q)
    of "_mult" do
	return(resultant(p, op(q,1), X, x) *
	       resultant(p, subsop(q, 1=1), X, x));
    of "_power" do
	x:= resultant(p, op(q,1), X, x);
	return((if x = 0 then 0 else x^op(q,2) end_if));
    end_case;

    # convert to polynomials #
    i:= contains(X, x);
    if i = 0 then error("unknown indet") end_if;
    if nops(X) = 1 then
	p:= poly(p, [x]);
	q:= poly(q, [x]);
	if p = FAIL or q = FAIL then return(FAIL) end_if;
	stdlib::presultant(p, q, stdlib::coeff_division([p, q]));
    else
	X[i]:= NIL;
	T:= Poly(X);
	p:= poly(p, [x], T);
	q:= poly(q, [x], T);
	if p = FAIL or q = FAIL then return(FAIL) end_if;
	expr(stdlib::presultant(p, q, T::divex));
    end_if;
end_proc:

#--
presultant -- compute the resultant of two univariate polynomials

presultant(p, q, df)

p, q - univariate polynomials
df   - coefficient division function

The polynomials must be univariate over the same coefficient ring.
If the coefficient ring is a domain then the domain must have the
method 'divex'.
--#

stdlib::presultant:= proc(p, q, df)
    local n, m, h, d, b, t, x, c, g, i;
begin
    # zero polynomials or 0 degree ? #
    if iszero(p) or iszero(q) then
	return((if domtype(op(p,3)) = DOM_DOMAIN then domattr(op(p,3), "zero")
		else 0 end_if))
    end_if;
    m:= degree(p);
    n:= degree(q);
    if n > m then
	p:= stdlib::presultant(q, p, df);
	return((if ((n*m) mod 2) = 1 then -p else p end_if));
    end_if;
    if m = 0 then
	return((if domtype(op(p,3)) = DOM_DOMAIN then domattr(op(p,3), "one")
		else 1 end_if))
    end_if;
    if n = 0 then return(coeff(q)^m) end_if;

    # is the degree of a trailing term > 0 ? #
    x:= op(p, [2,1]);
    d:= degree(nthterm(p, nterms(p)));
    if d > 0 then
	return(coeff(q,x,0)^d *
	    stdlib::presultant(divide(p, poly(x^d,op(p,2..3)), Exact), q, df));
    end_if;
    d:= degree(nthterm(q, nterms(q)));
    if d > 0 then
	p:= coeff(p,x,0)^d *
	    stdlib::presultant(p, divide(q, poly(x^d,op(p,2..3)), Exact), df);
	return((if ((m*d) mod 2) = 1 then -p else p end_if));
    end_if;

    # is there a non-trivial gcd of the degrees of the terms ? #
    d:= { (degree(nthterm(p,i)) $ i=1..nterms(p)),
	  (degree(nthterm(q,i)) $ i=1..nterms(q)) };
    if nops(d) > 1 then d:= igcd(op(d)) else d:= op(d) end_if;
    if d > 1 then
	p:= poly(subs(expr(p), x=x^(1/d)), op(p,2..3));
	q:= poly(subs(expr(q), x=x^(1/d)), op(q,2..3));
	return(stdlib::presultant(p, q, df));
    end_if;

    # compute contents #
    c:= content(p);
    p:= mapcoeffs(p, df, c);
    b:= content(q);
    q:= mapcoeffs(q, df, b);
    c:= c^n * b^m;

    h:= (if domtype(op(p,3)) = DOM_DOMAIN then domattr(op(p,3), "one")
         else 1
         end_if);

    # compute subresultant PRS #
    b:= h;
    g:= h;
    while n > 0 do
	d:= m - n;
	if ((m*n) mod 2) = 1 then b:= -b end_if;
	t:= pdivide(p, q, Rem);
	p:= q;
	q:= t;
	m:= n;
	n:= degree(q);
	q:= mapcoeffs(q, df, g*h^d);
	g:= coeff(p, x, m);
	case d
	of 0 do
	    break;
	of 1 do
	    h:= g; break;
	otherwise
	    h:= df(g^d, h^(d-1)); break;
	end_case;
    end_while;
    q:= coeff(q);
    if m = 1 then return(c * b * q) end_if;
    c * b * q * df(q, h)^(m-1)
end_proc:


#--
stdlib::coeff_division -- return coefficient division function

stdlib::coeff_division(l)

l - non-empty list of polynomials of same type

Returns the 'best' coefficient division function for the polynomials
in l.
--#

stdlib::coeff_division:= fun((
    op(args(1)[1], 3);
    if domtype(%) = DOM_DOMAIN then
	domattr(%, "divex");
	if % = FAIL then error("method 'divex' missing") else % end_if
    elif % = hold(Expr) then
        if gcdlib::coeff_type(args(1)) = DOM_EXPR then
            # test for polynomial coeffs #
            poly(_plus(op(map(args(1), coeff))));
            if % <> FAIL then
                eval(subs(hold(fun(divide(args(1), args(2), X, Exact))), 
                	  hold(X)=op(%,2)))
            else
                fun(normal(args(1) / args(2)))
            end_if
        else
            # numerical coeffs only #
            fun(args(1) / args(2))
        end_if;
    else
	fun(args(1) / args(2))
    end_if
)):

# end of file #
