# #
# $Date: 1995/06/09 17:31:20 $ $Author: frankp $ $Revision: 1.15 $ #

simplify := proc(e,f)
    local t;
begin
    case args(0)
    of 2 do if traperror((f:=funcattr(simplify,expr2text(op(f,2)))))=0 then 
		if f<>FAIL then return(normal(f(e))) end_if;
                error("invalid second argument");
            end_if;
    of 1 do break;
    otherwise error("wrong no of args")
    end_case;

    # is overloaded ? #
    if e::simplify <> FAIL then return( e::simplify(args()) ) end_if;

    case domtype(e)
    of DOM_INT     do
    of DOM_RAT     do
    of DOM_FLOAT   do
    of DOM_COMPLEX do return( e )
    of DOM_POLY	   do return( mapcoeffs(e,simplify) )
    of Puiseux	   do return( map(e,simplify) )
    of DOM_LIST    do 
    of DOM_ARRAY   do
    of DOM_SET     do return( map(e,simplify) )
    of DOM_EXPR    do
        t := op(e,0);
        if domtype(level(t,2)) = DOM_FUNC_ENV then
            if funcattr(level(t,2),"simplify") <> FAIL then
                return( funcattr(level(t,2),"simplify")(op(e)) )
            end_if
        end_if;
	e:=map(e,simplify);
    end_case;
    e
end_proc:

simplify:=funcattr(simplify,"sqrt",radsimp):

#--
simplify(e,exp) -- simplifies expressions containing exponentials
                          with algebraic dependencies, for example exp(x)
                          and exp(x/2), by substituting with new variables,
                          calling normal, and substituting back.
--#

simplify:=funcattr(simplify,"exp",proc(a)
local l,e,i,m,j,found,invs,s;
begin
   l:=[]; # list of arguments of exponentials #
   m:=[]; # list of substituted variables #
   s:=[]; # list of substitutions #
   for e in indets(a,RatExpr) do
      if type(e)="exp" then
         found:=FALSE;
         for j from 1 to nops(l) do
            i:=op(e)/l[j];
            if contains({DOM_INT,DOM_RAT},type(i)) then
               if abs(i)>1 then s:=append(s,e=m[j]^i)
               else
                  s:=subs(s,m[j]=m[j]^(1/i));
                  s:=append(s,e=m[j]);
                  l[j]:=op(e);
               end_if;
               found:=TRUE; break
            end_if
         end_for;
         if not found then
            l:=append(l,op(e));
            j:=genident();
            m:=append(m,j);
            s:=append(s,e=j);
         end_if
      end_if;
   end_for;
   a:=normal(subs(a,s));
   for j from 1 to nops(l) do a:=subs(a,m[j]=exp(l[j])) end_for;
   a
end_proc):

_power:=funcattr(_power,"simplify",proc(a,b)
local q,l,i,p,aa,k,eps;
begin
   a:=simplify(a);
   if type(a)="_mult" then
      p:=1; aa:=1;
      for q in a do
         if testtype(q,Type::Constant) then
            if float(q)>=0 then p:=p*simplify(q^b)
            else p:=p*simplify((-q)^b); aa:=-aa;
            end_if;
         else aa:=aa*q
         end_if;
      end_for;
      return(p*aa^b)
   end_if;
   if type(a)=DOM_INT and type(b)=DOM_RAT then
      q:=op(b,2); # denominator #
      # first tries to decompose the exponent #
      l:=ifactor(q);
      # invariant: result = (a^b)^eps #
      if b>0 then a:=a^op(b,1); eps:=1 else a:=a^(-op(b,1)); eps:=-1 end_if;
      b:=eps/q;
      for i from 1 to nops(l) div 2 do
         p:=l[2*i]; k:=l[2*i+1];
         repeat
            # is a^(1/p) an integer ? #
            aa:=round(a^(1/p));
            if a=aa^p then a:=aa; b:=b*p; k:=k-1 else break end_if;
         until k=0 end_repeat;
      end_for;
      # now tries to factor a #
      if isprime(a) then return(a^b)
      else
         l:=ifactor(a);
         a:=l[1]; # integer factor #
         for i from 1 to nops(l) div 2 do
            p:=l[2*i]; k:=l[2*i+1];
            a:=a*p^(k*b)
         end_for;
         return(a)
      end_if;
   end_if;
   a^b
end_proc):
