PRETTY_PRINT:=FALSE:

testfactor := proc(p,n) # n is the number of factors #
local q,m,i,st;
begin
   print("Factoring ",p);
   st:=time();
   if traperror((q:=factor(p)))<>0 then
      error("during the factorization")
   end_if;
   st:=time()-st;
   m:=_plus(op(q,2*i+1)$i=1..(nops(q) div 2));
   if m<>n then print(q,n); error("wrong number of factors") end_if;
   m:=multcoeffs(_mult(op(q,2*i)^op(q,2*i+1)$i=1..(nops(q) div 2)),op(q,1));
   if type(p)=DOM_POLY then
      if not iszero(p-m) then print(p-m); error("product of factors does not match") end_if;
   else
      if expand(p-m)<>0 then print(expand(p-m)); error("product of factors does not match") end_if;
   end_if;
   st
end_proc:

testfactor(poly(x^12+x+1,IntMod(101)),3);

# from book with Salvy and Gomez #
p:=x^14+3*x^13+3*x^12+x^11-x^3-3*x^2-3*x-1:
testfactor(p,5); # 3.4s in 1.2.1, now #

# from Mma book, page 7 #
p:=(x+y)^2+9*(2+x)*(x+y):
p:=expand(p^3):
testfactor(p,6); # 2.3s in 1.2.1 #

# from Mma book, page 56 #
testfactor(x^2+2*x+1,2); # 0.2s in 1.2.1 #
p:=expand((1+x+3*y)^4):
testfactor(p,4); # 0.7s in 1.2.1 #
testfactor(x^10-1,4); # 0.2s in 1.2.1 #

# from Mma book, page 381 #
p:=(2+4*x^2)^2*(1-x)^3:
p:=expand(p):
testfactor(p,5); # 0.6s in 1.2.1 #

# from Mma book, page 389 #
t:=expand(2*(1+x)^2*(2+x)*(3+x)):
testfactor(t,4); # 0.4s in 1.2.1 #

# from Mma book, page 390 #
testfactor(x^6-1,4); # 0.2s in 1.2.1 #

#  from Mma book, page 392 #
testfactor(poly((1+x^2)*(1+x^4),[x],IntMod(2)),6); # 0.5s in 1.2.1 #

testfactor(x[1]-x[2],1); # PR24, gave an extra factor x^0 in 1.2.1 #

p2:=expand((4-4*x+3*x^3)*(-6+7*x-7*x^2+5*x^3)*(-7+4*x-7*x^2-5*x^3+8*x^4)
	*(-3-6*x-7*x^2+6*x^3+3*x^4)):
testfactor(p2,4); # 13.4s in 1.2.1, 8.4s in dmupad # 

p6:=expand((x^25+x^17+11*x^5+12)*(x^26+47*x^18+19*x^6+81)):
testfactor(p6,2); # 48.8s in 1.2.1, 42.4s in dmupad #

p7:=expand((x^33-1)*(x^31-1)):
testfactor(p7,6); # 58.5s in 1.2.1, 52.1s in dmupad #

testfactor(x[1]^2+2*x[1]+1,2); # PR23, gave Recursive definition in 1.2.1 #

# From ys@cicg-calcul.grenet.fr Yvon SIRET #

a1:=w^4*x^5*y^6-w^4*z^3+w^2*x^3*y+x*y^2*z^2:
a2:=w^4*z^6-w^3*x^3*y-w^2*x^2*y^2*z^2+x^5*z-x^4*y^2+y^2*z^3:
a3:=-x^5*z^3+x^2*y^3+y*z:
p:=expand(a1*a2*a3):
testfactor(p,3);

a:=78+17*x+72*x^2-99*x^3-85*x^4-86*x^5+30*x^6+80*x^7+72*x^8+66*x^9-29*x^10-91*x^11- 
 53*x^12-19*x^13-47*x^14+68*x^15-72*x^16-87*x^17+79*x^18+43*x^19-66*x^20-53*x^21- 
 61*x^22-23*x^23-37*x^24+31*x^25-34*x^26-42*x^27+88*x^28-76*x^29-65*x^30+25*x^31+ 
 28*x^32-61*x^33-60*x^34+9*x^35+29*x^36-66*x^37-32*x^38+78*x^39+39*x^40+94*x^41+ 
 68*x^42-17*x^43-98*x^44-36*x^45+40*x^46+22*x^47+5*x^48-88*x^49-43*x^50:

testfactor(poly(a,[x],IntMod(2)),6); # 16.7s in dmupad, now 15.3s #
testfactor(poly(a,[x],IntMod(3)),5); # 11.7s in dmupad, now 8.8s (mean over 5) #
testfactor(poly(a,[x],IntMod(5)),5); # 13.5s in dmupad, now 11.0s (mean over 5) #
testfactor(poly(a,[x],IntMod(7)),5); # 18.5s in dmupad, now 15.2s (mean over 5) #

p:=poly(x^11+x+1,[x],IntMod(6449)):
testfactor(p,6); # 2s in MuPAD, 0.2s in Maple #
p:=poly(x^11+x+1,[x],IntMod(10007)):
testfactor(p,3); # 1.5s in MuPAD, 0.05 in Maple #
p:=poly(x^11+x+1,[x],IntMod(100003)):
testfactor(p,5); # 6s in MuPAD, 1.9s in Maple #
p:=poly(x^11+x+1,[x],IntMod(1000003)):
testfactor(p,5); # 2.4s in MuPAD, 0.8s in Maple #
p:=poly(x^11+x+1,[x],IntMod(10000019)):
testfactor(p,5); # 3.4s in MuPAD, 1.3s in Maple #
p:=poly(x^11+x+1,[x],IntMod(100000007)):
testfactor(p,4); # 5.1s in MuPAD, 1.9s in Maple #
p:=poly(x^11+x+1,[x],IntMod(1000000007)):
testfactor(p,3); # 5.4s in MuPAD, 1.9s in Maple #
p:=poly(x^11+x+1,[x],IntMod(10000000019)):
testfactor(p,4); # 5.4s in MuPAD, 1.9s in Maple #

# PR 12 #
testfactor(x*y^2 - x^2*y - x*z^2 + x^2*z + y*z^2 - y^2*z,3);

# PR 14 #
a:=NIL:
testfactor(k^4+2*a*b*k^2-a^2*k^2-b^2*k^2,4);

testfactor(k*2^n,1);

testfactor(a^2*k-2*a*k+k,3);

# used to produce Illegal argument [Dpoly] #
factor(1/(n*(-2)-3)*(binomial(n*2 + 1, n)*16 + n*binomial(n*2 + 1, n)*24 + n^2*bi\
nomial(n*2 + 1, n)*8));
factor(binomial(n*2+1,n)*16+n*binomial(n*2+1,n)*24+n^2*binomial(n*2+1,n)*8);

Factor(1+1/x); # PR 22 #

p:=bin(0, 0)*243 + n*bin(0, 0)*405 + a^2*bin(0, 0)*(-54) + a^4*bin(0, 0)*3 + \
n^2*bin(0, 0)*270 + n^3*bin(0, 0)*90 + n^4*bin(0, 0)*15 + n^5*bin(0, 0) + \
a^2*n*bin(0, 0)*(-54) + a^4*n*bin(0, 0) + a^2*n^2*bin(0, 0)*(-18) + a^2*n^\
3*bin(0, 0)*(-2):
factor(p);

if domtype(factor(x^2-1)[2])<>DOM_EXPR then error("factor(expr) should be an expr") end_if;
if domtype(factor(poly(x^2-1))[2])<>DOM_POLY then error("factor(poly) should be a poly") end_if;

if type(Factor(poly(x^2-1)))<>"_mult" then error("Factor") end_if;

f:=1/(x-w): 
g:=eval(Factor(f)):
if normal(f-g)<>0 then error("Factor") end_if;
f:=1/(w-x):
g:=eval(Factor(f)):
if normal(f-g)<>0 then error("Factor") end_if;

p:=1/(-w + x)*((w*x^2-w^2*x + y^2*(-w + x) + y*(w^2-x^2))*(w*x^3-w^3*x + z^3*\
(-w + x) + z*(w^3-x^3))-(w*x^2-w^2*x + z^2*(-w + x) + z*(w^2-x^2))*(w*x^3-\
w^3*x + y^3*(-w + x) + y*(w^3-x^3))):
if normal(Factor(p)-Factor(normal(p)))<>0 then error("Factor") end_if;

quit
