# $Date: 1994/11/22 10:22:01 $  $Author: kg $  $Revision: 1.2 $ #

#++
Constant -- expression to test for constant expressions

Constant

This type expressions allows to test for a constant expression.
A constant expression is either a literal constant, an identifier
which is _not_ contained in the set 'Type::ConstantIdents' or an
expression where each operand is constant (with one exception:
an indexed identifier is constant when the indices are constant,
ie. x[2] is a constant).
++#

Type::Constant:=

    new(Type,
	hold(Constant),
	proc(t,x) begin
	    if args(0) <> 2 then return(FALSE) end_if;
	    case domtype(x)
	    of DOM_IDENT do
		if contains(Type::ConstantIdents, x) then return(TRUE) end_if;
		return(FALSE);

	    of DOM_EXPR do
		if op(x,0) = hold(_index) then
		    t:= map([op(x, 2..nops(x))], testtype, Type::Constant);
		else
		    t:= map([op(x)], testtype, Type::Constant);
		end_if;
		if contains(t, FALSE) <> 0 then return(FALSE) end_if;
		if contains(t, FAIL) <> 0 then return(FAIL) end_if;
		return(TRUE);

	    of DOM_INT do
	    of DOM_RAT do
	    of DOM_FLOAT do
	    of DOM_COMPLEX do
	    of DOM_STRING do
	    of DOM_BOOL do
	    of DOM_POINT do
	    of DOM_POLYGON do
	    of DOM_NIL do
	    of DOM_NULL do
	    of DOM_FAIL do
		return(TRUE);
	    end_case;
	    FAIL
	end_proc,
	FALSE, FALSE):

Type::ConstantIdents:= { hold(E), hold(PI), hold(EULER) }:

# end of file #
