# $Date: 1994/11/28 13:07:52 $  $Author: kg $  $Revision: 1.2 $ #

#++
PolyExpr -- returns type expression to test polynomial expressions

PolyExpr(x [,T])

x - unknown
T - coefficient type (default is 'Type::AnyType')

The type expression created returns TRUE if an expression is a polynomial
expression with unknown 'x' and coefficients of type 'T'.
++#

Type::PolyExpr:= proc(x,T)
    local p;
begin
    if testargs() then
	case args(0)
	of 1 do break;
	of 2 do
	    if Type::isSeqType(T) then
		error("can't test for sequences")
	    end_if;
	    break;
	otherwise error("wrong no of args");
	end_case;
	if traperror((p:= poly(1,[x]))) <> 0 then
	    error("illegal indeterminate")
	end_if;
	if p = FAIL then
	    error("illegal indeterminate")
	end_if;
    end_if;

    new(Type,
	hold(PolyExpr),
	proc(t,x)
	begin
	    if args(0) <> 2 then return(FALSE) end_if;
	    x:= poly(x, [t[1]]);
	    if x = FAIL then return(FALSE) end_if;
	    x:= [ coeff(x) ];
	    if has(x, t[1]) then return(FALSE) end_if;
	    if nops(t) = 1 then
		TRUE
	    else
		testtype(x, Type::ListOf(t[2]))
	    end_if
	end_proc,
	[args()], FALSE)
end_proc:

