# Substitutionsgleichungen #

sub(hold(sin))  :=proc(x) begin 1/(2*I)*(exp(x*I)-exp(-x*I))      end_proc:
sub(hold(cos))  :=proc(x) begin 1/2*(exp(x*I)-exp(-x*I))          end_proc:
sub(hold(asin)) :=proc(x) begin -I*ln(I*x+sqrt(1-x^2))            end_proc:
sub(hold(acos)) :=proc(x) begin -I*ln(x+sqrt(x^2-1))              end_proc:
sub(hold(tan))  :=proc(x) begin -I*(exp(x*I)-exp(-x*I))/(exp(x*I)+exp(-x*I))
								  end_proc:
sub(hold(atan)) :=proc(x) begin -I*1/2*ln((1+I*x)/(1-I*x))        end_proc:
sub(hold(sinh)) :=proc(x) begin 1/2*(exp(x)-exp(-x))              end_proc:
sub(hold(cosh)) :=proc(x) begin 1/2*(exp(x)+exp(-x))              end_proc:
sub(hold(tanh)) :=proc(x) begin (exp(x)-exp(-x))/(exp(x)+exp(-x)) end_proc:
sub(hold(asinh)):=proc(x) begin ln(x+sqrt(x^2+1))                 end_proc:
sub(hold(acosh)):=proc(x) begin ln(x+sqrt(x^2+1))                 end_proc:#+/-#
sub(hold(atanh)):=proc(x) begin 1/2*ln((1+x)/(1-x))               end_proc:
sub(hold(cot))  :=proc(x) begin I*(exp(x*I)+exp(-x*I))/(exp(x*I)-exp(-x*I))
								  end_proc:
sub(hold(acot)) :=proc(x) begin I*1/2*ln((x*I+1)/(x*I-1))         end_proc:
sub(hold(coth)) :=proc(x) begin (exp(x)+exp(-x))/(exp(x)-exp(-x)) end_proc:
sub(hold(acoth)):=proc(x) begin 1/2*ln((x+1)/(x-1))               end_proc:

sub(hold(_power)):=proc(a,b) begin if contains(indets(b),x) then exp(b*ln(a))
                                                            else a^b 
                                   end_if; end_proc:

# substitution der Funktionen exp und ln fuer sin,cos,.. #
subst:=proc(a)
  local L,i;
begin
#  L:=op(a);
  L:=(L[i]:=subst(L[i]) $ i=1..nops(L));#
  L:=null();
  for i in a do
    if op(i,0) = FAIL 
      then L:=L,i;
      else L:=L,subst(i);
    end_if; 
  end_for;
  case op(a,0)
    of hold(ln)    do;
    of hold(exp)   do;
    of hold(_plus) do;
    of hold(_mult) do return(op(a,0)(L));
    of FAIL do return(a);
    otherwise sub(op(a,0))(L);
  end_case;
end_proc:

# Vereinfachungen fuer die Funktionen exp und ln #
simpl:=proc(a)
  local L,LL,i,j;
begin
  L:=null();
  for i in a do
    if op(i,0) = FAIL 
      then L:=L,i;
      else L:=L,simpl(i);
    end_if; 
  end_for;
  case op(a,0)
    of hold(ln)
      do case op(L,0) 
           of hold(_mult)  do return(simpl(_plus(seq(ln(i),i=L))));
           of hold(_power) do return(simpl(op(L,2)*ln(op(L,1))));#?#
           of hold(exp)    do return(op(L));
           otherwise          return(ln(L));
         end_case;
    of hold(exp)
      do case op(L,0)
           of hold(_plus) do return(simpl(_mult(seq(exp(i),i=L))));
           of hold(_mult) do LL:=null();j:=1;
                             for i in L do
                               if testtype(i,DOM_INT)  # Numeric #
                                 then j:=j*i;
                                 else LL:=LL,i;
                               end_if;
                             end_for;
                             if j=1
                               then return(exp(L));
                               else return(_power(simpl(exp(_mult(LL))),j));
                             end_if;
           of hold(ln)    do return(op(L));
           otherwise         return(exp(L));
         end_case;
    of FAIL do return(a);
    otherwise  return(op(a,0)(L));
  end_case;
end_proc:

# Aufbau des Koerperturmes und substitution der ln- und exp-Terme #
tower:=proc(a)
  local i,L;
# global turm,turms,k,x; #
begin
  L:=null();
  for i in a do
    if op(i,0) = FAIL 
      then L:=L,i;
      else L:=L,tower(i);
    end_if; 
  end_for;
  case op(a,0)
    of hold(ln)   do;
    of hold(exp)  do;
    of hold(tan)  do;
    of hold(atan) do i:=contains(turm,op(a,0)(L));
                     if i>0 then return(x.i)
                            else # towermin(op(a,0)(L));#
                                 turm:=append(turm,op(a,0)(L));
                                 k:=k+1;
                                 turms:=append(turms,
                                 op(a,0)(subs((L),x.i=turm[i]$hold(i)=1..k-1)));
                                 return(x.k);
                     end_if;
    of hold(_plus)  do return(op(a,0)(L));
    of hold(_mult)  do return(op(a,0)(L));
    of hold(_power) do return(op(a,0)(L));
    of FAIL         do return(a);
    otherwise print(op(a,0)(L)); error("Unexpected Operator");
  end_case;
end_proc:

# Umwandlung von Ausdruecken in Zaehler und Nenner #
rat:=proc(a)
  local Z,N,i;
begin
  case domtype(a)
    of DOM_EXPR do
	      N:=1;
	      case op(a,0)
	  	of hold(_plus)  do Z:=0;
				   for i in a do
				     rat(i);
				     Z:=Z*op(%1,2)+N*op(%1,1);
				     N:=N*op(%2,2);
				   end_for; break;
		of hold(_mult)  do Z:=1;
				   for i in a do
				     rat(i);
				     Z:=Z*op(%1,1);
				     N:=N*op(%2,2);
				   end_for; break;
		of hold(_power) do rat(op(a,1)); op(a,2);
				   if domtype(%1)<>DOM_INT
				     then error("Unexpected Operand in POWER");
				     elif %1>0
				       then Z:=op(%2,1)^%1;
					    N:=op(%3,2)^%2;
				       else Z:=op(%2,2)^(-%1);
					    N:=op(%3,1)^(-%2);
				   end_if; break;
		otherwise error("Unexpexted operator");
	      end_case; return(Z,N);
    of DOM_INT     do;
    of DOM_RAT     do;
    of DOM_COMPLEX do;
    of DOM_IDENT   do return(a,1); break;
    otherwise error("Illegal Datatype");
  end_case;
end_proc:


# generates a random polynomiyal over Z with degree deg in the indeterminate x #
polrandomz:= proc(deg,x)
  local i;
begin
  if testargs()
    then if args(0) <> 2 then error("wrong number of arguments") end_if;
         if not(testtype(deg,DOM_INT) and testtype(x,DOM_IDENT))
           then error("wrong parameter type") end_if;
         if deg < 0 then error("degree must be >= 0") end_if;
  end_if;
  poly(_plus((repeat (random()-2^14)*x^deg until %<>0 end_repeat)
             ,((random()-2^14)*x^i $i=0..deg-1)),[x]);
end_proc:

# generates a random polynomiyal over Q with degree deg in the indeterminate x #
polrandomq:= proc(deg,x)
  local i;
begin
  if testargs()
    then if args(0) <> 2 then error("wrong no of args") end_if;
         if not(testtype(deg,DOM_INT) and testtype(x,DOM_IDENT))
           then error("wrong parameter type") end_if;
         if deg < 0 then error("parameter must be >= 0") end_if;
  end_if;
  poly(_plus(
    (repeat(random()-2^14)/
     (repeat(random()-2^14) until %<>0 end_repeat)*x^deg until %<>0 end_repeat),
    ((random()-2^14)/
     (repeat(random()-2^14) until %<>0 end_repeat)*x^i$i=0..deg-1)
              ),[x]);
end_proc:

# integration of a polynomial #
polint:= proc(p)
  local i,v;
begin
  if testargs()
    then if not(testtype(p,DOM_POLY)) then error("not a polynomial") end_if;
         if nops(op(p,2))>1 then error("polynomial in one variable expected")
         end_if;
  end_if;
  v:=op(p,2);
  poly(_plus(coeff(p,i-1)/i*v[1]^i $i=1..degree(p)+1),v);
end_proc:

# GCD of two polynomials #
polgcd:= proc(a,b)
  local c,d,r;
begin
  c:= multcoeffs(a,1/lcoeff(a)); d:= multcoeffs(b,1/lcoeff(b));
  while not iszero(d) do
    r:= divide(c,d,Rem);
    c:= d; d:= r;
  end_while;
  multcoeffs(c,1/lcoeff(c));
end_proc:

# GCD of two polynomials #
polgcd2:= proc(a,b)
  local c,d,r;
begin
  c:= multcoeffs(a,1/lcoeff(a)); d:= multcoeffs(b,1/lcoeff(b));
  while not iszero(d) do
    r:= divide(c,d,Rem);
    r:=mapcoeffs(r,sicoefff);
    c:= d; d:= r;
  end_while;
  mapcoeffs(multcoeffs(c,1/lcoeff(c)),sicoefff);
end_proc:

# primitive Euclidean algorithm #
polpgcd:= proc(a)
  local b,cont,rem,v,i;
begin
  if testargs()
    then if not(_and(testtype(args(i),DOM_POLY) $i=1..args(0) ))
           then error("the arguments must be polynomials") end_if;
         v:=op(args(1),2);
         if not(_and(v=op(args(i),2) $i=1..args(0) ))
           then error("incompatible variables") end_if;
  end_if;
if iszero(a) then a:=args(2) end_if;
  v:= op(a,2);
  primpart(a); a:=%[1]; cont:=[%2[2]];
  for i from 2 to args(0) do
    primpart(args(i)); b:=%[1]; cont:=cont.[%2[2]];
    while not iszero(b) do
      rem:=poly(pdivide(poly(a,[v[1]]),poly(b,[v[1]]),Rem),v);
      a:=poly(b,v); b:=primpart(rem)[1];
    end_while;
  end_for;
  if nops(v)>1
    then a:=a*poly(polpgcd(op(cont)),v);
    else b:=TRUE;			# nesseary for rational coefficients #
         for i in cont do
           if type(i)=DOM_RAT then b:=FALSE; break end_if;
         end_for;
         if b then if nops(cont)=1
                     then a:=multcoeffs(a,cont[1]);
                     else a:=multcoeffs(a,igcd(op(cont)));
                   end_if;
              else# print("Warning: rational coefficients in content");#
                   a;
              #else a:=multcoeffs(a,1/lcoeff(a));#
         end_if;							# ** #
					# nessesary for integer coefficients #
#   elif nops(cont)=1			
      then a:=multcoeffs(a,cont[1]);
      else a:=multcoeffs(a,igcd(op(cont)));#				# ** #

  end_if;
end_proc:

# primitive part #
# returns primitive part and content #
primpart:= proc(a)
  local v,vv,c,i;
begin
#  if testargs()
    then if not(testtype(a,DOM_POLY))
           then error("the arguments must be polynomials") end_if;
  end_if;#
  if iszero(a) then return(a,1) end_if;
  v:=op(a,2);
  if nops(v)>1 then vv:= v; vv[1]:= NIL;
                    a:= poly(a,[op(v,1)]);
                    c:= polpgcd(poly(nthcoeff(a,i),vv) $ i=1..nterms(a));
                    a:= divide(poly(a,v),poly(c,v),Exact);
                    a:= multcoeffs(a,sign(lcoeff(a)));
               else c:=icontent(a);
                    a:=multcoeffs(a,sign(lcoeff(a))/c);
  end_if;
  return(a,c);
end_proc:

# extendet Euclidean algorithm #
# computes gcd(a,b),s and t such that a*s + b*t = gcd(a,b) #
# Geddes Algorithm 2.2 # 
polgcdex:= proc(a,b)
  local c1,c2,d1,d2,r,r1,r2,v,l,la,lb;
begin
  v:=op(a,2); la:=1/lcoeff(a); lb:=1/lcoeff(b);
  a:=multcoeffs(a,la); b:=multcoeffs(b,lb);
  c1:=poly(1,v); d2:=c1; d1:=poly(0,v); c2:=d1;
  while not iszero(b) do
    r:= divide(a,b); 
    r1:= c1-r[1]*d1; r2:= c2-r[1]*d2;
    a:= b; c1:= d1; c2:= d2;
    b:= r[2]; d1:= r1; d2:= r2;
  end_while;
  l:= 1/lcoeff(a);
  return(multcoeffs(a,l),multcoeffs(c1,l*la),multcoeffs(c2,l*lb));
end_proc:

# extendet Euclidean algorithm #
# computes gcd(a,b),s and t such that a*s + b*t = gcd(a,b) #
# Geddes Algorithm 2.2 # 
polgcdex2:= proc(a,b)
  local c1,c2,d1,d2,r,rr,r1,r2,v,l,la,lb;
begin
  v:=op(a,2); la:=1/lcoeff(a); lb:=1/lcoeff(b);
  a:=multcoeffs(a,la); b:=multcoeffs(b,lb);
  c1:=poly(1,v); d2:=c1; d1:=poly(0,v); c2:=d1;
  while not iszero(b) do
    r:= divide(a,b);
    rr:=mapcoeffs(r[2],sicoefff); r:=mapcoeffs(r[1],sicoefff);
    r1:= c1-r*d1; r2:= c2-r*d2;
    a:= b; c1:= d1; c2:= d2;
    b:= rr; d1:= r1; d2:= r2;
  end_while;
  l:= 1/lcoeff(a);
  return(mapcoeffs(multcoeffs(a,l),sicoefff),
         mapcoeffs(multcoeffs(c1,l*la),sicoefff),
         mapcoeffs(multcoeffs(c2,l*lb),sicoefff));
end_proc:


# Square-free Factorization #
sqff:= proc(a)
  local i,b,c,w,y,z,out;
begin
  i:= 1; out:=[]; b:=diff(a,op(a,[2,1]));      # #
  c:= polgcd(a,b);
  w:= divide(a,c,Quo);
  while c<>poly(1,op(a,2)) do
    y:= polgcd(w,c); 
    z:= divide(w,y,Quo);
    if z<>poly(1,op(a,2)) then out:= append(out,z,i) end_if;
    i:= i+1;
    c:= divide(c,y,Quo);
    w:= y;
  end_while;
  append(out,w,i);
end_proc:

# Quadratfreie Zerlegung liefert Tabelle #
sqfft:= proc(a)
  local i,b,c,w,y,z,out;
begin
  i:= 1; b:=diff(a,op(a,[2,1]));
  c:= polgcd(a,b);
  w:= divide(a,c,Quo);
  while c<>poly(1,op(a,2)) do
    y:= polgcd(w,c); 
    z:= divide(w,y,Quo);
    if degree(z)>0 then out[i]:=z;
                   else out[i]:=poly(1,op(a,2));
    end_if;
    i:= i+1;
    c:= divide(c,y,Quo);
    w:= y;
  end_while;
  out[i]:=w;
  return(out);
end_proc:

# Quadratfreie Zerlegung liefert Tabelle #
sqfft2:= proc(a)
  local i,b,c,w,y,z,out;
begin
  i:= 1; b:=diff(a,op(a,[2,1]));
  c:= polgcd2(a,b);
  w:= divide(a,c,Quo);
  w:=mapcoeffs(w,sicoefff);
  while c<>poly(1,op(a,2)) do
    y:= polgcd2(w,c); 
    z:= divide(w,y,Quo);
    z:=mapcoeffs(z,sicoefff);
    if degree(z)>0 then out[i]:=z;
                   else out[i]:=poly(1,op(a,2));
    end_if;
    i:= i+1;
    c:= divide(c,y,Quo);
    c:=mapcoeffs(c,sicoefff);
    w:= y;
  end_while;
  out[i]:=w;
  return(out);
end_proc:

# loesen der Diophantischen Gleichung sa+tb=c, gcd(a,b)=1 #
dio1:= proc(c,a,b)
  local s,t;
begin
  polgcdex(a,b);
  s:= op(%1,2); t:= op(%2,3); 
  s:= divide(s*c,b); #t:= divide(t*c,a,Rem);# t:=t*c+op(s,1)*a;
  return(t,op(s,2));
end_proc:

# loesen der Diophantischen Gleichung sa+tb=c, gcd(a,b)=1 #
dio2:= proc(c,a,b)
  local s,t;
begin
  polgcdex2(a,b);
  s:=op(%1,2); t:=op(%2,3); 
  s:=mapcoeffs(divide(s*c,b,Rem),sicoefff);
  t:=mapcoeffs(divide(t*c,a,Rem),sicoefff);
  return(t,s);
end_proc:


# Quadratfreie Zerlegung und Parialbruchzerlegung #
sqffpf:= proc(b,a)
  local i,c,w,y,z,R,k,m,n;
begin
  i:= 1; k:= 1; m:= b; n:= a;
  c:= polgcd(a,diff(a,op(a,[2,1])));
  w:= divide(a,c,Quo);
  while c<>poly(1,op(a,2)) do
    y:= polgcd(w,c); 
    z:= divide(w,y,Quo);
    if z<>poly(1,op(a,2)) then
      R[k,0,0]:= i; R[k,0,1]:= z;
      pf(i,z);
      k:= k+1;
    end_if;
    i:= i+1;
    c:= divide(c,y,Quo);
    w:= y;
  end_while;
  R[k,0,0]:= i; R[k,0,1]:= w; R[0,0,0]:= k;
  pf(i,w);
  return(R);
end_proc:

# Quadratfreie Zerlegung und Parialbruchzerlegung #
sqffpf2:= proc(b,a)
  local i,c,w,y,z,R,k,m,n;
begin
  i:= 1; k:= 1; m:= b; n:= a;
  c:= polgcd2(a,diff(a,op(a,[2,1])));
  w:= divide(a,c,Quo);
  w:=mapcoeffs(w,sicoefff);
  while c<>poly(1,op(a,2)) do
    y:= polgcd2(w,c); 
    z:= divide(w,y,Quo);
    z:=mapcoeffs(z,sicoefff);
    if z<>poly(1,op(a,2)) then
      R[k,0,0]:= i; R[k,0,1]:= z;
      pf(i,z);
      k:= k+1;
    end_if;
    i:= i+1;
    c:= divide(c,y,Quo);
    c:=mapcoeffs(c,sicoefff);
    w:= y;
  end_while;
  R[k,0,0]:= i; R[k,0,1]:= w; R[0,0,0]:= k;
  pf(i,w);
  return(R);
end_proc:

# Partialbruchzerlegung #
pf:= proc(i,z)
  local j,l,q,r;
begin
  q:= poly(1,op(a,2)); l:= 1;
  n:= divide(n,z^i,Quo);
  dio1(m,z^i,n);
  r:=op(%1,1);m:=op(%2,2);
  R[k,0]:= r;
  for j from i-1 downto 1 do
        divide(r,z^j);
        R[k,l]:= op(%1,1);
        r:= op(%2,2);
        l:=l+1;
  end_for;
  R[k,l]:= r;
end_proc:

# Reduktion des Integrals mit der Methode von Hermite #
hermit3:= proc(p,q)
  local rp,ip,R,polpart,n,i,j;
begin
  if iszero(p) then return(0,0) end_if;
  ip:=0;rp:=0;
  1/lcoeff(q);
  p:= multcoeffs(p,%1); q:= multcoeffs(q,%2);
  divide(p,q);
  polpart:= polint(op(%1,1));
 # R:=sqffpf(op(%2,2),q); R:=sqffpf(p,q);# p:=op(%2,2); R:=sqffpf(p,q);
  for i from 1 to R[0,0,0] do
    ip:= ip+expr(R[i,1])/expr(R[i,0,1]);
    for j from 2 to R[i,0,0] do
      n:= j;
      while n>1 do
        dio1(R[i,n],R[i,0,1],diff(R[i,0,1],op(R[i,0,1],[2,1])));
        t:= op(%1,1); s:= op(%2,2);
        n:= n-1;
        rp:= rp-expr(multcoeffs(t,1/n))/expr(R[i,0,1]^n);
        R[i,n]:= s+multcoeffs(diff(t,op(t,[2,1])),1/n);
      end_while;
      ip:= ip+expr(R[i,1])/expr(R[i,0,1]);
    end_for;
  end_for;
  return(rp,ip);#  return(expand(rp),ip);#
end_proc:

# Reduktion des Integrals mit der Methode von Hermite (Bronstein)#
hermit:= proc(F,C)
  local rp,ip,R,polpart,n,i,j,g,H,U,V,G,T;
begin
  if iszero(F) then return(0,0) end_if;
  ip:=0;rp:=0;
  1/lcoeff(C);
  F:= multcoeffs(F,%1); C:= multcoeffs(C,%2);
  divide(F,C);
  polpart:= polint(op(%1,1));
  F:=op(%2,2);
  R:=sqfft(C);
  g:=0; H:=F;
  for i from nops(R) downto 2 do
    U:=poly(1,[x]);
    for j from 1 to i-1 do
      if type(R[j])<>"_index"
        then U:=U*R[j]^j;
      end_if;
    end_for;
    V:=R[i];
    j:=multcoeffs(U*diff(V,x),1-i);
    dio1(divide(H,V,Rem),divide(j,V,Rem),V);
    G:=op(%1,2);T:=op(%2,1);
    H:=divide(H-U*V*diff(G,x)-j*G,V,Exact);
    R[i-1]:=R[i-1]*R[i];
    g:=g+expr(G)/expr(V^(i-1));
  end_for;
  h:=expr(H)/expr(R[1]);
  return(g,h);
end_proc:

# Reduktion des Integrals mit der Methode von Hermite (Bronstein)#
hermitb:= proc(F,C)
  local rp,ip,R,polpart,n,i,j,g,H,U,V,G,T;
begin
  if iszero(F) then return(0,0) end_if;
  ip:=0;rp:=0;
  1/lcoeff(C);
  F:= multcoeffs(F,%1); C:= multcoeffs(C,%2);
  divide(F,C);
  polpart:= polint(op(%1,1));
  F:=op(%2,2);
  R:=sqfft(C);
  g:=0; H:=F;
  for i from nops(R) downto 2 do
    U:=poly(1,[x]);
    for j from 1 to i-1 do
      if type(R[j])<>"_index"
        then U:=U*R[j]^j;
      end_if;
    end_for;
    V:=R[i];
    dio1(H,multcoeffs(U*diff(V,x),1-i),V);
    G:=op(%1,2);T:=op(%2,1);
    H:=T-U*diff(G,x);
    R[i-1]:=R[i-1]*R[i];
    g:=g+expr(G)/expr(V^(i-1));
  end_for;
  h:=expr(H)/expr(R[1]);
  return(g,h);
end_proc:

# Reduktion des Integrals mit der Methode von Hermite #
hermit2:= proc(p,q)
  local rp,ip,R,polpart,n,i,j;
begin
  if iszero(p)
    then return(poly(0,[x.k]),poly(1,[x.k]),poly(0,[x.k]),poly(1,[x.k])) end_if;
  ip:=0;rp:=0;
#  1/lcoeff(q);
  p:= multcoeffs(p,%1); q:= multcoeffs(q,%2);
  divide(p,q);
  polpart:= polint(op(%1,1));
  R:=sqffpf(op(%2,2),q);# R:=sqffpf2(p,q);
  for i from 1 to R[0,0,0] do
    ip:= ip+expr(R[i,1])/expr(R[i,0,1]);
    for j from 2 to R[i,0,0] do
      n:= j;
      while n>1 do
        dio2(R[i,n],R[i,0,1],diffs(R[i,0,1],x));
        t:= op(%1,1); s:= op(%2,2);
        n:= n-1;
        rp:= rp-expr(multcoeffs(t,1/n))/expr(R[i,0,1]^n);
        R[i,n]:= s+multcoeffs(diffs(t,x),1/n);
      end_while;
      ip:= ip+expr(R[i,1])/expr(R[i,0,1]);
    end_for;
  end_for;
 # return(pol2(rp),pol2(ip)); #     # ip lcoeff(Nenner) sollte 1 sein #
  ip:=pol2(ip);
  i:=mapcoeffs(multcoeffs(ip[1],1/lcoeff(ip[2])),sicoefff); 
  ip:=mapcoeffs(multcoeffs(ip[2],1/lcoeff(ip[2])),sicoefff);
  return(pol2(rp),i,ip);
#  return(expand(rp),ip);#       
end_proc:

# Subresultant Algorithm #
subres:= proc(a,b)
  local d,ps,bt,al,S,rem;
begin
  ps:= -1;
  d:=degree(a)-degree(b); 
  bt:=(-1)^(d+1);
  while not iszero(b) do
    al:=lcoeff(b)^(d+1);
    rem:= divide(multcoeffs(a,al),b,Rem);
    rem:= mapcoeffs(rem,ev,bt); S[degree(b)]:=b;
    ps:=(-lcoeff(b))^d*ps^(1-d);
    d:= degree(b)-degree(rem);
    bt:= -lcoeff(b)*ps^d;
    a:=b; b:=rem;
  end_while;
  return(a,S); # a ist ueberfluessig #
end_proc:
# #
ev:=proc(a,bt)
begin
  a:=rat(a); 					#*******#
  expr(divide(divide(poly(a[1],[z]),poly(a[2],[z]))[1],poly(bt,[z]))[1]);
end_proc:

# Subresultant Algorithm #
subres2:= proc(a,b)
  local d,ps,bt,al,S,rem;
begin
  ps:= -1;
  d:=degree(a)-degree(b); 
  bt:=(-1)^(d+1);
  while not iszero(b) do
    al:=lcoeff(b)^(d+1);
    rem:= multcoeffs(divide(multcoeffs(a,al),b,Rem),1/bt);
    rem:= mapcoeffs(rem,sicoefff);
    ps:=(-lcoeff(b))^d*ps^(1-d);
    d:= degree(b)-degree(rem);
    bt:= -lcoeff(b)*ps^d;
    S[degree(b)]:=b;
    a:=b; b:=rem;
  end_while;
  return(a,S); # a ist ueberfluessig #
end_proc:

# Lazard / Rioboo / Trager Improvement #
lrti:=proc(a,b)
  local a2,v,S,R,i,w,s,SSS,ss,j,integral,RR,c;
begin
  if iszero(a) then return(0) end_if;
  integral:=0;
  v:=op(a,2);
  a2:=poly(poly(a,v.[z])-poly(z,v.[z])*poly(diff(b,op(v)),v.[z]),v);
  S:=subres(a2,b)[2];
  S[0]:=poly(S[0],[z]);
  R:=sqfft(multcoeffs(S[0],1/lcoeff(S[0])));
  for i from 1 to nops(R) do
    if R[i]=poly(1,[z]) then next end_if;
    w:=poly(lcoeff(S[i]),[z]);
    s:=op(polgcdex(w,R[i]),2);
    ss:=poly(divide(s*poly(S[i],[z]),R[i],Rem),[x,z]);
    SSS[i]:=poly(op(primpart(ss),1),[x,z]);
    RR[1]:=R[i]; #factorisierung#
    for j from 1 to 1 do
      case degree(RR[j])
        of 1 do c:=-coeff(RR[j],0);
                integral:=integral+c*ln(expr(evalp(SSS[i],z=c)));
                break;
        of 2 do quad(RR[j]);
                integral:=integral+op(%1,1)*ln(expr(evalp(SSS[i],z=op(%1,1))))+
                                   op(%1,2)*ln(expr(evalp(SSS[i],z=op(%1,2))));
                break;
        otherwise integral:=integral+al*ln(expr(evalp(SSS[i],z=al)));
                  print("Where al is Root of ",RR[j]);
      end_case;
    end_for;
  end_for;
  return(integral);
end_proc:

# Lazard / Rioboo / Trager Improvement #
lrti2:=proc(a,b,x)
  local a2,v,S,SS,R,i,w,s,SSS,ss,j,integral,RR,c;
# global turm,var,k; #
begin
  if iszero(a) then return(0) end_if;
  integral:=0;
  v:=op(a,2);
a2:=poly(poly(a,v.[z])-poly(z,v.[z])*poly(diffs(b,x),v.[z]),[v[1]]);
  b:=poly(b,[v[1]]);
  S:=subres2(a2,b)[2];
#print(S);#
  SS:=poly(rat(expr(S[0]))[1],[z,x,x.i $ i=1..k]);
  SS:=primpart(SS)[1];
#print(SS);#
  if nops(indets(expr(SS)) minus {z}) > 0
    then #print("the resultant contains non constant coefficients");#
         return(FAIL);
  end_if;
  SS:=poly(SS,[z]);
  SS:=multcoeffs(SS,1/lcoeff(SS));
  R:=sqfft(SS);
#print(R);#
  for i from 1 to nops(R) do
    if R[i]=poly(1,[z]) then next end_if;
    w:=poly(lcoeff(S[i]),[z]);
    s:=op(polgcdex2(w,R[i]),2);
#print("div",divide(s*poly(S[i],[z]),R[i],Rem));#
    ss:=mapcoeffs(divide(s*poly(S[i],[z]),R[i],Rem),sicoefff);

#print("1",ss);#
ss:=rat(expr(ss));
ss:=ss[1]*ss[2];
#print("2",ss);#

#    ss:=poly(ss,[z,x].var);#
#print(ss);#

    ss:=poly(ss,[x.(k-j) $ j=0..k-1,x,z]);
#print("HALLO");#
#print("ss",ss);#
    SSS[i]:=poly(op(primpart(ss),1),[z,x]);
#print("SSS",SSS[i]);#
    RR[1]:=R[i]; #factorisierung#
if op(turm[k],0)=hold(exp) then
    for j from 1 to 1 do
      case degree(RR[j])
        of 1 do c:=-coeff(RR[j],0);
               integral:=integral-c*degree(poly(SSS[i],[var[k]]))*op(turms[k],1)
                                 -c*ln(expr(evalp(SSS[i],z=c)));
                break;
        of 2 do quad(RR[j]);
        integral:=integral-op(%1,1)*degree(poly(SSS[i],[var[k]]))*op(turms[k],1)
                          -op(%1,2)*degree(poly(SSS[i],[var[k]]))*op(turms[k],1)
                          +op(%1,1)*ln(expr(evalp(SSS[i],z=op(%1,1))))
                          +op(%1,2)*ln(expr(evalp(SSS[i],z=op(%1,2))));
                break;
        otherwise integral:=integral+al*ln(expr(evalp(SSS[i],z=al))); #XXXXXXX#
                  print("Where al is Root of ",RR[j]);
      end_case;
    end_for;

                           else
    for j from 1 to 1 do
      case degree(RR[j])
        of 1 do c:=-coeff(RR[j],0);
                integral:=integral+c*ln(expr(evalp(SSS[i],z=c)));
                break;
        of 2 do quad(RR[j]);
                integral:=integral+op(%1,1)*ln(expr(evalp(SSS[i],z=op(%1,1))))+
                                   op(%1,2)*ln(expr(evalp(SSS[i],z=op(%1,2))));
                break;
        otherwise integral:=integral+al*ln(expr(evalp(SSS[i],z=al)));
                  print("Where al is Root of ",RR[j]);
      end_case;
    end_for;
end_if;
  end_for;
  integral:=subs(integral,(var[i]=turm[i] $hold(i)=1..k));
  return(integral);
end_proc:

#**********#
diffs:=proc(b,x)
  local v,i;
# global turm,var,k;#
begin
  v:=op(b,2);
  b:=expr(b);
  b:=subs(b,(var[k-i+1]=turm[k-i+1] $i=1..k));
  b:=diff(b,x);
  b:=subs(b,(turm[i]=var[i] $i=1..k));
  b:=poly(b,v);
end_proc:

# Wurzeln der quadratischen Gleichung #
quad:= proc(p)
begin
  -coeff(p,1)/2;
  sqrt(%^2-coeff(p,0));
  %2+%1,%2-%1;
end_proc:

# Integration rationaler Funktionen #
intt:=proc(a)
  local p,q,polpart,ratpart,logpart,i;
begin
  p:=rat(a); q:=poly(p[2],[x]); p:=divide(poly(p[1],[x]),q);
  polpart:=polint(p[1]);
  i:=polpgcd(p[2],q); p:=divide(p[2],i,Exact); q:=divide(q,i,Exact);
  i:=1/lcoeff(q); q:=multcoeffs(q,i); p:=multcoeffs(p,i);
#print(polpart);print(p);print(q);#
  p:=hermit(p,q);ratpart:=pol(p[1]);logpart:=pol(p[2]);
#print("ratpart",ratpart);print("logpart",logpart);#
  if not iszero(ratpart[1]) then print("polp in ratpart:",ratpart[1]) end_if;
  if not iszero(logpart[1]) then print("polp in logpart:",logpart[1]) end_if;
  lrti(logpart[2],logpart[3]);
  return(expr(polpart)+expr(ratpart[2])/expr(ratpart[3])+%);
end_proc:

# Umwandlung von Ausdruecken die in der Form "Zaehler/Nenner" vorliegen
  in den Datentyp CAT_POLY. Ausgabe in der Reihenfolge:
  rein polynomialer Anteil, Zaehler, Nenner (gcd(Zaehler,Nenner)=1)     #
pol:=proc(a,x)
  local Z,N,i;
begin
  rat(a);
  Z:=poly(op(%1,1),[x]);
  N:=poly(op(%2,2),[x]);
  i:=polpgcd(Z,N);
  Z:=divide(Z,i,Exact); N:=divide(N,i,Exact);
  i:=1/lcoeff(N); Z:=multcoeffs(Z,i); N:=multcoeffs(N,i);
  return(divide(Z,N),N);
end_proc:

pol1:=proc(a)
  local Z,N,i;
begin
  rat(a);
  Z:=poly(op(%1,1),var.[x]);
  N:=poly(op(%2,2),var.[x]);
  i:=polpgcd(Z,N);
  Z:=divide(Z,i,Exact); N:=divide(N,i,Exact);
  Z:=poly(Z,[x.k]); N:=poly(N,[x.k]);
  return(Z,N);
end_proc:

pol2:=proc(a)
  local Z,N,i;
begin
  rat(a);
  Z:=poly(op(%1,1),var.[x]);
  N:=poly(op(%2,2),var.[x]);
  i:=polpgcd(Z,N);
  Z:=divide(Z,i,Exact); N:=divide(N,i,Exact);
  Z:=poly(Z,[x.k]); N:=poly(N,[x.k]);
  return(Z,N);
end_proc:

# Substitution, Vereinfachung, Aufbau des Koerperturmes #
int:=proc(a,x)
  local turm,var,k;
begin
# k:=2; turm:=[exp(x^2),ln(x+1)];# #12.8#
# k:=2; turm:=[ln(x+1/2),ln(x)]#; #12.11#
 k:=0;turm:=[];
 turms:=turm;
#  return(pol(tower(simpl(subst(a))),x),turm);#
#                           print(float(subs(a,x=3)));#
  a:=subst(a);
  a:=simpl(a);
  a:=tower(a);# print("Turm",turm);print("turms",turms);#
#                  print(float(subs(a,(x.(k-i+1)=turm[k-i+1] $i=1..k),x=3)));#
#print(a);#
  return(inttt(a,k));
end_proc:

# Integration #
inttt:=proc(a,k)
  local i,j,v,Z,N,polpart,var,NN;
# global turm,turms; #
begin
  if k=0 then return(intt(a)) end_if;
  var:=[x.i $ i=1..k];
  a:=pol2(a);
                          #print(float(subs(expr(a[1])/expr(a[2])
                                      ,(x.(k-i+1)=turm[k-i+1] $i=1..k),x=3)));#
  i:=1/lcoeff(a[2]);
                          #print("i",i);print(a[1],a[2]);#
  N:=multcoeffs(a[2],i);
  Z:=multcoeffs(a[1],i);
  N:=mapcoeffs(a[2],sicoefff);
  Z:=mapcoeffs(a[1],sicoefff);
  i:=divide(Z,N);
  polpart:=i[1];Z:=mapcoeffs(i[2],sicoeff);
#                         print(float(subs(expr(polpart)+expr(Z)/expr(N)
                                 ,(x.(k-i+1)=turm[k-i+1] $hold(i)=1..k),x=3)));#
  if op(turm[k],0)=hold(exp)
    then v:=degree(nthmonomial(N,nterms(N)));
         if v>0 then v:=poly(x.k^v,[x.k]);
                     NN:=divide(N,v,Rem);
                     if iszero(NN) then polpart:=polpart+expr(Z)/expr(N);
                                        Z:=poly(0,var);
                                        return(FAIL);
                                   else i:=dio2(Z,v,NN);
                                        Z:=i[2];
                                        polpart:=polpart+divide(i[1],v,Rem);
                     end_if;
         end_if;
        # print("polpart(exp)",polpart);#
         polpart:=rischdgl(expr(polpart),k);
    else polpart:=intpol(polpart);#print("intpolpart",polpart);#
    if polpart=FAIL then return(FAIL); end_if;
  end_if;
  i:=hermit2(Z,N);
#  print("ratpart",i[1],i[2]);#
#  print("lrti2",i[3],i[4]);#
  j:=lrti2(i[3],i[4]);
  if j=FAIL then return(FAIL); end_if;
  Z:=subs(expr(i[1]),x.i=turms[i] $hold(i)=1..k);
  N:=subs(expr(i[2]),x.i=turms[i] $hold(i)=1..k);
  return(polpart+Z/N+j);
end_proc:

# #
sidiv:=proc(a,i)
  local j,p,q,v;
# global var,k; #
begin
#  v:=var; v[k]:=NIL; v:=v.[x];#
  v:=indets(a) union indets(i);
  if nops(v)=0 then return(a/i) end_if;
  v:=[op(v)];
  a:=poly(a,v); i:=poly(i,v);
  j:=polpgcd(a,i);
  p:=divide(a,j,Exact); q:=divide(i,j,Exact);
  return(expr(p)/expr(q));
end_proc:
# #
sicoeff:=proc(a)
  local j,p,q,v;
# global var,k; #
begin
  v:=var; v[k]:=NIL; v:=v.[x];
  a:=rat(a);
  p:=poly(a[1],v); q:=poly(a[2],v);
  j:=polpgcd(p,q);
  return(expr(divide(p,j,Exact))/expr(divide(q,j,Exact)));
end_proc:
# #
sicoefff:=proc(a)
  local j,p,q,v,i;
begin
  v:=indets(a);
  if nops(v)=0 then return(a) end_if;
  v:=[op(v)];
  a:=rat(a);
  p:=poly(a[1],v); q:=poly(a[2],v);
  j:=polpgcd(p,q);
  return(expr(divide(p,j,Exact))/expr(divide(q,j,Exact)));
end_proc:

# integrate polynomial part #
intpol:=proc(polpart)
  local i,j,d,q,u,v;
# global turm,k,turms; #
begin
#print("inp",polpart);#
  if iszero(polpart) then return(0) end_if;
  d:=0; q:=poly(0,[x.k]); u:=diff(op(turms[k],1),x)/op(turms[k],1);
  for i from degree(polpart) downto 0 do
#print("int",coeff(polpart,i)-(d*(i+1)*u));#
    j:=inttt(subs(coeff(polpart,i)-(d*(i+1)*u),turms[j]=x.j $hold(j)=1..k),k-1);
#print("j1",j);#
    if j=FAIL
      then print(coeff(polpart,i)-(d*(i+1)*u),"in polpart is not integrable");
           return(FAIL);
    end_if;
    if indets(j) minus {x,op(turms)} <> {} and i>0
      then print("illegal extensions in",j);
           return(FAIL);
    end_if;
    j:=poly(subs(j,turms[k]=x.k),[x.k]);
    if degree(j)>1 and i>0
      then print("the log extension in",j,"is of higher degree then 1");
           return(FAIL);
    end_if;
#print("j2",j);#
 #   if degree(j)=1 then v:=coeff(j,1)/(i+1) else v:=0 end_if;#
    q:=q+poly((coeff(j,1)/(i+1)+d)*x.k^(i+1),[x.k]);
#print("1",q);#
    d:=coeff(j,0);
  end_for;
  q:=q+j-poly(coeff(j,1)*x.k,[x.k]);
#print("2",q);#
  q:=subs(expr(q),x.k=turm[k]);
end_proc:

# solves the Risch differential equation #
rischdgl:=proc(a,k)
  local ;
begin
  if degree(poly(a,[x.k]))=0 then return(inttt(a,k-1));
                             else return(FAIL);
  end_if;
end_proc: 
