# #
# $Author: linus $ $Date: 1994/06/06 08:29:36 $ $Revision: 1.1 $ #

#++
	resultant -- computes the resultant of two polynomials
		     over the expressions.
		     These procedure can be extended to works correctly
		     for polynomials over fields.
++#

resultant := proc(f,g,X)
    local n, m, q, r, c;
begin
    if testargs() then
	if args(0) <> 3 then
	    error("Wrong no of arguments")
	end_if;
	if type(X) <> DOM_IDENT then
	    error("Invalid indeterminate: ".X)
	end_if;
	domtype(f);
	if not ( % = DOM_EXPR or % = DOM_POLY ) then
	    error("Expected two polynomials")
	end_if;
	domtype(g);
	if not ( % = DOM_EXPR or % = DOM_POLY ) then
	    error("Expected two polynomials")
	end_if
    end_if;
  
    f := poly(f,[X]); g := poly(g,[X]);
    c := 1;
    repeat
	m := degree(f); n := degree(g);
	divide(f,g);
	q := op(last(1),1); r := op(last(2),2);
	if r <> 0 then
	    c := c * (-1)^(m*n) * lcoeff(g)^(m-degree(r));
	    f := g; g := r
	end_if
    until r = 0 end_repeat;
    if degree(g) > 0 then return( 0 ) end_if;
    c * expr(g)^degree(q)
end_proc:
