

/******************************************************************************/
/* FILE   :  cmath.c  - Faster Sinus and Cosinus                              */
/* AUTHOR :  Andreas Sorgatz                                                  */
/* CREATED:  02/03/94                                                         */
/* CHANGED:  09/01/95                                                         */
/*                                                                            */
/* Calaculates Sinus by using the C math library. The precision of the result */
/* depends on the operating system.                                           */
/******************************************************************************/
#include "MMT_tool.c"                                     /*** load toolbox ***/

/******************************************************************************/
/* NAME: csin( float : DOM_FLOAT ) : DOM_FLOAT                                */
/******************************************************************************/
MODUL_FUNC( csin )
{
	MMT_init( "csin", MMT_NOP, MEVC_FLOAT );
	
	MMT_check_params( 1L );
	if( MMT_cat(MMT_param(1L)) != CAT_FLOAT ) {
		MMT_return( MMT_copy(s) );
	}
	MMT_return( MMT_c2m_double( sin( MMT_m2c_double(MMT_param(1L)) ) ) )
}

/******************************************************************************/
/* NAME: ccos( float : DOM_FLOAT ) : DOM_FLOAT                                */
/******************************************************************************/
MODUL_FUNC( ccos )
{
	MMT_init( "ccos", MMT_NOP, MEVC_FLOAT );
	
	MMT_check_params( 1L );
	if( MMT_cat(MMT_param(1L)) != CAT_FLOAT ) {
		MMT_return( MMT_copy(s) );
	}
	MMT_return( MMT_c2m_double( cos( MMT_m2c_double(MMT_param(1L)) ) ) )
}

