# $Date: 1994/06/06 09:45:34 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
amerge  - Merge one attribute to an other

amerge( _l_, _s_ )

_l_     - Current attribute (destination)
_s_     - Son's attribute   (source)

This function must be called to merge the son's attribute-table into to the
current attribute-table. The current value will be change by a side-effect.

             _l_["@FLOW"]:= _s_ ["@FLOW"]
             _l_["@UP"]  := MERGE( _l_["@UP"], _s_["@UP"] )
++#

mmc::amerge:= proc( _l_, _s_ )
option	hold;
local	_tmp_, _lup_, _sup_;
begin
	evalassign( _l_["@FLOW"], level(_s_["@FLOW"],99), 1 );

	_lup_:= level( _l_["@UP"], 99 );
	_sup_:= level( _s_  ["@UP"], 99 );
	_tmp_:= table( "@UP" = _lup_ );
	
	#++ Merge "@UP" +++++++++++++++++++++++++++++++++++++++++++++++++++++++#
		
		#++ Unify "@UP":"@BOOL" +++++++++++++++++++++++++++++++++++++++#
		
	_tmp_["@UP"]["@BOOL"]:= _lup_["@BOOL"] union _sup_["@BOOL"]; 

	evalassign( _l_["@UP"], _tmp_["@UP"], 1 );
end_proc:

# end of file #
