# $Date: 1994/11/07 10:54:07 $ $Author: andi $ $Revision: 1.2 $ #

# andi, 07/11/94 #

#++
ePROC  - Entry for MuPAD-procedures

ePROC( oname, ovalue )

oname      - Name  of object
ovalue     - Value of object

A modul-function generated by the MuPAD-compiler, will be build up of three
parts:

	PREFIX :	* Initialization of 'generics'
			* Header of a standard kernel function
			* Initialization of the MuPAD stack
	BODY   : 	* Body of the MuPAD procedure
	POSTFIX:	* Reinitialization of the MuPAD stack
			* Return of the result

Every object that is unknown to the compiler will be handled as a 'generic'.
This is a MuPAD-objects,  which will be loaded with the modul and bound to
the DOM_EXEC of its modul-function.
++#

mmc::ePROC:= proc( oname, ovalue )
local	attr, do_rem, result;
begin
	if( mmc::loglevel > 0 ) then
		mmc::cl ( mmc::l, "" );
		mmc::crl( mmc::l, "", " FUNCTION: \"".oname."\" ", "" );
	end_if;
	
	### Initialisierung der Attributtabelle  ###################################################
	
	attr:= table(
		"@DOWN" = table(                    ### Diese Attribute fallen in die Blaetter   ###
			"MODUL"       = mmc::modul,             ### Name des aktuellen Moduls    ###
			"NAME"        = oname,                  ### Name der aktuellen Prozedur  ###
			"PARAM"       = [],                     ### Liste formaler Parameter     ###
			"LOCAL"       = [],                     ### Liste lokaler Variablen      ###
			"OPTION"      = {op(ovalue,3)},         ### Menge der Prozedur-Optionen  ###
			"FLAGS"       = mmc::option             ### Menge der MMC-Compiler-Flags ###
		),
		"@FLOW" = table(                    ### Diese Attribute fliessen mit der Analyse ###
			"GENVAL"      = [],                     ### Eintrag: generische Elemente ###
			"GENNUM"      = 0,                      ### Zaehler: generische Elemente ###
			"GLOBAL_USE"  = {},                     ### Verwendete globale Variablen ###
			"GLOBAL_SET"  = {},                     ### Definierte globale Variablen ###
			"TVCN"        = 0,                      ### Zaehler: temp. S_Pointer     ###
			"TVCMAX"      = 0,                      ### Maximum: temp. S_Pointer     ###
			"TVPCN"       = 0,                      ### Zaehler: temp. *S_Pointer    ###
			"TVPCMAX"     = 0                       ### Maximum: temp. *S_Pointer    ###
		),
		"@UP"   = table(                    ### Diese Attribute steigen ggf. zur Wurzel  ###
			"@BOOL"       = {}                      ### Menge boolescher Attribute   ###
		),
		"@TEMP" = table()                   ### Attribute zwischen Vater und einem Sohn  ###
	);

		### formale Parameter und lokale Variablen in die Attributtabelle  #################
		
	if( [op(ovalue,1)] <> [NIL] ) then 
		attr["@DOWN"]["PARAM"] := [op(ovalue,1)];
	end_if;
		
	if( [op(ovalue,2)] <> [NIL] ) then 
		attr["@DOWN"]["LOCAL"] := [op(ovalue,2)];
	end_if;
	
	mmc::cl( mmc::g, "\"".oname."\" = hold( [ " );
	mmc::cpush( mmc::g );
			
	mmc::cl( mmc::g, expr2text(attr["@DOWN"]["PARAM"]).", ".
	                 expr2text(attr["@DOWN"]["LOCAL"])." "
	);
	attr["@FLOW"]["GENVAL"]:= attr["@FLOW"]["GENVAL"].[expr2text(attr["@DOWN"]["PARAM"])];
	attr["@FLOW"]["GENVAL"]:= attr["@FLOW"]["GENVAL"].[expr2text(attr["@DOWN"]["LOCAL"])];
	attr["@FLOW"]["GENNUM"]:= attr["@FLOW"]["GENNUM"] +2;
	
		### Ggf. soll der Prozedurrumpf als generischs Objekt verwaltet werden #############
		
	if( contains( attr["@DOWN"]["FLAGS"], "GENERIC") ) then
		attr["@TEMP"]["GENERIC"]:= TRUE;
	end_if;

	### Prozedur-Kopf mit Praefix erzeugen #####################################################
	
	mmc::crl( mmc::c,	"", " FUNKTION: ".oname." ", "" );
	mmc::cl ( mmc::c,	"MODUL_FUNC( ".oname." )", "{" );
	mmc::cpush( mmc::c );

		### Lokale Variablen der Modulfunktion #############################################
		
	mmc::cl( mmc::c,	
		"S_Pointer    MFargs, MFpv, MFpvc[".(nops(attr["@DOWN"]["PARAM"])+1)."];",
		"S_Pointer    MFres,  MFlv, MFlvc[".(nops(attr["@DOWN"]["LOCAL"])+1)."];",
		"S_Pointer    MFtvc[MF_TVC_".oname."], *MFtvpc[MF_TVPC_".oname."];",
		"S_Pointer    save_args, INLINE_C_RESULT;",
		"MSTTinfo     info;",
		"MEVTstamp    stamp;",
		"long         procdepth;",
		"" 
	);
		### GENERICS: Existenz pruefen, ggf. laden #########################################
	
	mmc::crl( mmc::c,	"Verwaltung der generischen Objekte" );	
	mmc::cl ( mmc::c,	"MDM_init_generics( &exec );", "" );

		### Standard-Headerfunktion eintragen  #############################################
	
			### OPTION: `hold'  beruecksichtigen #######################################
	
	mmc::crl( mmc::c,	"Standard-Header einer Kernfunktion" );	
	if( contains( attr["@DOWN"]["OPTION"], hold(hold) ) ) then
		mmc::cl( mmc::c, "eval_type |= MEVC_HOLD_BIT;" );
	end_if;
	
	mmc::cl( mmc::c,	"MEV_header( s, MEVC_NULL_DEFAULT, prev_func, eval_type, exec," );
	mmc::cpush( mmc::c );
	mmc::cl( mmc::c,	"MGSC_FLAT_ARG, MEVC_UNKNOWN, &MFargs,",
			"MEVC_FLOAT_BIT | MEVC_BOOL_BIT,",
			"MEVC_NO_TYPE_CHECK,",
			"MEVC_NO_OVERLOAD, 0L, 0L, 0L" 
	);
	mmc::cpop( mmc::c );
	mmc::cl( mmc::c,	");", "" );

		### Initialisierung des MuPAD-Stack  ###############################################
		
	mmc::crl( mmc::c,	"Initialisieren des MuPAD-Stack" );	
	mmc::cl ( mmc::c,	"MFpv = MDM_get_generic( exec, MF_GEN_PV, 0L );",
			"MFlv = MDM_get_generic( exec, MF_GEN_LV, 0L );",
			"",
			"MDM_prefix( MFargs, MFpv, MFlv, MFpvc, MFlvc );", 
			"",
			"save_args = MTR_new_cat_ident(MMMCglobal,\"".oname."\");",
			"MST_ins_stack(MSTR_procname,save_args,".
				"MSTC_option_standard,&info,&stamp,&procdepth);",
			"MMMfree( save_args );",
			"MEVV_STATUS = MEVC_CONTINUE;",
			"save_args = MEVV_ARGS_OLD; MEVV_ARGS_OLD = MEVV_ARGS;",
			"MEVV_ARGS = MFargs;",
			""
	);

		### `remember'-Tafel beruecksichtigen  #############################################

	if( domtype(op(ovalue,5)) <> DOM_NIL ) then
		attr["@DOWN"]["REMEM"]:= op( ovalue, 5 );
		mmc::warn( "Predefined remember table ignored" );
	else
		attr["@DOWN"]["REMEM"]:= table();
	end_if;


	### Prozedur-Rumpf erzeugen  ###############################################################
	
	if( type(op(ovalue,4)) <> "_stmtseq" ) then mmc::stmt:= 1; 
	end_if;
		
	mmc::crl( mmc::c,	"Der Prozedur-Rumpf" );	
	
	result:= mmc::pPARSER( op(ovalue,4), attr );
	if( not contains( result["@UP"]["@BOOL"], "RETURN" ) ) then
		mmc::cl( mmc::c, "MFres = ".result["@TEMP"]["CODE"].";", "", "" );
	end_if;	
	

	### Prozedur-Ende mit Postfix erzeugen #####################################################

	mmc::crl( mmc::c,	"Sprungmarke fuer MuPAD-return-Statement" );
	mmc::cl ( mmc::c,	"MF_Postfix_Label: MEVV_STATUS = MEVC_CONTINUE;", "" );
		
		### Reinitialisierung des MuPAD-Stack  #############################################
		
			### OPTION: `remember' beruecksichtigen  ###################################

	if( contains( attr["@DOWN"]["OPTION"], hold(remember) ) ) then
		do_rem := "1L";
	else
		do_rem := "0L";
	end_if;

	mmc::crl( mmc::c,	"Reinitialisieren des MuPAD-Stack" );
	mmc::cl ( mmc::c, "", 
		       "MEVV_ARGS = MEVV_ARGS_OLD; MEVV_ARGS_OLD = save_args;",
		       "MST_del_stack(MSTR_procname,MSTC_option_standard,&info,&stamp,&procdepth);",
		       "",
		       "MDM_postfix( MFargs, &MFres, exec, ".do_rem.", prev_func, MFpv, MFlv".");",
		       "",
		       "return( MFres );",
		       ""
	);

		### Modulfunktion abschliessen #####################################################

	mmc::cpop( mmc::c );
	mmc::cl( mmc::c,	"} /*** ".oname." ***/", "", "", "" );


	### Groesse der Vektoren temporaerer Variablen definieren  #################################

	mmc::cl( mmc::h,"#define MF_TVC_".oname."         ".(result["@FLOW"]["TVCMAX"]+1),
			"#define MF_TVPC_".oname."        ".(result["@FLOW"]["TVPCMAX"]+1)
	);
	
	### Definition der generischen Objekte abschliessen  #######################################
	
	mmc::cpop( mmc::g );
	mmc::cl( mmc::g,	"] ), ### \"".oname."\" ###", "" );
	
	if( mmc::loglevel > 0 ) then mmc::cl( mmc::l, "" ); end_if;
	
	### Attribute von globalem Interesse (z.B. generische Objekte) verwalten. Die Attribute  ###
	### werden unter dem Index  oname,attr  eingetragen. Die Existenz des Index oname  ###
	### zeigt zugleich an, dass das Objekt  oname  bereits abgebildet wurde.              ###
	
	mmc::vobjects[oname]:= table();
	mmc::vobjects[oname]["GENVAL"]:= result["@FLOW"]["GENVAL"];
	mmc::vobjects[oname]["EXEC"  ]:= MMC_HOLD_OBJ(built_in)( 
	                                        mmc::mfnum,
	                                        result["@DOWN"]["MODUL"],
	                                        result["@DOWN"]["NAME"],
	                                        NIL,
	                                        NIL #op(map(map(result["@FLOW"]["GENVAL"],text2expr),MMC_HOLD_OBJ(hold)))#
	                                  );	

	### "PASS2"-Flag zurueckgeben !!!! #########################################################
	
	return( contains(result["@UP"]["@BOOL"], "PASS2") );
end_proc:

# end of file #
