# $Date: 1994/06/06 09:46:00 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
pPARSER  - Parserfunction for all MuPAD-objects

pPARSER( cat_, father_ )

cat_        - Object to analyse
father_     - Attribute given from the father_

This is the central entry-point for all parser-function.  The current ob-
ject will be analysed  to find its specific parser-function,  which gene-
rate the C-code.  The parser-function for the object  XXX  will be found
in  domattr(XXX,mmc::pname). 
If there's no parser-function defined for the 'cat_', then the object will
be handled as a  "generic"  (by calling the function mmc::pGENERIC). Also
all elements,  which have no efficient representation in a  basic type of 
C programming language will be handled as generics.
++#

mmc::pPARSER:= proc( cat_, father_ )
local	ason_, check_, dtyp_, styp_, dpname_, dpproc_, str_;
begin
	if( args(0) > 2 ) then                     #++ sequences was flatted ++#
		cat_   := op( args(), 1..args(0)-1 );
		father_:= args(args(0));
	end_if;
	check_:= bool( father_["@DOWN"]["CHECK"] = TRUE );
	
	mmc::depth:= mmc::depth +1;

	styp_:= expr2text( (dtyp_:= domtype(cat_)) );

	#++ Choose a domain- or the genric-parserfunction +++++++++++++++++++++#
	
	if  ( father_["@TEMP"]["GENERIC"] = TRUE ) then
		dpproc_:=  mmc::pGENERIC; 
		dpname_:= "mmc::pGENERIC";
		
	elif( (dpproc_:= domattr(dtyp_,mmc::pname)) <> FAIL ) then
		dpname_:= "".expr2text(dtyp_)."::".mmc::pname;
		dpproc_:= level( dpproc_, 2 );      #++ Load this procedure !!! +++#
	else	dpproc_:=  mmc::pGENERIC;
		dpname_:= "mmc::pGENERIC";
		
	end_if;

	#++ Print log-messages and call parserfunction ++++++++++++++++++++++++#
	
	if( not check_ ) then
		mmc::cl( mmc::c, 
			"/*** >>> [".mmc::stmt.":".mmc::depth."] ".styp_." ***/"
		);
	end_if;
	if( mmc::loglevel > 0 ) then
		if( check_ ) then  str_:= "??> "  else  str_:= ">>> " end_if;
		mmc::cl( mmc::l, 
			"[".mmc::stmt.":".mmc::depth."] ".str_.dpname_.
			"( ".styp_." )" 
		);
		if( mmc::loglevel > 1 ) then 
			mmc::cl( mmc::l, "", expr2text(father_), "" );
		end_if;
	end_if;

	ason_:= dpproc_( cat_, father_ );

	if( mmc::loglevel > 0 ) then 
		if( mmc::loglevel > 1 ) then 
			mmc::cl( mmc::l, "", expr2text(ason_), "" );
		end_if;
		mmc::cl( mmc::l, "[".mmc::stmt.":".mmc::depth."] <<< ".
			 dpname_."( ".styp_." )"
		);
	end_if;
	if( not check_ ) then
		mmc::cl( mmc::c, 
		"/*** <<< [".mmc::stmt.":".mmc::depth."] ".styp_." ***/",
		""
		);
	end_if;
	mmc::depth:= mmc::depth -1;
	ason_["@DOWN"]:= father_["@DOWN"];       #++ Reinitialize "@DOWN" !! ++#
	ason_ ;
end_proc:

# end of file #
