# $Date: 1994/06/06 09:46:01 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
tvdel  - Free the last allocated temporary variable

tvdel( _attr_  [, var_type] )

_attr_     - Attribute (destination)
var_type   - Attribute (source)
++#


####################################################################################################
# NAME:        M2C_del_tv                                                                          #
# PARAMETER:   _attr_ = aktuelle Attributtabelle des Parsers                                       #
#              args(2)= Typ : DOM_STRING (optional)                                                #
# FUNKTION:    Gibt die zuletzt angeforderte temporaere C-Kode-Variable frei (vgl. M2C_new_tv).    #
#                                                                                                  #
#              ACHTUNG: Die Funktion aendert als Seiteneffekt folgende Eintraege der gegebenen     #
#                       Attributtabelle:                                                           #
#                                         _attr_["@FLOW"]["TVCN"]     (+1)                         #
####################################################################################################
mmc::tvdel:= proc( _attr_ # , var_type # )
option	hold;
local	id_name_m, tv_index;
begin
	### Welcher Variablentyp wird angefordert  #################################################
	
	### Welcher Variablentyp wird freigegeben  #################################################
	
	if  ( args(0) = 1         ) then id_name_m:= "TVC";
	elif( args(2) = "TVC"     ) then id_name_m:= "TVC";
	elif( args(2) = "TVPC"    ) then id_name_m:= "TVPC";
	else                        error( "fatal -- Bad type of temp. variable: \"".args(2)."\"" ); 
	end_if;

	### Zaehler erhoehen und Variablenname liefern #############################################

	tv_index:= level( _attr_["@FLOW"][id_name_m."N"], 99 ) -1;

	if( evalassign(_attr_["@FLOW"][id_name_m."N"], tv_index, 1) < 0 ) then 
		error( "fatal -- _attr_[\"@FLOW\"][\"".id_name_m."N\"] < 0 --" ); 
	end_if;
end_proc:

# end of file #
