#define XSIZECM 19		/* at 120 DPI  */
#define YSIZECM 27		/* at 72 DPI */
#ifdef __TURBOC__
#define NXBITS 904
#define NYBITS 768
#else
#define NXBITS 300	/* because vax cant cope with one huge record */
#define NYBITS 400
#endif
#include "bitmap.h"
dvitype(void)
{
	printf("Epson");
}
bitmap_print()
{
	int y;
	for (y=nybits-8 ; y>=0 ; y-=8)
		print_row(y);
}
print_row(int y)
{
	unsigned char savechar,temp;
	static unsigned char out_buff[NXBITS+10]="\x1bL";
	unsigned int r,i,j,newy,x,z;
	unsigned char *line;
	dbg printf("row %d\n",y);
	for (r=4;r<(NXBITS+5);r++) out_buff[r] = 0;
	for (r=0; r<8; r++,y++) {
		line = bitmap_line(y);
		for (x=0,j = 4; x<NXBITS;x++,j++) {
			z = 1 << (x % 8);
			if ((z & line[x/8]) != 0) {
				 out_buff[j] |= 1 << r;
			}
		}
	}
	out_buff[2] = (j-4) & 255;
	out_buff[3] = (j-4) / 256;
	printmem(out_buff,j);
	pprintf("\x0d\x1bJ\x18");
}


