/* This is the gle command which translates to run the individual
   gle programs:
	  gle myfile -dps       ---> gle_ps myfile

          gle myfile /nomaxpath -dlj -old -noflip
               ---> gle_dvi myfile /nomaxpath
               ---> gle_dviprint -dlj -out myfile.hp -old -noflip
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "glepath.h"

#define false 0
#define true (!false)
main(int argc,char *argv[])
{
	static char buff[200];
	static char glefile[200];
	static char device[200];
	static char outfile[200];
	static char bmpdev[100];
	static char gleoptions[200];
	static char devoptions[200];
	static char bindir[200];
	char *s;
	FILE *f;
	int i;
	int gotdevice;

/*  Get the directory containing the gle_* binaries */
	s = getenv("GLE_TOP");
	if (s!=NULL) {
	    strcpy(bindir,s);
	} else {
	    strcpy(bindir,GLEBINS);
	}
	if (bindir[strlen(bindir)-1] != '/')
	    strcat(bindir,"/");

	if (argc<2) {
	  printf("Usage: gle filename.gle -ddevice\n");
	  printf("    gle test -dx    (Xwindows) \n");
	  printf("    gle test -dtek  (TEK4010) \n");
	  printf("    gle test -dhpgl (HP Plotters) \n");
	  printf("    gle test -dps   (PostScript) \n");
	  printf("    gle test -deps   (Encapsulated PostScript) \n");
	  printf("    gle test -depson [-hires] (For dot matrix printers) \n");
	  printf("    gle test -dlj [-hires] (For HP Laserjet printers) \n");
	  printf("    gle test -dpj [-hires] (For HP Paintjet printers) \n");
	  printf("    surface test.sur -dx (Surface utility) \n");
	  printf("    contour         (Contour plots) \n");
	  printf("    fitls           (Fit n variable equation to data)\n");
	  printf("    fitz            (Fits even surface to xyz data)\n");
	  printf("    letz            (Creates surface from eqn) \n");
	  printf("    manip test.dat  (Data editor) \n");
	  printf("To find out what drivers are available type in:\n");
	  printf("         ls %sgle_* \n", bindir);
	  printf(" \n");
	  return 0;
	}

/*  Parse the arguments on the command line.
    Options before device spec (-dxx) are put in gleoptions and those after
      are put in devoptions.  This allows passing options to gle_dviprint.
*/
	strcpy(device,"vt");
	gotdevice = false;
	for (i=1;i<argc;i++) {
	    if (strncmp(argv[i],"-d",2)==0) {
		strcpy(device,argv[i]+2);
		gotdevice = true;
	    }
	    else if (isalnum(*argv[i]))
		strcpy(glefile,argv[i]);
	    else {
		if (gotdevice) {
		    strcat(devoptions," ");
		    strcat(devoptions,argv[i]);
		} else {
		    strcat(gleoptions," ");
		    strcat(gleoptions,argv[i]);
		}
	    }
	}

/*  Make the output file name */
	strcpy(outfile,glefile);
	s = strchr(outfile,'.');
	if (s!=NULL) *s = 0;
	strcat(outfile,".");

/*
	if (strcmp(device,"lj")==0) {
	  strcat(outfile,"hp");
	} else if (strcmp(device,"pj")==0) {
	  strcat(outfile,"hp");
	} else if (strcmp(device,"epson")==0) {
	  strcat(outfile,"prn");
	} else
*/
	  strcat(outfile,device);

	sprintf(buff,"%sgle_",bindir);           /* , GLEBINS); */
	sprintf(bmpdev,"%sgle_dviprint",bindir);

/*  Do special stuff for the bitmapped devices (dvi) */
	if (strcmp(device,"epson")==0) {
	  strcpy(device,"dvi");
	  strcat(bmpdev," -depson -out ");
	  strcat(bmpdev,outfile);
	  strcat(bmpdev,devoptions);
	}
	if (strcmp(device,"lj")==0) {
	  strcpy(device,"dvi");
	  strcat(bmpdev," -dlj -out ");
	  strcat(bmpdev,outfile);
	  strcat(bmpdev,devoptions);
	}
	if (strcmp(device,"bmptest")==0) {
	  strcpy(device,"dvi");
	  strcat(bmpdev," -dvt -out ");
	  strcat(bmpdev,outfile);
	  strcat(bmpdev,devoptions);
	}
	if (strcmp(device,"pj")==0) {
	  strcpy(device,"dvi");
	  strcat(bmpdev," -dpj -out ");
	  strcat(bmpdev,outfile);
	  strcat(bmpdev,devoptions);
	}

	if (strcmp(device,"eps")==0) {
	  strcat(buff,"ps");
	  strcat(gleoptions," /eps");
	} else {
	  strcat(buff,device);
	}
	strcat(buff," ");
	strcat(buff,glefile);
	strcat(buff," /output=");
	strcat(buff,outfile);
	strcat(buff,gleoptions);
	if (strcmp(device,"dvi")!=0) {
	  strcat(buff,devoptions);
	}
	/*printf("%s\n",buff);*/

/*  Make the command script file glecmd.tmp */
	f = fopen("glecmd.tmp","w");
	fprintf(f,"echo %s\n",buff);
	fprintf(f,"%s\n",buff);
	if (strcmp(device,"dvi")==0) {
	 /* printf("%s\n",bmpdev); */
	  fprintf(f,"echo %s\n",bmpdev);
	  fprintf(f,"%s\n",bmpdev);
	}
	fclose(f);
	if (chmod("glecmd.tmp",0x1ff)!=0)
               printf("chmod +x failed on glecmd.tmp \n");
	execlp("sh","sh","-c", "./glecmd.tmp",0);
/*
	execlp("sh","sh","-c", buff,0);
*/
}





