/*
 * FORT.C
 *
 * $Id: fort.c,v 1.1 1993/08/27 17:08:43 munro Exp $
 *
 * Platform specific definitions for GIST FORTRAN interface.
 * Changes to this file may be insufficient; some reworking of
 * FORT.C may be necessary, as well (e.g.- if parameter order is
 * reversed between FORTRAN and C).  The character parameters in
 * FORTRAN are the most serious portability problem -- check the
 * GTX and GTXS primitives most carefully.
 *
 * The function definitions are taken from ANSI X3.124.1-1985, the
 * ANSI GKS standard FORTRAN bindings.  This is intended to be a
 * minimalyy conforming GKS at Level ma.  A few functions at 0a or
 * 1a are provided, as are 10 settable normalization transformations.
 * Otherwise, don't expect more than the minimum capabilities set
 * forth in section 4.10 of ANSI X3.124-1985.
 *
 * In particular, note that
 *
 */
/*    Copyright (c) 1994.  The Regents of the University of California.
                    All rights reserved.  */

#include "gist.h"

#ifdef STDC_HEADERS
#include "string.h"
#else
#ifndef SIZE_T_TYPE
#define SIZE_T_TYPE unsigned long
#endif
extern char *strncpy(char *, const char *, SIZE_T_TYPE);
#endif

/* GKS NDC units should fill an 8 inch square at the top of an
   8.5-by-11 inch sheet */
#define GKS_SCALE (8.0*ONE_INCH)
#define GKS_XOFF (0.25*ONE_INCH)
#define GKS_YOFF (2.75*ONE_INCH)

/* ------------------------------------------------------------------------ */

/* The idea for the F77_ID macro is from Stewart Brown's scstd.h
   Go ahead and tinker with this if you need to... */

#ifdef CRAY
/* Cray (UNICOS or LTSS-derivative) translates FORTRAN names to uppercase */
#define F77_ID(fname_, fname, FNAME) FNAME
#define CHAR_LEN long
#ifdef LRLTRAN
/* LTSS-derivative LRLTRAN compiler does not pass character lengths
   -- define LRLTRAN on compile line to get this.  */
#define NO_CHAR_LEN
#else
#undef NO_CHAR_LEN
#endif

#else
#ifdef AIX
/* IBM uses lowercase FORTRAN names */
#define F77_ID(fname_, fname, FNAME) fname
#undef NO_CHAR_LEN
#define CHAR_LEN long

#else
/* Other brands of UNIX add trailing underscore to FORTRAN names */
#define F77_ID(fname_, fname, FNAME) fname_
#undef NO_CHAR_LEN
#define CHAR_LEN long

#endif
#endif

/* ------------------------------------------------------------------------ */

/* The GOPWK (Open Workstation) routine creates a CGM Engine with the
   filename "gks0.cgm" in the current working directory.  GACWK can
   be used to activate this Engine, and GDAWK to deactivate it.  Note,
   however, that the GKS functions which do not have an explicit wkid
   (workstation id) argument will work as intended.  Thus, if you want
   other types of Engines and more complicated activation and deactivation,
   you must write your own FORTRAN functions to call GpBXEngine,
   GpPSEngine, GpCGMEngine, GpActivate, GpDeactivate, and GpKillEngine.  */

/* ------------------------------------------------------------------------ */

/* A list of 10 transforms is also maintained for compatibility with GKS.
   The GpGetGKSTrans routine will SET the current transformation to the
   most recently used transformation in the list, if GpSetTrans has
   been used to set the transformation directly since the last
   GpSetGKSTrans.  (None of this machinery will exist if noe of these
   six routines is referenced .)  */
extern int gistTID;        /* set to <0 if non-GKS map is installed */
extern int GpSetGKSTrans(int mapID);
extern int GpGetGKSTrans(void);
extern int GpSetGKSView(int mapID, GpReal xmin, GpReal xmax,
			GpReal ymin, GpReal ymax);
extern int GpSetGKSWind(int mapID, GpReal xmin, GpReal xmax,
			GpReal ymin, GpReal ymax);
extern int GpGetGKSView(int mapID, GpReal *xmin, GpReal *xmax,
			GpReal *ymin, GpReal *ymax);
extern int GpGetGKSWind(int mapID, GpReal *xmin, GpReal *xmax,
			GpReal *ymin, GpReal *ymax);

static int mostRecentMap= 0;
static GpTransform gksMaps[11]= {
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}},
  {{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}} };

int GpSetGKSTrans(int mapID)
{
  if (mapID<0 || mapID>10) return 1;
  GpSetTrans(gksMaps+mapID);
  gistTID= mostRecentMap= mapID;
  return 0;
}

int GpGetGKSTrans()
{
  if (gistTID<0) GpSetGKSTrans(mostRecentMap);
  return gistTID;
}

int GpSetGKSView(int mapID, GpReal xmin, GpReal xmax,
		 GpReal ymin, GpReal ymax)
{
  if (mapID<1 || mapID>10) return 1;
  gksMaps[mapID].viewport.xmin= GKS_SCALE*xmin+GKS_XOFF;
  gksMaps[mapID].viewport.xmax= GKS_SCALE*xmax+GKS_XOFF;
  gksMaps[mapID].viewport.ymin= GKS_SCALE*ymin+GKS_YOFF;
  gksMaps[mapID].viewport.ymax= GKS_SCALE*ymax+GKS_YOFF;
  return 0;
}

int GpSetGKSWind(int mapID, GpReal xmin, GpReal xmax,
		 GpReal ymin, GpReal ymax)
{
  if (mapID<1 || mapID>10) return 1;
  gksMaps[mapID].window.xmin= xmin;
  gksMaps[mapID].window.xmax= xmax;
  gksMaps[mapID].window.ymin= ymin;
  gksMaps[mapID].window.ymax= ymax;
  return 0;
}

int GpGetGKSView(int mapID, GpReal *xmin, GpReal *xmax,
		 GpReal *ymin, GpReal *ymax)
{
  if (mapID<0 || mapID>10) return 1;
  *xmin= (gksMaps[mapID].viewport.xmin-GKS_XOFF)/GKS_SCALE;
  *xmax= (gksMaps[mapID].viewport.xmax-GKS_XOFF)/GKS_SCALE;
  *ymin= (gksMaps[mapID].viewport.ymin-GKS_YOFF)/GKS_SCALE;
  *ymax= (gksMaps[mapID].viewport.ymax-GKS_YOFF)/GKS_SCALE;
  return 0;
}

int GpGetGKSWind(int mapID, GpReal *xmin, GpReal *xmax,
		 GpReal *ymin, GpReal *ymax)
{
  if (mapID<0 || mapID>10) return 1;
  *xmin= gksMaps[mapID].window.xmin;
  *xmax= gksMaps[mapID].window.xmax;
  *ymin= gksMaps[mapID].window.ymin;
  *ymax= gksMaps[mapID].window.ymax;
  return 0;
}

/* ------------------------------------------------------------------------ */
/* Control functions (section 9.2 of ANSI FORTRAN binding standard) */

static Engine *gksEngine= 0;
static long gksWKID= 0;

/* ARGSUSED */
void F77_ID(gopks_, gopks, GOPKS)(errfil, bufa)
     long *errfil, *bufa;
{
}

void F77_ID(gclks_, gclks, GCLKS)()
{
}

/* ARGSUSED */
void F77_ID(gopwk_, gopwk, GOPWK)(wkid, conid, wtype)
     long *wkid, *conid, *wtype;
{
  if (gksEngine) GpKillEngine(gksEngine);
  gksEngine= GpCGMEngine("Gist GKS", 0, 0, "gks0.cgm");
  gksWKID= *wkid;
}

/* ARGSUSED */
void F77_ID(gclwk_, gclwk, GCLWK)(wkid)
     long *wkid;
{
  if (gksEngine) GpKillEngine(gksEngine);
  gksEngine= 0;
}

/* ARGSUSED */
void F77_ID(gacwk_, gacwk, GACWK)(wkid)
     long *wkid;
{
  if (gksEngine) GpActivate(gksEngine);
}

/* ARGSUSED */
void F77_ID(gdawk_, gdawk, GDAWK)(wkid)
     long *wkid;
{
  if (gksEngine) GpDeactivate(gksEngine);
}

/* ARGSUSED */
void F77_ID(gclrwk_, gclrwk, GCLRWK)(wkid, cofl)
     long *wkid, *cofl;
{
  if (gksEngine) GpClear(gksEngine, (int)(*cofl));
}

/* ARGSUSED */
void F77_ID(guwk_, guwk, GUWK)(wkid)
     long *wkid;
{
  if (gksEngine) GpFlush(gksEngine);
}

/* ARGSUSED */
void F77_ID(gesc_, gesc, GESC)(fctid, lidr, idr, mlodr, lodr, odr)
     long *fctid, *lidr;
     char *idr;
     long *mlodr, *lodr;
     char *odr;
{
}

/* ------------------------------------------------------------------------ */
/* Output functions (section 9.3 of ANSI FORTRAN binding standard) */

void F77_ID(gpl_, gpl, GPL)(n, px, py)
     long *n;
     GpReal *px, *py;
{
  GpLines(*n, px, py);
}

void F77_ID(gpm_, gpm, GPM)(n, px, py)
     long *n;
     GpReal *px, *py;
{
  GpMarkers(*n, px, py);
}

extern char *strncpy();
static char textBuf[256];
static GpReal saveHeight, saveExpand, saveUpX, saveUpY;

static void GKSTextScale(int on);

static void GKSTextScale(int on)
{
  if (on) {
    GpReal scalx= (gistT.viewport.xmax-gistT.viewport.xmin)/
                  (gistT.window.xmax-gistT.window.xmin);
    GpReal scaly= (gistT.viewport.ymax-gistT.viewport.ymin)/
                  (gistT.window.ymax-gistT.window.ymin);
    saveHeight= gistA.t.height;
    saveExpand= gistA.t.expand;
    saveUpX= gistA.t.upX;
    saveUpY= gistA.t.upY;
    gistA.t.height*= scaly;
    gistA.t.expand*= scalx/scaly;
    gistA.t.upX*= scalx;
    gistA.t.upY*= scaly;
    if (gistA.t.height<0.0) {
      gistA.t.height= -gistA.t.height;
      gistA.t.upX= -gistA.t.upX;
      gistA.t.upY= -gistA.t.upY;
    }
    /* This probably isn't "correct", but who cares?  */
    if (gistA.t.expand<0.0) gistA.t.expand= -gistA.t.expand;
  } else {
    gistA.t.height= saveHeight;
    gistA.t.expand= saveExpand;
    gistA.t.upX= saveUpX;
    gistA.t.upY= saveUpY;
  }
}

/* What FORTRAN needs for a character parameter surely varies from
   platform to platform, and from compiler to compiler...   */
void F77_ID(gtx_, gtx, GTX)(px, py, chars, len)
     GpReal *px, *py;
     char *chars;
     CHAR_LEN len;
{
  GKSTextScale(1);
#ifdef NO_CHAR_LEN
  GpText(*px, *py, chars);
#else
  strncpy(textBuf, chars, len<255? len:255);
  textBuf[255]= '\0';
  GpText(*px, *py, textBuf);
#endif
  GKSTextScale(0);
}

/* GTXS ought to be safer than GTX, but this is still not great...   */
void F77_ID(gtxs_, gtxs, GTXS)(px, py, lstr, chars, len)
     GpReal *px, *py;
     long *lstr;
     char *chars;
     CHAR_LEN len;
{
  strncpy(textBuf, chars, *lstr<255? *lstr:255);
  textBuf[255]= '\0';
  GKSTextScale(1);
  GpText(*px, *py, textBuf);
  GKSTextScale(0);
}

void F77_ID(gfa_, gfa, GFA)(n, px, py)
     long *n;
     GpReal *px, *py;
{
  GpFill(*n, px, py);
}

/* ARGSUSED */
void F77_ID(ggdp_, ggdp, GGDP)(n, px, py, primid, ldr, datrec)
     long *n;
     GpReal *px, *py;
     long *primid, *ldr;
     char *datrec;
{
}

/* Cell array is a Level L0a primitive */
/* ARGSUSED */
void F77_ID(gca_, gca, GCA)(px, py, qx, qy,
			    dimx, dimy, isc, isr, dx, dy, colia)
     GpReal *px, *py, *qx, *qy;
     long *dimx, *dimy, *isc, *isr, *dx, *dy;
     GpColor *colia;
{
  GpCells(*px, *py, *qx, *qy, *dx, *dy, *dimx,
	  colia + (*isc-1)+(*isr-1)*(*dimx));
}

/* ------------------------------------------------------------------------ */
/* Output attributes (section 9.4 of ANSI FORTRAN binding standard) */

void F77_ID(gsln_, gsln, GSLN)(ltype)
     long *ltype;
{
  gistA.l.type= (int)(*ltype);
}

void F77_ID(gslwsc_, gslwsc, GSLWSC)(lwidth)
     GpReal *lwidth;
{
  gistA.l.width= *lwidth;
}

void F77_ID(gsplci_, gsplci, GSPLCI)(coli)
     long *coli;
{
  gistA.l.color= (GpColor)(*coli);
}

/* Same as GSMK for Bruce Langdon */
void F77_ID(gspmi_, gspmi, GSPMI)(mtype)
     long *mtype;
{
  gistA.m.type= (int)(*mtype);
}

void F77_ID(gsmk_, gsmk, GSMK)(mtype)
     long *mtype;
{
  gistA.m.type= (int)(*mtype);
}

void F77_ID(gsmksc_, gsmksc, GSMKSC)(mszsf)
     GpReal *mszsf;
{
  gistA.m.size= *mszsf;
}

void F77_ID(gspmci_, gspmci, GSPMCI)(coli)
     long *coli;
{
  gistA.m.color= (GpColor)(*coli);
}

void F77_ID(gstxfp_, gstxfp, GSTXFP)(font, prec)
     long *font, *prec;
{
  gistA.t.font= (int)(*font);
  gistA.t.prec= (int)(*prec);
}

void F77_ID(gschxp_, gschxp, GSCHXP)(chxp)
     GpReal *chxp;
{
  gistA.t.expand= *chxp;
}

void F77_ID(gschsp_, gschsp, GSCHSP)(chsp)
     GpReal *chsp;
{
  gistA.t.spacing= *chsp;
}

void F77_ID(gstxci_, gstxci, GSTXCI)(coli)
     long *coli;
{
  gistA.t.color= (GpColor)(*coli);
}

void F77_ID(gschh_, gschh, GSCHH)(chh)
     GpReal *chh;
{
  GpReal scale= (gistT.viewport.ymax-gistT.viewport.ymin)/
    (gistT.window.ymax-gistT.window.ymin);
  if (scale<0.0) scale= -scale;
  gistA.t.height= (*chh)*scale;
}

void F77_ID(gschup_, gschup, GSCHUP)(chux, chuy)
     GpReal *chux, *chuy;
{
  gistA.t.upX= *chux;
  gistA.t.upY= *chuy;
}

void F77_ID(gstxp_, gstxp, GSTXP)(txp)
     long *txp;
{
  gistA.t.path= (int)(*txp);
}

void F77_ID(gstxal_, gstxal, GSTXAL)(txalh, txalv)
     long *txalh, *txalv;
{
  gistA.t.alignH= (int)(*txalh);
  gistA.t.alignV= (int)(*txalv);
}

void F77_ID(gsfais_, gsfais, GSFAIS)(ints)
     long *ints;
{
  gistA.f.style= (int)(*ints);
}

void F77_ID(gsfasi_, gsfasi, GSFASI)(styli)
     long *styli;
{
  gistA.f.pattern= (int)(*styli);
}

void F77_ID(gsfaci_, gsfaci, GSFACI)(coli)
     long *coli;
{
  gistA.f.color= (GpColor)(*coli);
}

void F77_ID(gspa_, gspa, GSPA)(szx, szy)
     GpReal *szx, *szy;
{
  gistA.f.sizeX= *szx;
  gistA.f.sizeY= *szy;
}

void F77_ID(gsparf_, gsparf, GSPARF)(rfx, rfy)
     GpReal *rfx, *rfy;
{
  gistA.f.refpX= *rfx;
  gistA.f.refpY= *rfy;
}

/* ARGSUSED */
void F77_ID(gsasf_, gsasf, GSASF)(lasf)
     long lasf[13];
{
}

/* ARGSUSED */
void F77_ID(gscr_, gscr, GSCR)(wkid, ci, cr, cg, cb)
     long *wkid, *ci;
     GpReal *cr, *cg, *cb;
{
}

/* ------------------------------------------------------------------------ */
/* Transformation functions (section 9.5 of ANSI FORTRAN binding standard) */

void F77_ID(gswn_, gswn, GSWN)(tnr, xmin, xmax, ymin, ymax)
     long *tnr;
     GpReal *xmin, *xmax, *ymin, *ymax;
{
  GpSetGKSWind((int)(*tnr), *xmin, *xmax, *ymin, *ymax);
}

void F77_ID(gsvp_, gsvp, GSVP)(tnr, xmin, xmax, ymin, ymax)
     long *tnr;
     GpReal *xmin, *xmax, *ymin, *ymax;
{
  GpSetGKSView((int)(*tnr), *xmin, *xmax, *ymin, *ymax);
}

void F77_ID(gselnt_, gselnt, GSELNT)(tnr)
     long *tnr;
{
  GpSetGKSTrans((int)*tnr);
}

void F77_ID(gsclip_, gsclip, GSCLIP)(clsw)
     long *clsw;
{
  gistClip= (int)*clsw;
}

/* ARGSUSED */
void F77_ID(gswkwn_, gswkwn, GSWKWN)(wkid, xmin, xmax, ymin, ymax)
     long *wkid;
     GpReal *xmin, *xmax, *ymin, *ymax;
{
}

/* ARGSUSED */
void F77_ID(gswkvp_, gswkvp, GSWKVP)(wkid, xmin, xmax, ymin, ymax)
     long *wkid;
     GpReal *xmin, *xmax, *ymin, *ymax;
{
}

/* ------------------------------------------------------------------------ */
/* Inquiry functions (section 9.9 of ANSI FORTRAN binding standard) */

void F77_ID(gqlvks_, gqlvks, GQLVKS)(errind, level)
     long *errind, *level;
{
  *errind= 0;
  *level= -3;
}

void F77_ID(gqewk_, gqewk, GQEWK)(n, errind, number, wktype)
     long *n, *errind, *number, *wktype;
{
  *errind= *n>1;
  *wktype= *number= 1;
}

void F77_ID(gqmntn_, gqmntn, GQMNTN)(errind, maxtnr)
     long *errind, *maxtnr;
{
  *errind= 0;
  *maxtnr= 10;
}

void F77_ID(gqopwk_, gqopwk, GQOPWK)(n, errind, ol, wkid)
     long *n;
     long *errind;
     long *ol, *wkid;
{
  *ol= gksEngine? 1 : 0;
  *wkid= gksWKID;
  *errind= (*n)>(*ol) || (*n)<0;
}

void F77_ID(gqacwk_, gqacwk, GQACWK)(n, errind, ol, wkid)
     long *n;
     long *errind;
     long *ol, *wkid;
{
  *ol= gksEngine? GpActive(gksEngine) : 0;
  *wkid= gksWKID;
  *errind= (*n)>(*ol) || (*n)<0;
}

/* Same as GQMK for Bruce Langdon */
void F77_ID(gqpmi_, gqpmi, GQPMI)(errind, mtype)
     long *errind;
     long *mtype;
{
  *errind= 0;
  *mtype= (long)gistA.m.type;
}

void F77_ID(gqchh_, gqchh, GQCHH)(errind, chh)
     long *errind;
     GpReal *chh;
{
  GpReal scale= (gistT.window.ymax-gistT.window.ymin)/
    (gistT.viewport.ymax-gistT.viewport.ymin);
  if (scale<0.0) scale= -scale;
  *errind= 0;
  *chh= gistA.t.height*scale;
}

void F77_ID(gqchup_, gqchup, GQCHUP)(errind, chux, chuy)
     long *errind;
     GpReal *chux, *chuy;
{
  *errind= 0;
  *chux= gistA.t.upX;
  *chuy= gistA.t.upY;
}

void F77_ID(gqtxp_, gqtxp, GQTXP)(errind, txp)
     long *errind;
     long *txp;
{
  *errind= 0;
  *txp= (long)gistA.t.path;
}

void F77_ID(gqtxal_, gqtxal, GQTXAL)(errind, txalh, txalv)
     long *errind;
     long *txalh, *txalv;
{
  *errind= 0;
  *txalh= (long)gistA.t.alignH;
  *txalv= (long)gistA.t.alignV;
}

void F77_ID(gqpa_, gqpa, GQPA)(errind, szx, szy)
     long *errind;
     GpReal *szx, *szy;
{
  *errind= 0;
  *szx= gistA.f.sizeX;
  *szy= gistA.f.sizeY;
}

void F77_ID(gqparf_, gqparf, GQPARF)(errind, rfx, rfy)
     long *errind;
     GpReal *rfx, *rfy;
{
  *errind= 0;
  *rfx= gistA.f.refpX;
  *rfy= gistA.f.refpY;
}

void F77_ID(gqln_, gqln, GQLN)(errind, ltype)
     long *errind;
     long *ltype;
{
  *errind= 0;
  *ltype= (long)gistA.l.type;
}

void F77_ID(gqlwsc_, gqlwsc, GQLWSC)(errind, lwidth)
     long *errind;
     GpReal *lwidth;
{
  *errind= 0;
  *lwidth= gistA.l.width;
}

void F77_ID(gqplci_, gqplci, GQPLCI)(errind, coli)
     long *errind;
     long *coli;
{
  *errind= 0;
  *coli= (long)gistA.l.color;
}

void F77_ID(gqmk_, gqmk, GQMK)(errind, mtype)
     long *errind;
     long *mtype;
{
  *errind= 0;
  *mtype= (long)gistA.m.type;
}

void F77_ID(gqmksc_, gqmksc, GQMKSC)(errind, mszsf)
     long *errind;
     GpReal *mszsf;
{
  *errind= 0;
  *mszsf= gistA.m.size;
}

void F77_ID(gqpmci_, gqpmci, GQPMCI)(errind, coli)
     long *errind;
     long *coli;
{
  *errind= 0;
  *coli= (long)gistA.m.color;
}

void F77_ID(gqtxfp_, gqtxfp, GQTXFP)(errind, font, prec)
     long *errind;
     long *font, *prec;
{
  *errind= 0;
  *font= (long)gistA.t.font;
  *prec= (long)gistA.t.prec;
}

void F77_ID(gqchxp_, gqchxp, GQCHXP)(errind, chxp)
     long *errind;
     GpReal *chxp;
{
  *errind= 0;
  *chxp= gistA.t.expand;
}

void F77_ID(gqchsp_, gqchsp, GQCHSP)(errind, chsp)
     long *errind;
     GpReal *chsp;
{
  *errind= 0;
  *chsp= gistA.t.spacing;
}

void F77_ID(gqtxci_, gqtxci, GQTXCI)(errind, coli)
     long *errind;
     long *coli;
{
  *errind= 0;
  *coli= (long)gistA.t.color;
}

void F77_ID(gqfais_, gqfais, GQFAIS)(errind, ints)
     long *errind;
     long *ints;
{
  *errind= 0;
  *ints= (long)gistA.f.style;
}

void F77_ID(gqfasi_, gqfasi, GQFASI)(errind, styli)
     long *errind;
     long *styli;
{
  *errind= 0;
  *styli= (long)gistA.f.pattern;
}

void F77_ID(gqfaci_, gqfaci, GQFACI)(errind, coli)
     long *errind;
     long *coli;
{
  *errind= 0;
  *coli= (long)gistA.f.color;
}

void F77_ID(gqasf_, gqasf, GQASF)(errind, lasf)
     long *errind, lasf[13];
{
  int i;
  *errind= 0;
  for (i=0 ; i<13 ; i++) lasf[i]= 1;  /* all attributes "individual" */
}

void F77_ID(gqcntn_, gqcntn, GQCNTN)(errind, tnr)
     long *errind;
     long *tnr;
{
  *errind= 0;
  *tnr= (long)GpGetGKSTrans();
}

void F77_ID(gqnt_, gqnt, GQNT)(tnr, errind, window, viewpt)
     long *tnr;
     long *errind;
     GpReal *window, *viewpt;
{
  *errind= 0;
  GpGetGKSView((int)(*tnr), window, window+1, window+2, window+3);
  GpGetGKSWind((int)(*tnr), viewpt, viewpt+1, viewpt+2, viewpt+3);
}

void F77_ID(gqclip_, gqclip, GQCLIP)(errind, clsw, clrect)
     long *errind;
     long *clsw;
     GpReal *clrect;
{
  *errind= 0;
  *clsw= (long)gistClip;
  if (gistClip) {
    GpGetGKSView(GpGetGKSTrans(), clrect, clrect+1, clrect+2, clrect+3);
  } else {
    clrect[0]= 0.0;
    clrect[1]= 1.0;
    clrect[2]= 0.0;
    clrect[3]= 1.0;
  }
}

void F77_ID(gqwkc_, gqwkc, GQWKC)(wkid, errind, conid, wtype)
     long *wkid, *errind, *conid, *wtype;
{
  *errind= !gksEngine;
  *wkid= gksWKID;
  *conid= 0;
  *wtype= 0;
}

void F77_ID(gqwks_, gqwks, GQWKS)(wkid, errind, state)
     long *wkid;
     long *errind;
     long *state;
{
  if (gksEngine) {
    *errind= 0;
    *state= (long)GpActive(gksEngine);
  } else {
    *errind= 1;
    *state= 0;
  }
}

void F77_ID(gqtxx_, gqtxx, GQTXX)(wkid, px, py, str, errind,
				  cpx, cpy, txexpx, txexpy)
     long *wkid;
     GpReal *px, *py;
     char *str;
     long *errind;
     GpReal *cpx, *cpy;
     GpReal *txexpx, *txexpy;
{
  *errind= 1;
}

void F77_ID(gqtxxs_, gqtxxs, GQTXXS)(wkid, px, py, lstr, str, errind,
				     cpx, cpy, txexpx, txexpy)
     long *wkid;
     GpReal *px, *py;
     long *lstr;
     char *str;
     long *errind;
     GpReal *cpx, *cpy;
     GpReal *txexpx, *txexpy;
{
  *errind= 1;
}

void F77_ID(gqeci_, gqeci, GQECI)(wkid, n, errind, ol, coli)
     long *wkid, *n, *errind, *ol, *coli;
{
  *errind= 1;
}

void F77_ID(gqcr_, gqcr, GQCR)(wkid, coli, type, errind, cr, cg, cb)
     long *wkid, *coli, *type, *errind;
     GpReal *cr, *cg, *cb;
{
  *errind= 1;
}

void F77_ID(gqwkt_, gqwkt, GQWKT)(wkid, errind, tus, rwindo, cwindo,
				  rviewp, cviewp)
     long *wkid, *errind, *tus;
     GpReal *rwindo, *cwindo, *rviewp, *cviewp;
{
  *errind= 1;
}

/* ARGSUSED */
void F77_ID(gqwkca_, gqwkca, GQWKCA)(wtype, errind, wkcat)
     long *wtype, *errind, *wkcat;
{
  *errind= 0;
  *wkcat= 0;
}

/* ARGSUSED */
void F77_ID(gqplf_, gqplf, GQPLF)(wtype, n, errind, nlt, lt,
				  nlw, nomlw, rlwmin, rlwmax, nppli)
     long *wtype, *n, *errind, *nlt, *lt, *nlw;
     GpReal *nomlw, *rlwmin, *rlwmax;
     long *nppli;
{
  *errind= (*n<=5 && *n>=0);
  *nlt= 5;
  *lt= *n;
  *nlw= 0;
  *nomlw= 1.0;
  *rlwmin= 0.0;
  *rlwmax= 100.0;
  *nppli= 0;
}

/* ARGSUSED */
void F77_ID(gqpmf_, gqpmf, GQPMF)(wtype, n, errind, nmt, mt,
				  nms, nomms, rmsmin, rmsmax, nppmi)
     long *wtype, *n, *errind, *nmt, *mt, *nms;
     GpReal *nomms, *rmsmin, *rmsmax;
     long *nppmi;
{
  *errind= (*n<=5 && *n>=0);
  *nmt= 5;
  *mt= *n;
  *nms= 0;
  *nomms= 1.0;
  *rmsmin= 0.0;
  *rmsmax= 100.0;
  *nppmi= 0;
}

/* ARGSUSED */
void F77_ID(gqtxf_, gqtxf, GQTXF)(wtype, n, errind, nfpp, font, prec,
				  nchh, minchh, maxchh,
				  nchx, minchx, maxchx, nptxi)
     long *wtype, *n, *errind, *nfpp, *font, *prec, *nchh;
     GpReal *minchh, *maxchh;
     long *nchx;
     GpReal *minchx, *maxchx;
     long *nptxi;
{
  *errind= (*n<=20 && *n>=0);
  *nfpp= 20;
  *font= *n-1;
  *prec= T_STROKE;
  *nchh= 0;
  *minchh= 0.0;
  *maxchh= 100.0;
  *nchx= 0;
  *minchx= 0.0;
  *maxchx= 100.0;
  *nptxi= 0;
}

/* ARGSUSED */
void F77_ID(gqfaf_, gqfaf, GQFAF)(wtype, ni, nh, errind, nis, is,
				  nhs, hs, npfai)
     long *wtype, *ni, *nh, *errind, *nis, *is, *nhs, *hs, *npfai;
{
  *errind= (*ni<=1 && *ni>=0 && *nh==0);
  *nis= 1;
  *is= 1;
  *nhs= 0;
  *hs= 0;
  *npfai= 0;
}

/* ARGSUSED */
void F77_ID(gqcf_, gqcf, GQCF)(wtype, errind, ncoli, cola, npci)
     long *wtype, *errind, *ncoli, *cola, *npci;
{
  *errind= 0;
  *ncoli= 240;
  *cola= 1;
  *npci= 240;
}

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
