# Config to use for g++
# This is not a complete config; it only overrides those options
# specific to using g++
#

# @(#)config-g++.mk	1.16 2/13/94
# Copyright (c) 1991 The Regents of the University of California.
#                       All Rights Reserved.
#		       
# Programmer:  J. T. Buck

#
# Programs to use
CPLUSPLUS = g++
GPPFLAGS = -O2 -m486 -Dlinux -Dsun -D_GNU_SOURCE -D_BSD_SOURCE -Wall -Wcast-qual -pipe -fomit-frame-pointer $(MEMLOG)
CFLAGS = -O2 -m486 -Dlinux -Dsun -D_GNU_SOURCE -D_BSD_SOURCE -pipe -fomit-frame-pointer -fwritable-strings
DEPEND= $(CPLUSPLUS) -MM

# where the Gnu library is
GNULIB=$(PTOLEMY)/gnu/$(ARCH)/lib

# linker to use for pigi and interpreter.
LINKER=g++
# startup module
CRT0=
# system libraries (libraries from the environment)
SYSLIBS=-lg++ -lbsd -lm
# link flags (tell linker to strip out debug symbols)
# -static prevents use of shared libraries when building ptolemy
# shared libraries interfere with incremental linking of stars.
# -Xlinker specifies that the next argument should be passed verbatim to
# the linker
# -x requests that only global symbols be left in the executable.
# -S requests that the executable be stripped.
# It would see that these two conflict, but using just -x with the gnu
# linker results in a huge executable.
LINKFLAGS=-L$(LIBDIR) -Xlinker -S -Xlinker -x -static
# link flags if debugging symbols are to be left
LINKFLAGS_D=-L$(LIBDIR) -g -static
