# Version @(#)latexinfo.mk	1.4 1/20/94
# Author:	T. M. Parks
# Created:	11 January 1994

# Command used for getting files from SCCS. (Gnu make)
GET=safe-get

LATEXINFO= /usr/tools/gnu/src/latexinfo
TEXINPUTS= .:$(ROOT)/doc/tex:$(LATEXINFO)/styles:$(MORE_TEXINPUTS)

INFO=	-l $(ROOT)/doc/elisp/default.el -l $(LATEXINFO)/.emacs \
	-l latexinfo -l latexinfo-ext -l latexnfo-mde

EMACS= LATEXINFO=$(LATEXINFO) TEXINPUTS=$(TEXINPUTS) emacs-18
TEX= TEXINPUTS=$(TEXINPUTS) latex

# Intermediate files generated by LaTeX.
TEX_CLEAN= $*.aux $*.log $*.lof $*.lot $*.toc $*.glo $*.idx $*.bbl $*.blg

# Intermeditate files generated by LaTeXinfo.
INFO_CLEAN= $*.cp $*.pg $*.fn $*.vr $*.tp $*.ky \
	$*.cps $*.pgs $*.fns $*.vrs $*.tps $*.kys \
	$*.tex~ $*.info~

# Update all nodes and menus in a file.
%.update:	%.tex
	$(EMACS) -batch $(INFO) $< \
		-f latexinfo-every-node-update \
		-f latexinfo-all-menus-update \
		-f save-buffer -kill

# Update all nodes and menus in a master file and all included files.
%.master:	%.tex
	$(EMACS) -batch $(INFO) $< \
		-f disable-read-only \
		-f latexinfo-update-everything \
		-f save-buffer -kill

# Update all nodes and menus in a master file and all included files,
# then generate an info file from the LaTeXinfo source.
%.info:		%.tex
	$(EMACS) -batch $(INFO) -f disable-read-only $< \
		-f latexinfo-update-everything \
		-f latexinfo-format-buffer \
		-f save-buffer -kill

# Intermediate files generated by LaTeX.
%.aux %.log %.lof %.lot %.toc %.glo %.idx %.bbl %.blg:	%.tex
	$(TEX) $<

# Index files generated by LaTeXinfo
%.cp %.pg %.fn %.vr %.tp %.ky:	%.tex
	$(TEX) $<

%.cps:	%.cp
	texindex $<

%.pgs:	%.pg
	texindex $<

%.fns:	%.fn
	texindex $<

%.vrs:	%.vr
	texindex $<

%.tps:	%.tp
	texindex $<

%.kys:	%.ky
	texindex $<

# Output file generated by LaTeX.
%.dvi:	%.tex
	$(TEX) $<

# Convert LaTeX output to PostScript.
%.ps:	%.dvi
	dvips -r -o $@ $<

# Remove all intermediate files.
%.clean:
	rm -f $(TEX_CLEAN) $(INFO_CLEAN)
