%{
#include <string.h>
#include "cdplayer.h"

#ifdef USE_FLEX
#undef YY_INPUT
#define YY_INPUT(b,r,ms) (r=my_yyinput(b,ms))
#else
#undef input
#define input my_yyinput
#endif

/*
 * Since we are only reading the command line, we
 * tell the scanner to ONLY use the first 256 characters
 */
#undef YY_BUF_SIZE
#define YY_BUF_SIZE 512
#undef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 256

%}

ws        [ \t]+
number    [0-9]+

%s DEVNAME
%%

{ws}	;
{number}  { 
            yylval.num=atoi(yytext);
            return NUMBER;
          } 
<DEVNAME>[^ ]+ { 
	yylval.string=strdup(yytext);
	BEGIN 0;
	return (DEVSTRING); }

"-h" |
"--help" |
help     return (CMD_USAGE);

"-d" |
"--device" |
device  { 
	BEGIN DEVNAME;
	return (CMD_DEVICE);
	}

"-t" |
"--tkcd" |
"tkcd"	 return(CMD_TKCD);

"-p" |
"--play" |
play	 return(CMD_PLAY); 

"-s" |
"--stop" |
stop	 return(CMD_STOP);

"-i" |
"--info" |
info	 return(CMD_INFO); 

"-a" |
"--pause" |
pause	{ return(CMD_PAUSE); }

"-r" |
"--resume" |
resume	{ return(CMD_RESUME); }

"-e" |
"--eject" |
eject	{ return(CMD_EJECT); }

"-v" |
"--volume" |
vol |
volume	{ return(CMD_VOLUME); }

"-k" |
"--skip" |
skip	return(CMD_SKIP);

"-u" |
"--status" |
status  return(CMD_STATUS);

.	{ return(yytext[0]); }

%%

extern char cmdline[];
extern int cmdlen;
extern int cmd_done;

/*
 * This routine replaced the normal yyinput routine and take only
 * 256 byte of input from the "command line" and sends it through the parser.
 * This routine is called ONLY once because the second time through it
 * tells the parser there is no more input.
 */

#ifdef USE_FLEX
int my_yyinput(char *buf, int max_size)
{
	if (!cmd_done) {
		memcpy(buf,cmdline,cmdlen);
		cmd_done=1;
		return(cmdlen);
	  } else {
		return(0);
	}
}

#else

int my_yyinput()
{
	static char *p = &cmdline[0];

	return(*p++);
}

#endif
