#ifdef LINUX

 /* Special defines for Linux */
 #define FAR

 #ifdef SUN
  #define CLOCKS_PER_SEC 1000
 #endif

#endif

#ifdef DOS

 /* Special defines for DOS */
 #define FAR far
 #include <conio.h>
 #include <graphics.h>
 #include <dos.h>
 /*
  *  Pointer for writing directly to the screen
  */
 #define screen(i) (*(unsigned char far *)MK_FP(0xA000,i))

#endif /* DOS */

#define VERSION "v.5a1"
#define COPYRIGHT "1995"

#ifdef DEBUG_OUTPUT
 #define DOUT(string) puts(string)
#else
 #define DOUT(string) {}
#endif

/*
 *  Define the DMA buffering scheme.  Note that in the current setup for
 *  running the buffers, having more than two buffers may improve the
 *  continuity of the DMA, but will cause more lag in the display.
 *  Also, the number of buffers must be 2 or greater.
 */
#define BUFFERS 2
#define MAX_LEN 2048

#define WINDOW_TOP 100
#define WINDOW_BOTTOM 380
#define WINDOW_LEFT 64
#define WINDOW_RIGHT 576

#define SRX 320
#define SRY 2
#define FLX 320
#define FLY 14
#define FRX 320
#define FRY 26
#define WFX 320
#define WFY 38
#define DGX 320
#define DGY 50
#define RFX 320
#define RFY 62
#define LVX 224
#define LVY 74
#define MGX 320
#define MGY 86
#define PKX 560
#define PKY 470

#ifdef DOS
 #define GRAPH_COLOR     60
 #define LABEL_COLOR     59
 #define BORDER_COLOR    61
 #define TEXT_COLOR      62
 #define LIGHT_HIGHLIGHT 63
 #define DARK_HIGHLIGHT  56
#else
 #define GRAPH_COLOR     1
 #define LABEL_COLOR     2
 #define BORDER_COLOR    3
 #define TEXT_COLOR      4
 #define LIGHT_HIGHLIGHT 5
 #define DARK_HIGHLIGHT  6
#endif /* DOS */

#define UP_ARROW   0x148
#define DOWN_ARROW 0x150
#define LEFT_ARROW 0x14b
#define RIGHT_ARROW 0x14d
#define CTRL_LEFT  0x173
#define CTRL_RIGHT 0x174
#define CTRL_UP    0x18d
#define CTRL_DOWN  0x191
#define ALT_LEFT   0x19b
#define ALT_RIGHT  0x19d
#define ALT_UP     0x198
#define ALT_DOWN   0x1a0
#define HOME       0x147
#define END        0x14f
#define PGUP       0x149
#define PGDN       0x151
#define TAB        0x09
#define SHFT_TAB   0x10f


struct rgb
{
   int red;
   int green;
   int blue;
};

/* Defines for soundcard usage.  Non-implemented ones are commented out */
#ifdef LINUX
 #define SC_MULAW 0
 #ifndef SUN
  #define SC_LINUX 1
 #endif
#else /* LINUX */
 #define SC_SB8     0
 #define SC_PAS16   1
 #define SC_VESA    2
 /*#define SC_SB16    2*/
 /*#define SC_GUS16   3*/
#endif /* LINUX */

/* Labels used for sound cards in the .ini file */
#define SC_SB8_NAME   "SB"
#define SC_PAS16_NAME "PAS16"
#define SC_VESA_NAME  "VESA"
#define SC_SB16_NAME  "SB16"
#define SC_GUS16_NAME "GUS"
#define SC_LINUX_NAME "LINUX"
#define SC_MULAW_NAME "MULAW"

/* Default soundcard */
#define SC_DEF  0

/* Mixer definitions */
#define MIXER_EXT 0
#define MIXER_INT 1
#define MIXER_MIC 2

/* Default soundblaster settings */
#define SB_IRQ 5
#define SB_DMA 1
#define SB_ADDR 0x220

/*
 *  Functions in SETUPSUB.C
 */
void setnormalpalette(void);
void setbwpalette(void);
void parse_ini_file(void);
void parse_command(int,char *[],char *[]);
void setup_buffers(int);
void compute_window_function(void);
void xrange_check(void);
void setup_xscale(void);
void setup_linscales(void);
void setup_logscales(void);
void frequency_scale(void);
void amplitude_scale(void);
void update_header(void);
void show_help(void);

/*
 *  Functions in PROCINP.C
 */
void setup_vga(void);
void cleanup_vga(void);
int process_input(int);
void highlight(int);
int ctrlcfunc(void);

/*
 *  Functions in PAS.C
 */
#ifdef SC_PAS16
  void init_pas16(void);
  void reset_pas16(void);
  void halt_pas16(void);
  void cleanup_pas16(void);
  void recordblock_pas16(void far *buffer);
  void set_mixer_pas16(int mix,int level);
#endif

/*
 *  Functions in SB.C
 */
#ifdef SC_SB8
  void init_sb8(char **environ);
  void reset_sb8(void);
  void halt_sb8(void);
  void cleanup_sb8(void);
  void recordblock_sb8(void far *buffer);
#endif

/*
 *  Functions in VESADEV.C
 */
#ifdef SC_VESA
  void init_vesa(void);
  void reset_vesa(void);
  void halt_vesa(void);
  void cleanup_vesa(void);
  void recordblock_vesa(void far *buffer);
  void set_mixer_vesa(int mix,int level);
#endif

/*
 *  Functions in LINUX_SC.C
 */
#ifdef SC_LINUX
  void init_linux_sc(void);
  void reset_linux_sc(void);
  void halt_linux_sc(void);
  void cleanup_linux_sc(void);
  void recordblock_linux_sc(void *buffer);
  void set_mixer_linux_sc(int mix,int level);
#endif

/*
 *  Functions in MULAW_SC.C
 */
#ifdef SC_MULAW
  void init_mulaw_sc(void);
  void reset_mulaw_sc(void);
  void halt_mulaw_sc(void);
  void cleanup_mulaw_sc(void);
  void recordblock_mulaw_sc(void *buffer);
  void set_mixer_mulaw_sc(int mix,int level);
#endif


