/*
 *  Routines for sampling from VESA audio AI drivers
 *  These routines require functions described in the VESA AI SDK,
 *  and included with this source.  For the full SDK, refer to:
 *  ftp.uwp.edu:/pub/msdos/proaudio/vaisdk.zip
 *
 *  Copyright (C) 1995  Philip VanBaren
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "freq.h"

#ifdef SC_VESA

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include <graphics.h>
#include "vbeai.h"
#include "vesa.h"
#include "extern.h"

unsigned long bufferlen=0;
unsigned long bufferdiv=0;
VESAHANDLE hWave=0;
GeneralDeviceClass gdc;  // Receives a copy of the VESA driver info block
fpWAVServ wfn=NULL;      // Pointer to wave functions
char far *memptr=NULL;   // Pointer to memory buffer used by the VESA driver
BLOCKHANDLE hBlock[2] = {0,0};
// tables for reporting attached volume info and services
fpVolServ vsptr;

/* Interrupt handler for DMA complete message from VESA driver */
void far pascal Callback(VESAHANDLE han,void far *fptr,long len,long filler)
{
   // Set up the Data Segment register
   _asm {
      push  ds
      mov   ax,seg record_buffer
      mov   ds,ax
   }

   flag[record_buffer]=1;
   if(++record_buffer>=BUFFERS)
      record_buffer=0;

   if(gdc.u.gdwi.wifeatures & WAVEPREPARE)
      (wfn->wsWavePrepare)(0,sample_size,0,fptr,len);

   _asm {
      pop   ds
   }
}
// Null callback function
void far pascal NullFunc(VESAHANDLE han,void far *fptr,long len,long filler)
{
}

void init_vesa(void)
{
   int volsize=0;

   hWave = VESAFindADevice(WAVDEVICE);
   if(hWave==0)
   {
      puts("The VESA audio AI is not installed.");
      exit(1);
   }
   if(VESAQueryDevice(hWave,VESAQUERY2,&gdc) == 0)
   {
      VESACloseDevice(hWave);
      puts("Cannot query the installed AI device.");
      closegraph();
      puts("Cannot query the installed AI device.");
      exit(1);
   }
   if(gdc.gdclassid != WAVDEVICE)
   {
      VESACloseDevice(hWave);
      puts("The VESA audio AI returned a non-DAC device.");
      closegraph();
      puts("The VESA audio AI returned a non-DAC device.");
      exit(1);
   }
   // Print some GDC information
   // PrintGeneralDeviceInfo(&gdc,hWave);

   if((memptr = (char far *)AllocateBuffer(gdc.u.gdwi.wimemreq))==NULL)
   {
      VESACloseDevice(hWave);
      puts("There is not enough memory for the VESA audio device.");
      closegraph();
      puts("There is not enough memory for the VESA audio device.");
      exit(1);
   }
   if((wfn = (fpWAVServ)VESAOpenADevice(hWave,0,memptr)) == NULL)
   {
      VESACloseDevice(hWave);
      puts("Unable to open the installed audio device.");
      closegraph();
      puts("Unable to open the installed audio device.");
      exit(1);
   }
   // Set up the callback routines
   wfn->wsApplRSyncCB = &Callback;
   wfn->wsApplPSyncCB = &NullFunc;

   // Check for a volume device
/*   if((volsize=VESAQueryDevice(hWave,VESAQUERY3,0)) != 0)
   {
      mixers=1;
      if((vsptr = (fpVolServ)AllocateBuffer(volsize))==NULL)
      {
         VESACloseDevice(hWave);
         closegraph();
         puts("There is not enough memory for the VESA volume device.");
         exit(1);
      }
      // Get the Volume Info block
      VESAQueryDevice(hWave,VESAQUERY4,vsptr);
      set_mixer=set_mixer_vesa;
   }
*/
   // Set up soundcard functions
   reset_soundcard=reset_vesa;
   halt_soundcard=halt_vesa;
   cleanup_soundcard=cleanup_vesa;
   recordblock=recordblock_vesa;
   set_mixer=NULL;
   mixers=0;
   // Check for supported modes
   if(gdc.u.gdwi.wiSampleSize&WAVE16BITREC)
      sample_size=16;
   else
      sample_size=8;
}

void set_mixer_vesa(int mix,int level)
{

}

void reset_vesa(void)
{
   /*
    *  Initialize VESA audio AI stuff
    */
   int i;

   // Verify the SampleRate variable
   // SampleRate=(wfn->wsDeviceCheck)(WAVESAMPLERATE,SampleRate);

   // Select the stereo mode, sampling rate, and bits per sample
   (wfn->wsPCMInfo)(1,SampleRate,0,0,sample_size);
   bufferlen=fftlen*(sample_size/8);
   bufferdiv=bufferlen/2;

   // Reset the buffer pointers
   queue_buffer=0;     // Pointer to next buffer to be queued
   record_buffer=0;    // Pointer to next buffer to be filled
   process_buffer=0;   // Pointer to next buffer to be FFTed

   for(i=0;i<BUFFERS;i++)
   {
      flag[i]=0;
      if(hBlock[i])
         (wfn->wsWaveRegister)(0,hBlock[i]);
      hBlock[i] = (wfn->wsWaveRegister)(buffer[i],fftlen*(sample_size/8));
   }
   /*
    *  This function starts the DMA process.
    */
   recordblock_vesa(buffer[queue_buffer]);
   if(++queue_buffer>=BUFFERS)
      queue_buffer=0;
}

void halt_vesa(void)
{
   (wfn->wsStopIO)(0);
}

void cleanup_vesa(void)
{
   // Clean up the VESA audio AI
   int i,stat;

   VESACloseDevice(hWave);
   if(memptr)
   {
      FreeBuffer(memptr);
      memptr=NULL;
   }
   if(vsptr)
   {
      FreeBuffer(vsptr);
      vsptr=NULL;
   }
}

void recordblock_vesa(void far *buffer)
{
   /*
    *  Start recording a new buffer.
    */
//   (wfn->wsRecordCont)(buffer,bufferlen,bufferdiv);
   (wfn->wsRecordBlock)(hBlock[queue_buffer],0);
}

#endif

