/* Demo program using the SunOS 4.0.2 "atio.o" device driver for AT-bus I/O */

/* Written by Per Sigmond <Per.Sigmond@hiagder.no> */

/* You must first load the driver /etc/modules/atio.o using modload */

/* WARNING 1: 	If your AT card is slow and uses the IO_READY pin to hold the
   		bus, the kernel will very likely panic stating a bus timeout
		has occurred (the IO_READY pin is A10 on the AT-bus).
   WARNING 2:	This program hard-codes port-address to 0x300 and writes this
		address with value 0xaa. Change it to an address/value
		you know you can write without causing damage.
*/


#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sun/atio.h>

main() {

int fd;
struct atio_port port;

	port.addr = 0x300;
	port.data = 0x00;

	fd = open( "/dev/atio", O_RDWR );

	if (fd < 0) {
		perror("open");
		exit(0);
	}

	/* Read port: */
	if (ioctl( fd, ATIO_INB, &port ) < 0) {
		perror("ioctl");
		exit(0);
	}
	/* Print result: */
	printf("addr: %x val: %x\n", port.addr, (u_char) port.data );


	/* Write port (value 0xaa): */
	port.data = 0xaa;
	if (ioctl( fd, ATIO_OUTB, &port ) < 0) {
		perror("ioctl");
		exit(0);
	}

	/* Read it again: */
	if (ioctl( fd, ATIO_INB, &port ) < 0) {
		perror("ioctl");
		exit(0);
	}
	/* Print result: */
	printf("addr: %x val: %x\n", port.addr, (u_char) port.data );

	close( fd );
}
