// jazz.cc,v 2.1 1995/06/19 19:04:42 andreas Exp

/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef wx_wxh
#include <wx.h>
#endif

#include "song.h"
#include "trackwin.h"
#include "filter.h"

#include "mstdfile.h"
#include "player.h"
#include "jazz.h"
#include <ctype.h>
#include <assert.h>

// -------------------------- global config -----------------------------------

tNamedValue *DrumNames;
tNamedValue *VoiceNames;
tNamedValue *ControlNames;
int DrumChannel;

static void InitConfig(void)
{
  int i;

  DrumChannel = 10;

  DrumNames = new tNamedValue [130];
  for (i = 0; i < 129; i++)
  {
    DrumNames[i].Value = i;
    DrumNames[i].Name  = "";
  }
  DrumNames[129].Name = 0;

  VoiceNames = new tNamedValue [319];
  for (i = 0; i < 318; i++)
  {
    VoiceNames[i].Value = i;
    VoiceNames[i].Name  = "";
  }
  VoiceNames[0].Name = "None";
  VoiceNames[318].Name = 0;

  ControlNames = new tNamedValue [130];
  for (i = 0; i < 129; i++)
  {
    ControlNames[i].Value = i;
    ControlNames[i].Name  = "";
  }
  ControlNames[129].Name = 0;
}



static void LoadConfig(FILE *fd)
{
  char buf[1000];
  int i, j, voice_index = 0;
  tNamedValue *nv = 0;
  while (fgets(buf, sizeof(buf), fd) != NULL)
  {
    if (strncmp(buf, ".drumchannel", 12) == 0)
      sscanf(buf, ".drumchannel %d", &DrumChannel);
    else if (strncmp(buf, ".drumnames", 10) == 0)
      nv = DrumNames;
    else if (strncmp(buf, ".voicenames", 11) == 0)
      	nv = VoiceNames;
    else if (strncmp(buf, ".ctrlnames", 10) == 0)
      nv = ControlNames;
    else if (nv && isdigit(buf[0]))
    {
	if (nv == VoiceNames) {
		assert( 0 <= voice_index && voice_index <= 317);
      		sscanf(buf, " %d %n", &i, &j);
      		assert(0 <= i && i <= 32639);
      		buf[ strlen(buf)-1 ] = 0;	// cut off \n
		nv[voice_index+1].Value = i + 1;
      		nv[voice_index+1].Name = strdup(buf + j);
		voice_index++;
	}
	else {
      		sscanf(buf, " %d %n", &i, &j);
      		assert(0 <= i && i <= 127);
      		buf[ strlen(buf)-1 ] = 0;	// cut off \n
      		nv[i+1].Name = strdup(buf + j);
	}
    }
  }
}

// --------------------------- jazz application -------------------------------


class tApp: public wxApp
{
  public:
    wxFrame *OnInit(void);
};


// This statement initialises the whole application
tApp     myApp;

extern char *midinethost; /* in player.cc */

wxFrame *tApp::OnInit(void)
{
  FILE *fd;

  tSong *Song = new tSong;
#ifdef wx_msw
  Midi = new tNullPlayer(Song);
#else
  Midi = new tMpuPlayer(Song);
  if (!Midi->Installed())
  {
    fprintf(stderr, "Could not connect to midinet server at host '%s'\n", midinethost );
    fprintf(stderr, "Jazz will start with no play/record ability\n");
    Midi = new tNullPlayer(Song);
  }
#endif
  TrackWin = new tTrackWin(0, "Jazz!", Song);
  TrackWin->Create();

  InitConfig();
#ifdef wx_msw
  fd = fopen("jazz.cfg", "r");
#else
  fd = fopen(".jazz", "r");
#endif
  if (!fd)
    fd = fopen("~/.jazz", "r");
  if (fd)
  {
    LoadConfig(fd);
    fclose(fd);
  }

  fd = fopen("jazz.mid", "r");
  if (fd)
  {
    fclose(fd);
    tStdRead io;
    Song->Read(io, "jazz.mid");
  }

  return TrackWin;
}

