/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  Portions Copyright (C) 1995 Per Sigmond (Per.Sigmond@hiagder.no)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* midinet.c using TCP protocol - Written by Per Sigmond, HiA			*/

#include <stdio.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#ifdef sun
#include <sys/filio.h>
#endif
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>

/* midinetconnect():						*/
/* Input parameters:                                            */
/* host - name of remote machine                                */
/* service - service name of corresponding server program       */
/* Returns: descriptor of open active connected tcp socket	*/
int midinetconnect(char *hostname, char *service)
{
struct sockaddr_in remote_addr;
struct hostent *host;
struct protoent *pent;
struct servent *sent;
int s, val;

/* Get remote IP-address */
host = gethostbyname(hostname);
if(host == NULL){
 	fprintf(stderr,"\n uknown host %s ",hostname);
   	exit(2);
}

/* Build remote address-structure */
remote_addr.sin_family = AF_INET;
memcpy( &remote_addr.sin_addr, host->h_addr, host->h_length);

sent = getservbyname(service,"tcp");
if (!sent) {
	perror("getservbyname");
	return(-1);
}

remote_addr.sin_port = sent->s_port;

/* Open socket */
s = socket( AF_INET, SOCK_STREAM, 0 );
if ( s < 0 ) {
	perror("socket ");
     	exit(1);
}

pent = getprotobyname("tcp");
val = 1;
if ( setsockopt(s, pent->p_proto, TCP_NODELAY, (char*) &val, sizeof(val) ) < 0) {
	perror("setsockopt");
	close(s);
	exit(1);
}

/* Connect to remote host */
if( connect(s, (struct sockaddr*) &remote_addr,sizeof(remote_addr)) < 0){
	perror("connect");
	close(s);
     	return(-1);
}
if ( ioctl( s, FIONBIO, &val ) < 0 ) {
	perror("ioctl");
	close(s);
	exit(1);
}
return(s);
}
