// trackwin.h,v 2.1 1995/06/19 19:04:49 andreas Exp

/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef trackwin_h
#define trackwin_h

#ifndef eventwin_h
#include "eventwin.h"
#endif



#define MaxBars 200

struct tRecordInfo
{
  tTrack *Track;
  long   FromClock;
  long   ToClock;
  long   TrackNr;
  int    Muted;
};


enum tCounterModes
{
  CmProgram,
  CmBank,
  CmVolume,
  CmPan,
  CmReverb,
  CmChorus,
  CmModes
};


enum tNumberModes
{
  NmTrackNr,
  NmMidiChannel,
  NmModes
};

class tTrackWin : public tEventWin
{
    int xNumber, wNumber;
    int xName,   wName;
    int xState,  wState;
    int xPatch,  wPatch;

    int nBars;
    long xBars[MaxBars];


  public:
    tNumberModes NumberMode;	// what to show
    tCounterModes CounterMode;	// what to show
    void DrawNumbers();
    void DrawSpeed(int Value = -1);
    void DrawCounters();

    long tTrackWin::x2xBar(long x);
    long tTrackWin::x2wBar(long x);
    tTrack *y2Track(long y);

    void Mark(long x, long y);	// Takt markieren
    void UnMark();
    tRect Marked;

    Bool OnClose();
    void Setup();

    tTrackWin(wxFrame *frame, char *title, tSong *song);
    void CreateMenu();
    void OnMenuCommand(int Id);
    void OnPaint(int What, long x, long y, long w, long h);
    void SnapSelStart(wxMouseEvent &e);
    void SnapSelStop(wxMouseEvent &e);


    int OnMouseEvent(wxMouseEvent &e);
    void MouseNumber(wxMouseEvent &);
    void MouseName(wxMouseEvent &);
    void MouseState(wxMouseEvent &);
    void MousePatch(wxMouseEvent &);
    void MouseEvents(wxMouseEvent &);
    void MousePlay(wxMouseEvent &e);
    void NewPlayPosition(long Clock);
    void MouseSpeed(wxMouseEvent &e);

    tRecordInfo RecInfo;

    void MenCopy();
    void MenSongSettings();
    void MenSplitTracks();
    void MenMergeTracks();
    void MenMixer();
    void MenVibrato();
    void MenSound();
    void MenEnvelope();
    void MenWheel();
    void MenEffects();
    void MenClockSource();
};


struct tSliderArray {
        tTrackWin *tw;
        wxSlider *slider;
        tTrack *track;
};

extern tTrackWin *TrackWin;


#endif

