/*
   CAM - Cpu's Audio Mixer for Linux 
 
   AUTHOR: Jan 'TWP' VANDENBERGHE (jvdbergh@uia.ua.ac.be)
 
 
 
   HISTORY:
 
   22/11/94 - added some suggestions from users 
                ( eg $HOME/.camrc for saving settings )
            - version 0.7     
 
   18/10/94 - fixed bug with ncurses 1.8.5
            - version 0.6

   13/08/94 - Added color support
            - command line support
	    - version 0.5 .

   11/08/94 - split cam.c up in cam.c, screens.c and sounds.c
            - Internal code changes
            - version 0.4 .

   10/08/94 - Internal code changes.
            - Possible to choose record source.
	    - version 0.3 .

   09/08/94 - Possible to change volume of left and right channel separatly.
            - Some minor bug fixes.
            - version 0.2 .

   07/08/94 - Simple audio mixer.
            - Version 0.1 .
 
*/


/*   
     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2
     of the License, or (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/



#include <stdio.h>
#include <stdlib.h>
#include <ncurses/ncurses.h>

#include "screens.h"
#include "sounds.h"

void main(int argc, char *argv[])
{
  init_sound();  
  if (argc == 1)
  {   
     stdscr = initscr();
     touchwin(stdscr);
     leaveok(stdscr, TRUE);
     make_colors();     
     refresh();
     put_screen();
     ctrl_slide();
     stop();
  }
  else
     set_sound(argc, argv);
}
/* End of main() */




