/* 
 * SlideP.h - Private definitions for Slide widget
 *
 * (c) 1995 by Martin Denn <mdenn@unix-ag.uni-kl.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _SlideP_h
#define _SlideP_h

/*
 * This include not needed unless the .c file includes IntrinsicP.h
 * after this file.   Anyway, it doesn't hurt.
 */
#include <X11/CoreP.h>

/*
 * This one is always needed!
 */
#include "Slide.h"

/* New fields for the Slide widget class record */

/* There is no need for new fields, but the compiler needs something... */
typedef struct {
	int make_compiler_happy;	/* keep compiler happy */
} SlideClassPart;

/* Full class record declaration */
typedef struct _SlideClassRec {
    CoreClassPart	core_class;
    SlideClassPart	slide_class;
} SlideClassRec;

extern SlideClassRec slideClassRec;

/* New fields for the Slide widget record */
typedef struct {
    /* resources */
    Pixel	slide_color;
    Boolean	common;
    int		left_value;
    int		right_value;
    int		number_of_LEDs;
    Pixmap	pixmap;
    Pixel	slide_background;
    XtCallbackList callback;	/* application installed callback function(s) */
    Boolean	rb_exists;
    Boolean	rb_on;
    Pixel	rb_color;
    Pixel	rb_back_color;
    XtCallbackList rb_callback;

    /* private state */
    GC		gc;		/* the used gc */
} SlidePart;

/*
 * Full instance record declaration
 */
typedef struct _SlideRec {
    CorePart		core;
    SlidePart		slide;
} SlideRec;

#endif /* _SlideP_h */
