
/* Copyright (C) 1995 by Andrew Robinson */
/* This file is part of the gmod package */

#ifdef USE_X
#include <stdlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>

#include <Xfwf/Alert.h>
#include <Xfwf/FileComp.h>

#include "xdefines.h"
#include "xstructs.h"
#include "xglobals.h"
#include "xprotos.h"

#include "defines.h"
#include "structs.h"
#include "globals.h"

void write_playlist ();
void callback_select (Widget, XtPointer, XtPointer);
void callback_unmap (Widget, XtPointer, XtPointer);
void callback_save_ok (Widget, XtPointer, XtPointer);
void AlertClose (Widget, XEvent *, String *, Cardinal *);

void
callback_info_close (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown (x_info.infoShell.w);
  XtVaSetValues (x_info.topShell.topBox.infoCommand,
		 XtNsensitive, True, NULL);
}

void
callback_info_current (Widget w, XtPointer client_data, XtPointer call_data)
{
  if ((current_mod >= 0) && (current_mod < x_info.nrFileStrings))
    XawListHighlight (x_info.infoShell.infoPane.fileView.fileList,
		      current_mod);
  else
    XawListUnhighlight (x_info.infoShell.infoPane.fileView.fileList);
}

void
callback_info_add (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtRemoveAllCallbacks (x_info.selShell.fileComp, XtNcallback);
  XtRemoveAllCallbacks (x_info.selShell.fileComp, XtNcancelCallback);

  XtAddCallback (x_info.selShell.fileComp, XtNcallback,
		 callback_select, (XtPointer) 0);

  XtAddCallback (x_info.selShell.fileComp, XtNcancelCallback,
		 callback_unmap, (XtPointer) 0);

  XfwfFileCompleteTrimToPath (x_info.selShell.fileComp);

  XtVaSetValues (x_info.selShell.w, XtNtitle, "Xgmod File Selector - Add",
		 NULL);
  XtVaSetValues (x_info.infoShell.infoPane.commandBox.addCommand,
		 XtNsensitive, False, NULL);
  XtVaSetValues (x_info.infoShell.infoPane.commandBox.saveCommand,
		 XtNsensitive, False, NULL);

  XtPopup (x_info.selShell.w, XtGrabNone);
}

void
callback_info_play (Widget w, XtPointer client_data, XtPointer call_data)
{
  XawListReturnStruct *list_ret;

  list_ret = XawListShowCurrent (x_info.infoShell.infoPane.fileView.fileList);
  if (list_ret->list_index != XAW_LIST_NONE)
    {
      current_mod = list_ret->list_index;
      stop_flag = STOP_GOTO;
      dump_enabled = 0;
      callback_arg = INPUTS_BUTTON;
    }
  else
    /*
	create_popup (x_info.infoShell.w, "A file is not selected.\n\nPlease select a file before\nclicking the Play button.");
*/
    create_popup (x_info.infoShell.w, x_info.infoShell.infoAlerts.playAlert);
}

void
callback_info_remove (Widget w, XtPointer client_data, XtPointer call_data)
{
  XawListReturnStruct *list_ret;
  int highlight;

  list_ret = XawListShowCurrent (x_info.infoShell.infoPane.fileView.fileList);
  if (list_ret->list_index != XAW_LIST_NONE)
    {
      free (x_info.fileStrings[list_ret->list_index]);
      x_info.nrFileStrings--;

      if (x_info.nrFileStrings != list_ret->list_index)
	memmove (x_info.fileStrings + list_ret->list_index,
		 x_info.fileStrings + list_ret->list_index + 1,
	   (x_info.nrFileStrings - list_ret->list_index) * sizeof (String));

      x_info.fileStrings =
	realloc (x_info.fileStrings, sizeof (String) * x_info.nrFileStrings);

      XawListChange (x_info.infoShell.infoPane.fileView.fileList,
		     x_info.fileStrings, x_info.nrFileStrings, 0, True);

      if (x_info.nrFileStrings == 0)
	{
	  XawListChange (x_info.infoShell.infoPane.fileView.fileList,
			 empty_list, 1, 0, True);
	  XtVaSetValues (x_info.infoShell.infoPane.fileView.fileList,
			 XtNsensitive, False, NULL);
	}
      else
	{
	  XawListChange (x_info.infoShell.infoPane.fileView.fileList,
			 x_info.fileStrings, x_info.nrFileStrings, 0, True);
	  highlight = list_ret->list_index;
	  if (highlight >= x_info.nrFileStrings)

	    highlight--;
	  XawListHighlight (x_info.infoShell.infoPane.fileView.fileList,
			    highlight);
	}

      if (list_ret->list_index == current_mod)
	{
	  stop_flag = STOP_GOTO;
	  dump_enabled = 0;
	  callback_arg = INPUTS_BUTTON;
	}
      else if (list_ret->list_index < current_mod)
	current_mod--;

      if (x_info.nrFileStrings == 0)
	current_mod = -1;

      check_buttons ();
    }
  else
    /*
    create_popup (x_info.infoShell.w, "A file is not selected.\n\nPlease select a file before\nclicking the Remove button.");
*/
    create_popup (x_info.infoShell.w, x_info.infoShell.infoAlerts.removeAlert);

}

void
callback_info_clear (Widget w, XtPointer client_data, XtPointer call_data)
{
  int i;

  for (i = 0; i < x_info.nrFileStrings; i++)
    free (x_info.fileStrings[i]);
  free (x_info.fileStrings);
  x_info.nrFileStrings = 0;
  x_info.fileStrings = NULL;
  XawListChange (x_info.infoShell.infoPane.fileView.fileList,
		 empty_list, 1, 0, True);
  XtVaSetValues (x_info.infoShell.infoPane.fileView.fileList,
		 XtNsensitive, False, NULL);
  current_mod = -1;
  stop_flag = STOP_GOTO;
  dump_enabled = 0;
  callback_arg = INPUTS_BUTTON;
}

void
callback_info_save (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtRemoveAllCallbacks (x_info.selShell.fileComp, XtNcallback);
  XtRemoveAllCallbacks (x_info.selShell.fileComp, XtNcancelCallback);

  XtAddCallback (x_info.selShell.fileComp, XtNcallback,
		 callback_save_ok, (XtPointer) 0);

  XtAddCallback (x_info.selShell.fileComp, XtNcancelCallback,
		 callback_unmap, (XtPointer) 1);

  XfwfFileCompleteTrimToPath (x_info.selShell.fileComp);

  XtVaSetValues (x_info.selShell.w, XtNtitle, "Xgmod File Selector - Save",
		 NULL);
  XtVaSetValues (x_info.infoShell.infoPane.commandBox.addCommand,
		 XtNsensitive, False, NULL);
  XtVaSetValues (x_info.infoShell.infoPane.commandBox.saveCommand,
		 XtNsensitive, False, NULL);

  XtPopup (x_info.selShell.w, XtGrabNonexclusive);
}

void
callback_info_shuffle (Widget w, XtPointer client_data, XtPointer call_data)
{
  int i, swap_num;
  String tmp_string;
  XawListReturnStruct *list_ret;

  for (i = 0; i < x_info.nrFileStrings; i++)
    {
      swap_num = rand () % x_info.nrFileStrings;

      tmp_string = x_info.fileStrings[i];
      x_info.fileStrings[i] = x_info.fileStrings[swap_num];
      x_info.fileStrings[swap_num] = tmp_string;

      if (current_mod == i)
	current_mod = swap_num;
      else if (swap_num == current_mod)
	current_mod = i;
    }

  list_ret = XawListShowCurrent (x_info.infoShell.infoPane.fileView.fileList);

  XawListChange (x_info.infoShell.infoPane.fileView.fileList,
		 x_info.fileStrings, x_info.nrFileStrings, 0, True);

  if (list_ret->list_index != XAW_LIST_NONE)
    XawListHighlight (x_info.infoShell.infoPane.fileView.fileList,
		      list_ret->list_index);
}

void
InfoClose (Widget w, XEvent *event, String *parms, Cardinal *nparms)
{
  callback_info_close (w, (XtPointer)0, (XtPointer)0);
}

void
create_info (void)
{
  static XtActionsRec infoActionsTable[] =
  {
    {"infoClose", (XtActionProc)InfoClose},
    {"alertClose", (XtActionProc)AlertClose}
  };

  x_info.infoShell.w =
  XtVaCreatePopupShell ("infoShell", topLevelShellWidgetClass,
			x_info.topShell.w,
			XtNtitle, "Xgmod Module Information",
			XtNiconName, "Xgmod Info", NULL);

  XtAppAddActions (x_info.app_context, infoActionsTable, XtNumber(infoActionsTable));

  XtOverrideTranslations (x_info.infoShell.w,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: infoClose()"));

  x_info.infoShell.infoPane.w =
    XtVaCreateManagedWidget ("infoPane", panedWidgetClass,
			     x_info.infoShell.w, NULL);

  x_info.infoShell.infoPane.nameForm.w =
    XtVaCreateManagedWidget ("nameForm", formWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNskipAdjust, True,
			     XtNshowGrip, False,
			     XtNresizeToPreferred, True,
			     NULL);

  x_info.infoShell.infoPane.positionForm.w =
    XtVaCreateManagedWidget ("positionForm", formWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNskipAdjust, True,
			     XtNshowGrip, False,
			     XtNresizeToPreferred, True,
			     NULL);

  x_info.infoShell.infoPane.nameForm.nameLabel =
    XtVaCreateManagedWidget ("nameLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.nameForm.w,
			     XtNlabel, "                                ",
			     XtNborderWidth, 0,
			     XtNtop, XawChainTop,
			     XtNleft, XawChainLeft,
			     XtNbottom, XawChainTop,
			     XtNright, XawChainRight,
			     NULL);

  x_info.infoShell.infoPane.nameForm.typeLabel =
    XtVaCreateManagedWidget ("typeLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.nameForm.w,
			     XtNlabel, "                                 ",
			     XtNborderWidth, 0,
			     XtNdisplayCaret, False,
			     XtNright, XawChainRight,
			     XtNleft, XawChainLeft,
			     XtNbottom, XawChainTop,
			     XtNtop, XawChainTop,
		  XtNfromVert, x_info.infoShell.infoPane.nameForm.nameLabel,
			     NULL);

  x_info.infoShell.infoPane.positionForm.posNameLabel =
    XtVaCreateManagedWidget ("posNameLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.positionForm.w,
			     XtNlabel, "Position (000):",
			     XtNborderWidth, 0,
			     XtNtop, XawChainTop,
			     XtNleft, XawChainLeft,
			     XtNright, XawChainLeft,
			     XtNbottom, XawChainTop,
			     NULL);

  x_info.infoShell.infoPane.positionForm.posLabel =
    XtVaCreateManagedWidget ("posLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.positionForm.w,
			     XtNlabel, "000",
			     XtNborderWidth, 0,
			     XtNjustify, XtJustifyLeft,
			     XtNtop, XawChainTop,
			     XtNleft, XawChainLeft,
			     XtNright, XawChainLeft,
			     XtNbottom, XawChainTop,
	  XtNfromHoriz, x_info.infoShell.infoPane.positionForm.posNameLabel,
			     NULL);

  x_info.infoShell.infoPane.positionForm.patNameLabel =
    XtVaCreateManagedWidget ("patNameLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.positionForm.w,
			     XtNlabel, " Pattern (000):",
			     XtNborderWidth, 0,
			     XtNtop, XawChainTop,
			     XtNleft, XawChainRight,
			     XtNright, XawChainRight,
			     XtNbottom, XawChainTop,
	      XtNfromHoriz, x_info.infoShell.infoPane.positionForm.posLabel,
			     NULL);

  x_info.infoShell.infoPane.positionForm.patLabel =
    XtVaCreateManagedWidget ("patLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.positionForm.w,
			     XtNlabel, "000",
			     XtNborderWidth, 0,
			     XtNjustify, XtJustifyLeft,
			     XtNtop, XawChainTop,
			     XtNleft, XawChainRight,
			     XtNright, XawChainRight,
			     XtNbottom, XawChainTop,
	  XtNfromHoriz, x_info.infoShell.infoPane.positionForm.patNameLabel,
			     NULL);

  x_info.infoShell.infoPane.commentLabel =
    XtVaCreateManagedWidget ("commentLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNlabel, "Comment",
			     XtNskipAdjust, True,
			     XtNshowGrip, False,
			     XtNresizeToPreferred, True,
			     NULL);

  x_info.infoShell.infoPane.commentText =
    XtVaCreateManagedWidget ("commentText", asciiTextWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNdisplayCaret, False,
			     XtNeditType, XawtextRead,
			     XtNscrollVertical, XawtextScrollWhenNeeded,
			     XtNwrap, XawtextWrapWord,
			     NULL);

  x_info.infoShell.infoPane.sampleLabel =
    XtVaCreateManagedWidget ("sampleLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNlabel, "Samples",
			     XtNskipAdjust, True,
			     XtNshowGrip, False,
			     XtNresizeToPreferred, True,
			     NULL);

  x_info.infoShell.infoPane.sampleView.w =
    XtVaCreateManagedWidget ("sampleView", viewportWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNallowVert, True,
			     XtNallowHoriz, True,
			     NULL);

  x_info.infoShell.infoPane.sampleView.sampleList =
    XtVaCreateManagedWidget ("sampleList", listWidgetClass,
			     x_info.infoShell.infoPane.sampleView.w,
			     XtNlist, empty_list,
			     XtNnumberStrings, 1,
			     XtNdefaultColumns, 1,
			     XtNforceColumns, True,
			     NULL);

  XtUninstallTranslations (x_info.infoShell.infoPane.sampleView.sampleList);

  x_info.infoShell.infoPane.fileLabel =
    XtVaCreateManagedWidget ("fileLabel", labelWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNlabel, "File Queue",
			     XtNskipAdjust, True,
			     XtNshowGrip, False,
			     XtNresizeToPreferred, True,
			     NULL);

  x_info.infoShell.infoPane.fileView.w =
    XtVaCreateManagedWidget ("fileView", viewportWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNallowVert, True,
			     XtNallowHoriz, True,
			     NULL);

  x_info.infoShell.infoPane.fileView.fileList =
    XtVaCreateManagedWidget ("fileList", listWidgetClass,
			     x_info.infoShell.infoPane.fileView.w,
			     XtNlist, empty_list,
			     XtNnumberStrings, 1,
			     XtNdefaultColumns, 1,
			     XtNforceColumns, True, NULL);

  x_info.infoShell.infoPane.commandBox.w =
    XtVaCreateManagedWidget ("commandBox", boxWidgetClass,
			     x_info.infoShell.infoPane.w,
			     XtNskipAdjust, True,
			     XtNshowGrip, False,
			     XtNresizeToPreferred, True,
			     NULL);

  x_info.infoShell.infoPane.commandBox.closeCommand =
    XtVaCreateManagedWidget ("closeCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Close",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.closeCommand,
		 XtNcallback, callback_info_close, (XtPointer) 0);

  x_info.infoShell.infoPane.commandBox.currentCommand =
    XtVaCreateManagedWidget ("currentCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Current",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.currentCommand,
		 XtNcallback, callback_info_current, (XtPointer) 0);

  x_info.infoShell.infoPane.commandBox.playCommand =
    XtVaCreateManagedWidget ("playCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Play",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.playCommand,
		 XtNcallback, callback_info_play, (XtPointer) 0);

  x_info.infoShell.infoPane.commandBox.addCommand =
    XtVaCreateManagedWidget ("addCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Add",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.addCommand,
		 XtNcallback, callback_info_add, (XtPointer) 0);

  x_info.infoShell.infoPane.commandBox.removeCommand =
    XtVaCreateManagedWidget ("removeCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Remove",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.removeCommand,
		 XtNcallback, callback_info_remove, (XtPointer) 0);

  x_info.infoShell.infoPane.commandBox.clearCommand =
    XtVaCreateManagedWidget ("clearCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Clear",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.clearCommand,
		 XtNcallback, callback_info_clear, (XtPointer) 0);

  x_info.infoShell.infoPane.commandBox.saveCommand =
    XtVaCreateManagedWidget ("saveCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Save",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.saveCommand,
		 XtNcallback, callback_info_save, (XtPointer) 0);

  x_info.infoShell.infoPane.commandBox.shuffleCommand =
    XtVaCreateManagedWidget ("shuffleCommand", commandWidgetClass,
			     x_info.infoShell.infoPane.commandBox.w,
			     XtNlabel, "Shuffle",
			     NULL);

  XtAddCallback (x_info.infoShell.infoPane.commandBox.shuffleCommand,
		 XtNcallback, callback_info_shuffle, (XtPointer) 0);

  x_info.infoShell.infoAlerts.playAlert =
    XtVaCreatePopupShell ("playAlert", xfwfAlertWidgetClass,
			  x_info.infoShell.w,
			  XtVaTypedArg, XtNicon, XtRString, "ERROR", 6,
			  XtNmessage, "A file is not selected.\n\nPlease select a file before\nclicking the Play button.",
			  NULL);

  XtAddCallback (x_info.infoShell.infoAlerts.playAlert, XtNcallback, close_popup,
		 (XtPointer) 0);

  XtOverrideTranslations (x_info.infoShell.infoAlerts.playAlert,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: alertClose()"));

  x_info.infoShell.infoAlerts.removeAlert =
    XtVaCreatePopupShell ("playAlert", xfwfAlertWidgetClass,
			  x_info.infoShell.w,
			  XtVaTypedArg, XtNicon, XtRString, "ERROR", 6,
			  XtNmessage, "A file is not selected.\n\nPlease select a file before\nclicking the Remove button.",
			  NULL);

  XtAddCallback (x_info.infoShell.infoAlerts.removeAlert, XtNcallback, close_popup,
		 (XtPointer) 0);

  XtOverrideTranslations (x_info.infoShell.infoAlerts.removeAlert,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: alertClose()"));

}

#endif
