
/* Copyright (C) 1995 by Andrew Robinson */

/* This file is part of the GMOD package */

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include "defines.h"
#include "structs.h"
#include "globals.h"
#include "protos.h"

void
patch_load (FILE * mod_fd, struct patch_info *patch, int sample_num)
{
  int bytes_read;
  int len = patch->len;
  unsigned short loop_flags = patch->mode;
  int loop_start;
  int loop_end;
  int mem_avail;

  /* fix loop_end if necessary */

  if (patch->loop_end > len)
    patch->loop_end = len;

  loop_start = patch->loop_start;
  loop_end = patch->loop_end;

  if ((bytes_read = fread (patch->data, 1, len, mod_fd)) != len)
    {
      if (((loop_flags & WAVE_16_BITS) && (bytes_read > 1)) ||
	  (!(loop_flags & WAVE_16_BITS) && (bytes_read > 0)))
	{
	  /* Warning: Short sample */

	  if ((loop_flags & WAVE_16_BITS) && ((bytes_read % 2) != 0))
	    bytes_read--;

	  while (bytes_read < len)
	    {
	      if (loop_flags & WAVE_16_BITS)
		{
		  patch->data[bytes_read] = patch->data[bytes_read - 2];
		  bytes_read++;
		  patch->data[bytes_read] = patch->data[bytes_read - 2];
		}
	      else
		patch->data[bytes_read] = patch->data[bytes_read - 1];
	      bytes_read++;
	    }
	}
      else
	{
	  /* Warning:  Could not load sample */
	  sample_ok[sample_num] = 0;
	  return;
	}
    }

  /* extend looped samples, since length might equal loop end */

  if (loop_flags & WAVE_LOOPING)
    {
      if (loop_flags & WAVE_16_BITS)
	{
	  if (len >= 2)
	    {
	      patch->data[len] = patch->data[len - 2];
	      patch->data[len + 1] = patch->data[len - 1];
	      len += 2;
	      patch->len += 2;
	    }
	}
      else if (len >= 1)
	{
	  patch->data[len] = patch->data[len - 1];
	  len++;
	  (patch->len)++;
	}
    }

  /* try to remove loop clicking */

  if ((loop_flags & WAVE_LOOPING) && (loop_end >= 2) &&
      !(loop_flags & WAVE_16_BITS))
    {
      patch->data[loop_end] = patch->data[loop_start];

      if (loop_flags & WAVE_UNSIGNED)
	patch->data[loop_end - 1] =
	  ((unsigned char) (patch->data[loop_end - 2]) +
	   (unsigned char) (patch->data[loop_end])) / 2;
      else
	patch->data[loop_end - 1] =
	  ((signed char) (patch->data[loop_end - 2]) +
	   (signed char) (patch->data[loop_end])) / 2;
    }

  mem_avail = gus_mem_free (gus_dev);	/* XXX */

  if (mem_avail < len)
    {
      /* *** Skipping patch - %d needed, %d available ***\n", len, mem_avail */
      sample_ok[sample_num] = 0;
      strcpy (samples[sample_num].name, "(Out of memory)");
    }
  else
    {
      SEQ_WRPATCH (patch, sizeof (*patch) + len);

      sample_ok[sample_num] = 1;
    }
}
