/* Copyright (C) 1995 by Andrew Robinson */
#ifdef USE_X
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>

#include "xdefines.h"
#include "xstructs.h"
#include "xglobals.h"
#include "xprotos.h"

#include "defines.h"
#include "structs.h"
#include "globals.h"

void
callback_top_info (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopup (x_info.infoShell.w, XtGrabNone);
  XtVaSetValues (x_info.topShell.topBox.infoCommand, XtNsensitive, False, NULL);
}

void
callback_top_opt (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopup (x_info.optShell.w, XtGrabNone);
  XtVaSetValues (x_info.topShell.topBox.optCommand, XtNsensitive, False, NULL);
}

void
callback_top_track (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopup (x_info.trackShell.w, XtGrabNone);
  XtVaSetValues (x_info.topShell.topBox.trackCommand, XtNsensitive, False, NULL);
}

void
callback_top_next (Widget w, XtPointer client_data, XtPointer call_data)
{
  stop_flag = STOP_NEXT;
  dump_enabled = 0;
  callback_arg = INPUTS_BUTTON;

  if (current_mod >= x_info.nrFileStrings)
    {
      if (x_info.nrFileStrings > 0)
	current_mod = 0;
      else
	current_mod = -1;
    }
  else
    {
      if ((current_mod < 0) || (remove_mod (current_mod) != True))
	current_mod++;
    }

  pick_random ();
}

void
callback_top_prev (Widget w, XtPointer client_data, XtPointer call_data)
{
  stop_flag = STOP_PREV;
  dump_enabled = 0;
  callback_arg = INPUTS_BUTTON;

  if (current_mod == -1)
    current_mod = x_info.nrFileStrings - 1;
  else
    {
      if (current_mod < x_info.nrFileStrings)
	remove_mod (current_mod);

      current_mod--;
    }

  pick_random ();
}

void
callback_top_forward (Widget w, XtPointer client_data, XtPointer call_data)
{
  position_change++;
  stop_flag = STOP_FORWBACK;
  dump_enabled = 0;
  callback_arg = INPUTS_BUTTON;
}

void
callback_top_back (Widget w, XtPointer client_data, XtPointer call_data)
{
  position_change--;
  stop_flag = STOP_FORWBACK;
  dump_enabled = 0;
  callback_arg = INPUTS_BUTTON;
}

void
callback_top_stop (Widget w, XtPointer client_data, XtPointer call_data)
{
  stop_flag = STOP_GOTO;
  dump_enabled = 0;
  callback_arg = INPUTS_BUTTON;
  current_mod = -1;
}

void
callback_top_quit (Widget w, XtPointer client_data, XtPointer call_data)
{
  stop_flag = STOP_EXIT;
  dump_enabled = 0;
  callback_arg = INPUTS_BUTTON;
}

void
TopClose (Widget w, XEvent *event, String *parms, Cardinal *nparms)
{
  callback_top_quit (w, (XtPointer)0, (XtPointer)0);
}

void
create_top (void)
{
  static XtActionsRec topActionsTable[] =
  {
    {"topClose", (XtActionProc)TopClose}
  };

    XtAppAddActions (x_info.app_context, topActionsTable, XtNumber(topActionsTable));

  XtOverrideTranslations (x_info.topShell.w,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: topClose()"));

  x_info.topShell.topBox.w =
  XtVaCreateManagedWidget ("topBox", boxWidgetClass, x_info.topShell.w, NULL);

  x_info.topShell.topBox.infoCommand =
    XtVaCreateManagedWidget ("infoCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "I", NULL);

  XtAddCallback (x_info.topShell.topBox.infoCommand, XtNcallback,
		 callback_top_info, (XtPointer) 0);

  x_info.topShell.topBox.optCommand =
    XtVaCreateManagedWidget ("optCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "O", NULL);

  XtAddCallback (x_info.topShell.topBox.optCommand, XtNcallback,
		 callback_top_opt, (XtPointer) 0);

  x_info.topShell.topBox.trackCommand =
    XtVaCreateManagedWidget ("trackCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "T", NULL);

  XtAddCallback (x_info.topShell.topBox.trackCommand, XtNcallback,
		 callback_top_track, (XtPointer) 0);

  x_info.topShell.topBox.previousCommand =
    XtVaCreateManagedWidget ("previousCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "Previous",
			     XtNbitmap, x_info.bitmaps.previousBitmap, NULL);

  XtAddCallback (x_info.topShell.topBox.previousCommand, XtNcallback,
		 callback_top_prev, (XtPointer) 0);

  x_info.topShell.topBox.nextCommand =
    XtVaCreateManagedWidget ("nextCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "Next",
			     XtNbitmap, x_info.bitmaps.nextBitmap, NULL);

  XtAddCallback (x_info.topShell.topBox.nextCommand, XtNcallback,
		 callback_top_next, (XtPointer) 0);

  x_info.topShell.topBox.backCommand =
    XtVaCreateManagedWidget ("backCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "REW",
			     XtNbitmap, x_info.bitmaps.backBitmap, NULL);

  XtAddCallback (x_info.topShell.topBox.backCommand, XtNcallback,
		 callback_top_back, (XtPointer) 0);

  x_info.topShell.topBox.forwardCommand =
    XtVaCreateManagedWidget ("forwardCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "FF",
			     XtNbitmap, x_info.bitmaps.forwardBitmap, NULL);

  XtAddCallback (x_info.topShell.topBox.forwardCommand, XtNcallback,
		 callback_top_forward, (XtPointer) 0);

  x_info.topShell.topBox.stopCommand =
    XtVaCreateManagedWidget ("stopCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "Stop",
			     XtNbitmap, x_info.bitmaps.stopBitmap, NULL);

  XtAddCallback (x_info.topShell.topBox.stopCommand, XtNcallback,
		 callback_top_stop, (XtPointer) 0);

  x_info.topShell.topBox.quitCommand =
    XtVaCreateManagedWidget ("quitCommand", commandWidgetClass,
			     x_info.topShell.topBox.w,
			     XtNlabel, "Q", NULL);

  XtAddCallback (x_info.topShell.topBox.quitCommand, XtNcallback,
		 callback_top_quit, (XtPointer) 0);

}

#endif
