/* Copyright (C) 1995 by Andrew Robinson */
#ifdef USE_X
#include <stdlib.h>
#include <limits.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/List.h>

#include <Xfwf/FileComp.h>
#include <Xfwf/Toggle.h>

#include "back.xbm"
#include "forward.xbm"
#include "next.xbm"
#include "previous.xbm"
#include "stop.xbm"

#include "xdefines.h"
#include "xstructs.h"
#include "xglobals.h"
#include "xprotos.h"

#include "defines.h"
#include "structs.h"
#include "globals.h"

void
check_buttons (void)
{
  static Boolean last = True;
  Boolean sensitive;

  if (x_info.nrFileStrings == 0)
    sensitive = False;
  else
    sensitive = True;

  if (sensitive != last)
    {
      last = sensitive;
      XtVaSetValues (x_info.topShell.topBox.nextCommand, XtNsensitive,
		     sensitive, NULL);
      XtVaSetValues (x_info.topShell.topBox.previousCommand, XtNsensitive,
		     sensitive, NULL);
    }
}

void
pick_random (void)
{
  Boolean toggle_stat;

  if (x_info.nrFileStrings > 0)
    {
      XtVaGetValues (x_info.optShell.optBox.queueGroup.randomToggle,
		     XtNon, &toggle_stat, NULL);

      if (toggle_stat == True)
	current_mod = rand () % x_info.nrFileStrings;
    }
}

Boolean
remove_mod (int number)
{
  XawListReturnStruct *list_ret;
  int highlight;
  Boolean toggle_stat;

  XtVaGetValues (x_info.optShell.optBox.queueGroup.removeToggle,
		 XtNon, &toggle_stat, NULL);

  if (toggle_stat == True)
    {
      list_ret = XawListShowCurrent (x_info.infoShell.infoPane.fileView.fileList);

      free (x_info.fileStrings[number]);
      x_info.nrFileStrings--;

      if (x_info.nrFileStrings != number)
	memmove (x_info.fileStrings + number, x_info.fileStrings + number + 1,
		 (x_info.nrFileStrings - number) * sizeof (String));

      x_info.fileStrings =
	realloc (x_info.fileStrings, sizeof (String) * x_info.nrFileStrings);

      if (x_info.nrFileStrings == 0)
	{
	  XawListChange (x_info.infoShell.infoPane.fileView.fileList,
			 empty_list, 1, 0, True);
	  XtVaSetValues (x_info.infoShell.infoPane.fileView.fileList,
			 XtNsensitive, False, NULL);
	  current_mod = -1;
	}
      else
	{
	  XawListChange (x_info.infoShell.infoPane.fileView.fileList,
			 x_info.fileStrings, x_info.nrFileStrings, 0, True);

	  if (list_ret->list_index != XAW_LIST_NONE)
	    {
	      highlight = list_ret->list_index;

	      if (highlight > number)
		highlight--;

	      if (highlight >= x_info.nrFileStrings)
		highlight--;

	      XawListHighlight (x_info.infoShell.infoPane.fileView.fileList,
				highlight);
	    }
	}

      check_buttons ();
    }

  return (toggle_stat);
}

void
callback_proc (XtPointer client_data, int *source, XtInputId * inid)
{
  callback_arg = (int) client_data;

  return;
}

void
create_bitmaps (void)
{
  x_info.bitmaps.previousBitmap =
  XCreateBitmapFromData (XtDisplay (x_info.topShell.w),
			 RootWindowOfScreen (XtScreen (x_info.topShell.w)),
			 previous_bits, previous_width, previous_height);

  x_info.bitmaps.nextBitmap =
    XCreateBitmapFromData (XtDisplay (x_info.topShell.w),
			   RootWindowOfScreen (XtScreen (x_info.topShell.w)),
			   next_bits, next_width, next_height);

  x_info.bitmaps.backBitmap =
    XCreateBitmapFromData (XtDisplay (x_info.topShell.w),
			   RootWindowOfScreen (XtScreen (x_info.topShell.w)),
			   back_bits, back_width, back_height);

  x_info.bitmaps.forwardBitmap =
    XCreateBitmapFromData (XtDisplay (x_info.topShell.w),
			   RootWindowOfScreen (XtScreen (x_info.topShell.w)),
			   forward_bits, forward_width, forward_height);

  x_info.bitmaps.stopBitmap =
    XCreateBitmapFromData (XtDisplay (x_info.topShell.w),
			   RootWindowOfScreen (XtScreen (x_info.topShell.w)),
			   stop_bits, stop_width, stop_height);
}

void
set_inputs (int which, int what)
{
  static XtInputId xt_write;

  if (what == INPUTS_ADD)
    {
      if (which == INPUTS_READ)
	XtAppAddInput (x_info.app_context, seqfd, (XtPointer) XtInputReadMask, (XtInputCallbackProc) callback_proc, (XtPointer) INPUTS_READ);
      else
	xt_write = XtAppAddInput (x_info.app_context, seqfd, (XtPointer) XtInputWriteMask, (XtInputCallbackProc) callback_proc, (XtPointer) INPUTS_WRITE);
    }
  else
    {
      XtRemoveInput (xt_write);
    }
}

void
flush_xbuffer (void)
{
  while (XtAppPending (x_info.app_context) & (XtIMXEvent | XtIMTimer | XtIMSignal))
    XtAppProcessEvent (x_info.app_context, XtIMXEvent | XtIMTimer | XtIMSignal);
}

void
create_widgets ()
{
  Boolean toggle_stat;
  static Atom wmDeleteAtom;

  create_bitmaps ();
  create_top ();
  create_info ();
  create_request ();
  create_opt ();
  create_track ();
  XtRealizeWidget (x_info.topShell.w);
  XtRealizeWidget (x_info.infoShell.w);
  XtRealizeWidget (x_info.infoShell.infoAlerts.playAlert);
  XtRealizeWidget (x_info.infoShell.infoAlerts.removeAlert);
  XtRealizeWidget (x_info.selShell.w);
  XtRealizeWidget (x_info.selShell.okAlert);
  XtRealizeWidget (x_info.optShell.w);
  XtRealizeWidget (x_info.trackShell.w);

  wmDeleteAtom = XInternAtom (XtDisplay(x_info.topShell.w), "WM_DELETE_WINDOW", False);
  XSetWMProtocols (XtDisplay(x_info.topShell.w), XtWindow(x_info.topShell.w), &wmDeleteAtom, 1);
  XSetWMProtocols (XtDisplay(x_info.infoShell.w), XtWindow(x_info.infoShell.w), &wmDeleteAtom, 1);
  XSetWMProtocols (XtDisplay(x_info.infoShell.infoAlerts.playAlert), XtWindow(x_info.infoShell.infoAlerts.playAlert), &wmDeleteAtom, 1);
  XSetWMProtocols (XtDisplay(x_info.infoShell.infoAlerts.removeAlert), XtWindow(x_info.infoShell.infoAlerts.removeAlert), &wmDeleteAtom, 1);
  XSetWMProtocols (XtDisplay(x_info.selShell.w), XtWindow(x_info.selShell.w), &wmDeleteAtom, 1);
  XSetWMProtocols (XtDisplay(x_info.selShell.okAlert), XtWindow(x_info.selShell.okAlert), &wmDeleteAtom, 1);
  XSetWMProtocols (XtDisplay(x_info.optShell.w), XtWindow(x_info.optShell.w), &wmDeleteAtom, 1);
  XSetWMProtocols (XtDisplay(x_info.trackShell.w), XtWindow(x_info.trackShell.w), &wmDeleteAtom, 1);

  flush_xbuffer ();

  XtVaGetValues (x_info.optShell.optBox.queueGroup.absoluteToggle, XtNon,
		 &toggle_stat, NULL);

  if (toggle_stat == True)
    XtVaSetValues (x_info.selShell.fileComp, XtNfollowLinks, XfwfFCAlways,
		   NULL);
}

#endif
