#ifndef MODULE_H
#define MODULE_H

struct moduleinfo
{
	unsigned char *rawtitle;
	unsigned char *rawsample;
	unsigned char *rawtable;
	unsigned char *rawpattern;
	unsigned char *rawnoise;

	int samplelength[32];
	int samplereppnt[32];
	int samplereplen[32];
	int samplefntune[32];
	int samplevolume[32];
	unsigned char *samplenoise[32];

	int channelvolumeslide[32];
	int channelperiodslide[32];
	int channelperiodmax[32];
	int channelperiodmin[32];
	int channelposition[32];
	int channelddainc[32];
	int channelperiod[32];
	int channelsample[32];
	int channellength[32];
	int channelreplen[32];
	int channelvolume[32];
	int channelfntune[32];
	unsigned char *channelreppnt[32];
	unsigned char *channelnoise[32];

	int numpositions;
	int numchannels;
	int numpatterns;
	int numsamples;

	int periodmodifier[16];
	int ticksperline;
	int beatsperminute;

	int songposition;
	int tickposition;
	int lineposition;
};

#include "sound.h"
#include "loader.h"
#include "player.h"
#include "tracker.h"
#include "ticker.h"
#include "global.h"
#endif
