/*
 * ---------------------------------------------------------------------------
 * sfxserver/device.c
 *
 * Copyright by Terry Evans 1994
 * tevans@cs.utah.edu, tevans@slc.unisys.com
 * ---------------------------------------------------------------------------
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ---------------------------------------------------------------------------
 */

#include <fcntl.h>
#include <stdio.h>
#include <linux/soundcard.h>
#include <unistd.h>


#include "global.h"
#include "types.h"
#include "error.h"
#include "io.h"
#include "device.h"


int D_Init(char *device, int *frag_spec, int *frequency, int *stereo, int *frag_size)
{
  int s_fd;

  IO_WriteStdout("D_Init: Initializing sound device\n");

  /* See if we have access to write to the dsp device */
  if(access(device, W_OK))
    E_ErrnoFatalError("D_Init", "unable to get write access to sound device %s", device);

  /* We open it and then close it to check if we have opening permission */
  if((s_fd = open(device, O_WRONLY)) == -1)
    E_ErrnoFatalError("D_Init", "unable to open sound device %s", device);

  if(ioctl(s_fd, SNDCTL_DSP_SETFRAGMENT, frag_spec))
    E_ErrnoFatalError("D_Init", "unable to ioctl SNDCTL_DSP_SETFRAGMENT on %s", device);
    
  if(ioctl(s_fd, SNDCTL_DSP_SPEED, frequency))
    E_ErrnoFatalError("D_Init", "unable to ioctl SNDCTL_DSP_SPEED on %s", device);

  if(ioctl(s_fd, SNDCTL_DSP_STEREO, stereo))
    E_ErrnoFatalError("D_Init", "unable to ioctl SNDCTL_DSP_STEREO on %s", device);

  if(ioctl(s_fd, SNDCTL_DSP_GETBLKSIZE, frag_size))
    E_ErrnoFatalError("D_Init", "unable to ioctl SNDCTL_DSP_GETBLKSIZE on %s", device);

  /* Return the file descriptor */
  return(s_fd);
}


void D_DeInit(int s_fd)
{
  IO_WriteStdout("D_DeInit: DeInitializing sound driver\n");
  close(s_fd);
}
