/*
 * Global Header File
 *
 *   This file contains #includes, #defines, typedefs, etc. that are to be
 * included in EVERY source file compiled.  Do NOT put anything here that is
 * not to be included in EVERY source file, ESPECIALLY the libraries.
 *
 */

/******************************* NUMERIC SECTION ********************************/

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

typedef unsigned char
	boolean;
typedef signed char
	int8;
typedef signed short
	int16;
typedef signed long
	int32;
typedef unsigned char
	int8u;
typedef unsigned short
	int16u;
typedef unsigned long
	int32u;

#define sgn(a)				((a>0) ? 1 : ((a<0) ? -1 : 0))
#ifdef abs
#undef abs
#endif
#define abs(a)				((a>0) ? (a) : -(a))
#define MIN(a,b)			((a<b) ? (a) : (b))
#define MAX(a,b)			((a>b) ? (a) : (b))
#define	NEW(a)				((a *)malloc(sizeof(a)))
#define	NEW_ARRAY(a, b)		((a *)malloc(sizeof(a) * (b)))
#define SWAP(a, b, type)	{ \
							type	ThIs_Is_A_StRaNgE_NaMe = a; \
							a = b; \
							b = ThIs_Is_A_StRaNgE_NaMe; \
							}

#define GET_INT8(a)			(fgetc(a))
#define GET_INT16L(a)		(GET_INT8(a) + (((int16u)GET_INT8(a)) << 8))
#define GET_INT32L(a)		(GET_INT16L(a) + (((int32u)GET_INT16L(a)) << 16))

#define PUT_INT8(a, b)		fputc((int8u) (a), b)
#define PUT_INT16L(a, b)	PUT_INT8(a, b); \
							PUT_INT8((a) >> 8, b)
#define PUT_INT32L(a, b)	PUT_INT16L(a, b); \
							PUT_INT16L((a) >> 16, b)


#define GET_INT16H(a)		(((GET_INT8(a)) << 8) + GET_INT8(a))
#define GET_INT32H(a)		(((GET_INT16H(a)) << 16) + GET_INT16H(a))

#define PUT_INT16H(a, b)	PUT_INT8((a) >> 8, b) ; \
							PUT_INT8(a, b)
#define PUT_INT32H(a, b)	PUT_INT16H((a) >> 16, b); \
							PUT_INT16H(a, b)

#define THRASH_BYTES(a, b)	{ \
							int32	UsL; \
							for (UsL=0 ; UsL<b ; UsL++) \
							GET_INT8(a); \
							}

/******************************* GRAPHICS SECTION *******************************/

