/********************* SoundSmith (and other) effects *******************/
#define FX_ARPEGIATTO		0x0
#define FX_PITCHBEND_UP		0x1
#define FX_PITCHBEND_DOWN	0x2
#define FX_SET_VOLUME		0x3
#define FX_VIBRATO			0x4
#define FX_SUB_VOLUME		0x5
#define FX_ADD_VOLUME		0x6
#define FX_OLD_ARPEGIATTO	0x8
#define FX_VOL_SLIDE		0xa
#define FX_RESERVED			0xb
#define FX_PORTAMENTO		0xc
#define FX_JUMP				0xd
#define FX_EXTENDED			0xe
#define FX_SET_TEMPO		0xf

#define MIXER_MAX_VOL		100
#define MIXER_MIN_VOL		0

#define	NEXT_SONG			1
#define PREV_SONG			2

#define DEBUG(a)		if (debugging_output && foreground) {a}
#define TRACK(a)		if (tracker_output && foreground) {a}
#define SYNC(a)			if (sync_output && foreground) {a}
#define VERBOSE(a)		if (verbose_flag) {a}

#if !defined (SS_INST_DIR)
	#define SS_INST_DIR		"/library/sound/ss/instruments"
	#endif
#if !defined (SS_MUSIC_DIR)
	#define SS_MUSIC_DIR	"/library/sound/ss/music"
	#endif

#define CHAR4(a,b,c,d)	((d << 24) + (c << 16) + (b << 8) + a)	/* stupid macro to convert 4 chars to a 32 bit low byte first word */

/* It's 19 values short!  Must tell Ian at some point....
** The thought arises, 'Does it matter?'
** Note:  the last 19 values are kind of hacked, they probably aren't
** correct.
** Additional note:  the last 19 values aren't correct because the
** table is supposed to be short.  SoundSmith is also short, contrary
** to the documentation.
** Yet another note:  don't need to tell Ian.
*/
/* The hard coded frequency table that is no longer used because we got the drivers to work properly */

int32u FreqTable[128] =
	{
	      0,    1122,    1173,    1224,    1326,    1377,    1479,    1530,
	   1632,    1734,    1836,    1938,    2091,    2193,    2346,    2499,
	   2601,    2754,    2958,    3111,    3315,    3519,    3723,    3927,
	   4182,    4386,    4692,    4947,    5253,    5559,    5865,    6222,
	   6579,    6987,    7395,    7854,    8313,    8823,    9333,    9894,
	  10506,   11067,   11730,   12444,   13158,   13974,   14790,   15657,
	  16626,   17646,   18717,   19788,   20961,   22236,   23562,   24939,
	  26418,   27999,   29682,   31467,   33303,   35292,   37383,   39627,
	  41973,   44472,   47124,   49929,   52887,   55998,   59364,   62883,
	  66606,   70584,   74766,   79203,   83946,   88944,   94197,   99807,
	 105774,  112047,  118728,  125766,  133263,  141168,  149583,  158457,
	 167892,  177837,  188445,  205020,  211497,  224094,  237405,  251532,
	 266475,  282336,  299115,  316914,  330633,  355725,  376890,  399279,
	 422994,  448188,  474810,  503064,
									     532994,  564685,  598261,  633835,
	 671523,  711453,  753750,  798568,  846048,  896366,  949652, 1006120,
	1065989, 1129371, 1196522, 1267671, 1343047, 1422906, 1507513, 1597150
	};


typedef struct
	{
	char	instName[22];
	int16u	reserved0;
	int16u	volume;
	int16u	reserved1;
	int16u	reserved2;
	int16	stereo;
	} SSmith_inst;

typedef struct
	{
	int16u		length;			/* length of all patterns in bytes				*/
	int16u		tempo;			/* note is played every tempo/50th of a second	*/
	SSmith_inst	instBlock[15];	/* information on instruments					*/
	int16u		positions;		/* number of positions in sequence				*/
	int8u		sequence[128];	/* list of patterns to play (the actual song)	*/
	} SSmith_hdr;

typedef int32u
	SSmith_pat[64][14];			/* a pattern is 64 rows x 14 channels			*/

typedef struct
	{
	SSmith_hdr	header;
	SSmith_pat	*patterns;
	} SSmith_song;

typedef int8u chnl[14];

typedef struct
	{
	int32	x;
	int32	y;
	boolean	new;
	boolean old;
	} arpegiatto;

typedef struct
	{
	boolean	down;
	boolean	up;
	int8u	value;
	} volume_ramp;


void	 init_stuff(void);
void	 shutdown(int);
boolean	 load_ssm(Compress_File *file);
void	 load_patterns(FILE *);
int32u	 play_ssm(void);
void	 do_effect(int32, int16u);
void	 alloc_channels(void);
void	 terminal_set (int32);
void	 modify_mixer_volume(int32);
void	 print_usage(char *);
void	 free_song(void);
char	*SS_FindMusicFile(char *);
void	 player_init(void);
void	 timer_do_effect(int32, int16u);
void	 timer_play_ssm(int);
void	 new_signal(void (*handler)(int), int32u);

