typedef struct
	{
	int32u	id;
	int32u	size;
	} generic_chunk;

typedef struct
	{
	int8u	breakpoint;
	int16u	increment;
	} INST_envelope;

typedef struct
	{
	int8u	topkey;
	int8u	waveaddress;
	int8u	wavesize;
	int8u	docmode;
	int16u	relpitch;
	} INST_wavelist;

typedef struct
	{
	int8u			id[5];
	int32u			size;
	int8u			name[256];
	int16u			samplenum;	/*the index into the WAVE sample table*/
	INST_envelope	stage[8];
	int8u			releasesegment;
	int8u			priorityincrement;
	int8u			pitchbendrange;
	int8u			vibratodepth;
	int8u			vibratospeed;
	int8u			updaterate;
	int8u			Awavecount;
	int8u			Bwavecount;
	INST_wavelist	*Awavelist;
	INST_wavelist	*Bwavelist;
	} INST_chunk;

typedef struct
	{
	int8u	id[5];
	int32	size;
	int8u	type[5];
	} FORM_chunk;

typedef struct
	{
	int16u	location;
	int16u	size;
	int32u	origfreq;
	int32u	samprate;
	} WAVE_sample;

typedef struct
	{
	int8u		id[5];
	int32u		chunksize;
	int8u		name[256];
	int16u		wavesize;
	int16u		numsamples;
	WAVE_sample	*sampletable;
	int8u		*data;
	} WAVE_chunk;

boolean	 read_FORMchunk(FILE *, FORM_chunk *);
boolean	 read_INSTchunk(FILE *, INST_chunk *);
boolean	 read_WAVEchunk(FILE *, WAVE_chunk *);
void	 read_NAMEchunk(FILE *);
void	 read_AUTHchunk(FILE *);
void	 read_ANNOchunk(FILE *);
void	 read_COPYchunk(FILE *);
void	 read_genericchunk(FILE *);
