# $Id: menu.tcl,v 1.7 1994/07/10 04:31:59 shendrix Exp $
#
# Tickle Music main menu
#

# CREATE THE MAIN APPLICATION MENU(S)
#
# frame for menu bar and another frame for widgets
frame .mb -bd 1 -relief raised

set menulist "file songs library options misc help"

if $tmdebug {
  lappend menulist "debug"
}

#create the menus

menubutton .mb.file  -bd 1 -text File -underline -1 -menu .mb.file.menu
menu .mb.file.menu  -bd 1
.mb.file.menu add command -label About -command about
.mb.file.menu add separator
.mb.file.menu add command -label "Save configuration" -command save_config
.mb.file.menu add command -label "Delete selected song(s)" -command delete_song
.mb.file.menu add separator
.mb.file.menu add command -label Exit -command exit

menubutton .mb.songs  -bd 1 -text Songs -underline -1 -menu .mb.songs.menu
menu .mb.songs.menu -bd 1
.mb.songs.menu add command -label "Add song to queue" -command {qsong}
.mb.songs.menu add command -label "Play songs in queue" -command {playsong}
.mb.songs.menu add separator
.mb.songs.menu add command -label "Kill current song" -command songkiller
.mb.songs.menu add command -label "Stop the queue" -command haltq
.mb.songs.menu add command -label "Flush the queue" -command flushq

menubutton .mb.library  -bd 1 -text Library -underline -1 -menu .mb.library.menu
menu .mb.library.menu -bd 1
.mb.library.menu add command -label "MOD Library" -command {godir $modlib;readsongs }
.mb.library.menu add command -label "MIDI Library" -command {godir $midilib;readsongs }

menubutton .mb.options  -bd 1 -text Options -underline -1 -menu .mb.options.menu
menu .mb.options.menu -bd 1

menubutton .mb.misc  -bd 1 -text Misc -underline -1 -menu .mb.misc.menu
menu .mb.misc.menu -bd 1
.mb.misc.menu add command -label "Show the song queue" -command showq

if $tmdebug {
menubutton .mb.debug  -bd 1 -text Debug -underline -1 -menu .mb.debug.menu
menu .mb.debug.menu -bd 1
.mb.debug.menu add command -label Restart -command { restart }
.mb.debug.menu add checkbutton -label TTYdebug -variable ttydebug
.mb.debug.menu add separator
.mb.debug.menu add command -label Dialogs -command {source $codelib/dialogs.tcl}
.mb.debug.menu add command -label Menu -command {source $codelib/menu.tcl}
.mb.debug.menu add command -label Procs -command {source $codelib/procs.tcl}
}

menubutton .mb.help  -bd 1 -text Help -underline -1 -menu .mb.help.menu
menu .mb.help.menu  -bd 1
.mb.help.menu add checkbutton -label "Dialog Box Help" -variable handhold	
.mb.help.menu add separator
.mb.help.menu add command -label "Online Help" -command onlinehelp

# Now give everything to the geometry manager
foreach i $menulist {
  if {$i == "help"} { 
    pack .mb.$i -side right -fill x
  } else {
    pack .mb.$i -side left -fill x
  }
}
pack .mb -side top -fill x

tk_menuBar .mb .mb.file .mb.songs .mb.library .mb.options .mb.misc\
	.mb.debug .mb.help
#
# END OF MAIN APPLICATION MENU CREATION
#

