#!/usr/local/bin/wishx -f
#
# $Id: tmusic.tcl,v 1.17 1994/07/10 04:38:10 shendrix Exp $
#
# Tickle Music main program
#
#

#
# set up program variables
#

source /usr/local/lib/tmusic/config.tcl

####
#### process the user's configuration file if any
####
#### source personal setup 
#### if {[file exists ~/.tmusicrc]} { source ~/.tmusicrc}
catch {source ~/.tmusicrc}

# source the rest of the code
foreach i {dialogs menu procs buttonbar help} {
  source $codelib/$i.tcl
}


# use a sourced routine to do packing
pack_buttonbar


# jump to default library
cd $library
# send a few setup commands to the window manager
wm title . "Tickle Music"
wm minsize . 1 1
wm maxsize . 1024 768

# MAIN APPLICATION BUTTONS, LISTBOX/SCROLLBAR, ETC
#
# create library/info label
#
frame .bottom -height 0.5c 
pack .bottom -side bottom -fill x
label .bottom.info -bd 1 -relief raised -text "$songplaying"\
	-width 30 
#button .bottom.killsong -bd 1 -text Killsong -command songkiller 
#button .bottom.playsong -bd 1 -text PlayQ -command playsong 

#
# now create the text/list widget and scrollbar
#

frame .m 
#-width 15c -height 10c  

pack .m -side top -fill both -expand yes

set wvar "library"
button .m.dir -bd 1 -relief raised -textvariable $wvar -command readsongs 
pack .m.dir -side top -fill x

scrollbar .m.songscroll -bd 1 -relief raised -command ".m.songlist yview" \
	-width 0.5c 
listbox .m.songlist -bd 1 -yscroll ".m.songscroll set" -relief raised \
 	-geometry 30x20 -setgrid yes

pack .m.songscroll -side right -fill y 
pack .m.songlist -side top -fill both -expand yes
pack .bottom.info \
     -side left -anchor w -expand yes -fill both

#
#
# Now do whatever it is you need to do to get started
#

# first we read the songs in the default library
readsongs 

# set bindings

bind .m.songlist <Control-q> {destroy .}
bind .m.songlist <Control-c> {destroy .}
bind .m.songlist <Double-Button-1> {qsong}

# let's kill whatever's playing
songkiller





# THE EDGE OF FOREVER
# at this point tk's event loop is in control of things

