/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Form definition file generated with fdesign. */

#include "forms.h"
#include "xrplay.h"

FD_xrplay *create_form_xrplay(void)
{
  FL_OBJECT *obj;
  FD_xrplay *fdui = (FD_xrplay *) fl_calloc(1, sizeof(FD_xrplay));

  fdui->xrplay = fl_bgn_form(FL_NO_BOX, 280, 190);
  obj = fl_add_box(FL_FLAT_BOX,0,0,280,190,"");
  obj = fl_add_box(FL_UP_BOX,0,155,280,35,"");
  fdui->set_volume_0 = obj = fl_add_button(FL_NORMAL_BUTTON,5,120,50,30,"0%");
    fl_set_button_shortcut(obj,"0",1);
    fl_set_object_callback(obj,set_volume_cb,0);
  fdui->set_volume_100 = obj = fl_add_button(FL_NORMAL_BUTTON,225,120,50,30,"100%");
    fl_set_button_shortcut(obj,"1",1);
    fl_set_object_callback(obj,set_volume_cb,255);
  fdui->set_volume_50 = obj = fl_add_button(FL_NORMAL_BUTTON,115,120,50,30,"50%");
    fl_set_button_shortcut(obj,"5",1);
    fl_set_object_callback(obj,set_volume_cb,128);
  fdui->set_volume_25 = obj = fl_add_button(FL_NORMAL_BUTTON,60,120,50,30,"25%");
    fl_set_button_shortcut(obj,"2",1);
    fl_set_object_callback(obj,set_volume_cb,64);
  fdui->set_volume_75 = obj = fl_add_button(FL_NORMAL_BUTTON,170,120,50,30,"75%");
    fl_set_button_shortcut(obj,"7",1);
    fl_set_object_callback(obj,set_volume_cb,192);
  fdui->slider = obj = fl_add_slider(FL_HOR_SLIDER,5,85,270,30,"");
    fl_set_object_callback(obj,slider_cb,0);
  fdui->file_menu = obj = fl_add_menu(FL_PULLDOWN_MENU,5,160,40,25,"File");
    fl_set_object_shortcut(obj,"#F",1);
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_resize(obj, FL_RESIZE_ALL, NorthWestGravity, EastGravity);
    fl_set_object_callback(obj,file_menu_cb,0);
  obj = fl_add_text(FL_NORMAL_TEXT,215,170,55,15,"XRPlay");
    fl_set_object_lcol(obj,FL_BLUE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE+FL_EMBOSSED_STYLE);
  fdui->message = obj = fl_add_box(FL_DOWN_BOX,5,6,270,25,"");
  fdui->version = obj = fl_add_text(FL_NORMAL_TEXT,211,161,61,5,"Version 3.0");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
  fdui->action_start = obj = fl_add_bitmapbutton(FL_RETURN_BUTTON,225,35,50,30,"");
    fl_set_object_callback(obj,action_start_cb,0);

  fdui->bitmap_buttons = fl_bgn_group();
  fdui->action_skip_back = obj = fl_add_bitmapbutton(FL_NORMAL_BUTTON,5,35,50,30,"");
    fl_set_button_shortcut(obj,"b",1);
    fl_set_object_callback(obj,action_skip_back_cb,0);
  fdui->action_pause_play = obj = fl_add_bitmapbutton(FL_PUSH_BUTTON,60,35,50,30,"");
    fl_set_button_shortcut(obj,"p",1);
    fl_set_object_callback(obj,action_pause_play_cb,0);
  fdui->action_stop = obj = fl_add_bitmapbutton(FL_NORMAL_BUTTON,115,35,50,30,"");
    fl_set_button_shortcut(obj,"s",1);
    fl_set_object_callback(obj,action_stop_cb,0);
  fdui->action_skip_forward = obj = fl_add_bitmapbutton(FL_NORMAL_BUTTON,170,35,50,30,"");
    fl_set_button_shortcut(obj,"f",1);
    fl_set_object_callback(obj,action_skip_forward_cb,0);
  fl_end_group();
  create_vu_meter();
  create_hidden_objects();
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

