/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FD_xrplay_h_
#define FD_xrplay_h_
/* Header file generated with fdesign. */

/**** Callback routines ****/

extern void set_volume_cb(FL_OBJECT *, long);
extern void slider_cb(FL_OBJECT *, long);
extern void file_menu_cb(FL_OBJECT *, long);
extern void options_menu_cb(FL_OBJECT *, long);
extern void action_start_cb(FL_OBJECT *, long);
extern void action_skip_back_cb(FL_OBJECT *, long);
extern void action_pause_play_cb(FL_OBJECT *, long);
extern void action_stop_cb(FL_OBJECT *, long);
extern void action_skip_forward_cb(FL_OBJECT *, long);
extern void increase_volume_cb(FL_OBJECT *, long);
extern void decrease_volume_cb(FL_OBJECT *, long);
extern void quit_cb(FL_OBJECT *, long);
extern void really_quit_cb(void);

/**** Forms and Objects ****/

typedef struct {
	FL_FORM *xrplay;
	FL_OBJECT *set_volume_0;
	FL_OBJECT *set_volume_100;
	FL_OBJECT *set_volume_50;
	FL_OBJECT *set_volume_25;
	FL_OBJECT *set_volume_75;
	FL_OBJECT *slider;
	FL_OBJECT *file_menu;
	FL_OBJECT *message;
	FL_OBJECT *version;
	FL_OBJECT *action_start;
	FL_OBJECT *bitmap_buttons;
	FL_OBJECT *action_skip_back;
	FL_OBJECT *action_pause_play;
	FL_OBJECT *action_stop;
	FL_OBJECT *action_skip_forward;
	void *vdata;
	long ldata;
} FD_xrplay;

extern FD_xrplay * create_form_xrplay(void);

#endif /* FD_xrplay_h_ */
