/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* color class interface definitions                                      */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: colors.h,v 1.4 1995/04/15 19:26:10 drewvel Exp $

#ifndef __COLORH_INC
#define __COLORH_INC

struct Color {
  int r, g, b;
  
  Color() { r=g=b=0; }
  Color(int R, int G, int B) : r(R), g(G), b(B) { }
  
  void Set(int R, int G, int B) { r=R; g=G; b=B; }

  Color& operator = (Color& o) 
    { 
      r=o.r; g=o.g; b=o.b;
      return *this; 
    }

  Color operator + (Color& o)
    {
      return Color(r+o.r, g+o.g, b+o.b);
    }

  Color operator + (int o)
    {
      return Color(r+o, g+o, b+o);
    }

  Color operator - (Color& o)
    {
      return Color(r-o.r, g-o.g, b-o.b);
    }

  Color operator - (int o)
    {
      return Color(r-o, g-o, b-o);
    }

  Color operator * (Color& o)
    {
      return Color(r*o.r, g*o.g, b*o.b);
    }

  Color operator * (int o)
    {
      return Color(r*o, g*o, b*o);
    }

  Color operator / (Color& o)
    {
      return Color((int) ((float) r/(float) o.r), 
		   (int) ((float) g/(float) o.g), 
		   (int) ((float) b/(float) o.b));
    }

  Color operator / (int o)
    {
      float d=(float) o;
      return Color((int) ((float) r / d), 
		   (int) ((float) g / d), 
		   (int) ((float) b / d));
    }
};

// protos
unsigned char RGBByteColor(Color& c);
int RGBLargeColor(Color& c);
void FadeArray(Color C1, Color C2, 
	       unsigned char colors[], int len);
void FadeArray(Color C1, Color C2, 
	       int colors[], int len);
void FadeColorRange(Color Colors[], int numcols, 
		    unsigned char colors[], int len);
void FadeColorRange(Color Colors[], int numcols, 
		    int colors[], int len);
#endif __COLORH_INC
