/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* default for command line parameters                                    */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: defaults.h,v 1.13 1995/04/15 19:40:28 drewvel Exp $             

#include "defvals.h"
#include "gconfig.h"

globalConfig gConfig = // default values for command-line options
{
  // string options
  {NOFILENAME, "-device"},

  // number options

  // default screen size
  {DEFSCREEN, "-screen"},

  // fft stuff (not really a user option)
  {FFTSIZESCALE, "-fftsizescale"},

  // sampling stuff
  {DEFSAMPRATE, "-rate"},
  {DEFSAMPSIZE, "-size"},
  {-1, "-atten"}, // will be set at runtime depending on sample res.
  {DEFVPOS, "-vpos"},
  
  // default plot type
  {DEFPLOTTYPE, "-plottype"},

  // default frequency ranges 
  {DEFLOWFREQ, "-lowfreq"},
  {DEFHIGHFREQ, "-highfreq"},
  {DEFRANGEINC, "-rangeinc"},

  // band stuff
  {DEFNUMBANDS, "-bands"},
  {DEFWIDTH, "-barwidth"}, 
  {DEFSEGHEIGHT, "-barsegheight"}, 
  {DEFSEGSPACE, "-barsegspace"},

  // colors and more
  {FOREGROUND, "-fg"}, 
  {BACKGROUND, "-bg"},
  {GRAPHBACK, "-graphbg"},
  {LABELTEXT, "-labelcolor"},
  {AXESCOLOR, "-axescolor"},

  {LINECOLOR, "-linecolor"},

  {DEFBARTYPE, "-bartype"},
  {BARCOLOR, "-barcolor"},
  {MEDBARVAL, "-medbarval"},
  {MEDBARCOLOR, "-medbarcolor"},
  {HIGHBARVAL, "-highbarval"},
  {HIGHBARCOLOR, "-highbarcolor"},
  {BARCLIPCOLOR, "-barclipcolor"},
  {PEAKCOLOR, "-peakcolor"},
  {DEFNUMFADESTEPS, "-fadesteps"},
  {PEAKDISAPPEARVALUE, "-peaklowlimit"},
  {BARCLEAR, "-barmaxcolor"},

  {DEFNUMFREQLABELS, "-numfreqlabels"},
  {DEFFREQLABELOFFSET, "-labelint"},
  

  {DEFX1, "-x1"},
  {DEFY1, "-y1"},
  {DEFX2, "-x2"},
  {DEFY2, "-y2"},

  {DEFOFFSET8, "-ofs8"},
  {DEFOFFSET16, "-ofs16"},

  {DEFXINTERVAL, "-xinterval"},
  {DEFYINTERVAL, "-yinterval"},
  
  // real options
  {DEFDISTANCE, "-distance"},
  
  {DEFROTX, "-rotx"},
  {DEFROTY, "-roty"},
  {DEFROTZ, "-rotz"},

  {DEFTRANSX, "-transx"},
  {DEFTRANSY, "-transy"},
  {DEFTRANSZ, "-transz"},

  // boolean options
  {DEF8BIT, "-8bit"},
  {DEFLOGSCALE, "-logscale"},
  {DEFLOGFREQSCALE, "-logfreqscale"},
  {DEFCONTINUOUS, "-continuous"},
  {DEFHWINDOW, "-hwindow"},
  {DEFNOTEXT, "-notext"},
  {DEFFULLSCREEN, "-fullscreen"},
  {DEFNOPERSPECTIVE, "-noperspective"},
}, gStore;


