/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* default values                                                         */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: defvals.h,v 1.21 1995/05/02 16:04:32 drewvel Exp $             

#ifndef __DEFVALS_INC
#define __DEFVALS_INC

// Main stuff
#define VERSION "svgafft 0.2c"

// default screen mode (0-(NUMSCREENS-1) as defined in screen.h && screen.cc)
#define DEFSCREEN 1 

#define DEFSAMPRATE 22050
#define DEFSAMPSIZE 1024
#define DEFATTENUATION_8 8
#define DEFATTENUATION_16 8192
#define DEFNUMBANDS 199
#define DEFVPOS 0

#define DEFPLOTTYPE 1
#define DEFRANGEINC 64
#define DEFLOWFREQ (DEFRANGEINC*2)
#define DEFHIGHFREQ -1

#define DEFOFFSET8 0
#define DEFOFFSET16 0

// increment value for runtime sample rate changing
#define SRATEINC 2048

// dB range values (must be calibrated however at runtime)
#define DBRANGE8 48
#define DBRANGE16 96

// sig. proc stuff
#define DEFHWINDOW false

// bar graph stuff
#define DEFBARTYPE 1
#define DEFWIDTH 2
#define DEFSEGHEIGHT 1
#define DEFSEGSPACE 1
#define DEFNUMFREQLABELS 12
#define DEFFREQLABELOFFSET 0

// colors
#define FOREGROUND 189
#define BACKGROUND 91
#define GRAPHBACK 0
#define LABELTEXT 253

#define DEFTICKMARKCOLOR 245
#define DEFKEYCOLOR 190

#define LINECOLOR 61
#define AXESCOLOR 75
#define BARCLEAR GRAPHBACK
#define BARCOLOR 52
#define MEDBARVAL 50
#define MEDBARCOLOR 250
#define HIGHBARVAL 80
#define HIGHBARCOLOR 200
#define BARCLIPCOLOR 255

// defaults for 3D stuff
#define DEFXINTERVAL 4
#define DEFYINTERVAL 8

#define DEFDISTANCE 1024

#define DEFROTX -.1
#define DEFROTY -.2
#define DEFROTZ -.05
#define DEFTRANSX -200
#define DEFTRANSY 50
#define DEFTRANSZ -200

// falling peaks
#define PEAKCOLOR 175
#define PEAKDISAPPEARVALUE 15

// fading bars
#define DEFNUMFADESTEPS 8

// bool opts
#define DEF8BIT 0
#define DEFLOGSCALE 0
#define DEFLOGFREQSCALE 0
#define DEFCONTINUOUS 0
#define DEFNOTEXT 0
#define DEFFULLSCREEN 0
#define DEFNOPERSPECTIVE 0

// analyzer extents
#define DEFX1 -1
#define DEFY1 -1
#define DEFX2 -1
#define DEFY2 -1

// miscellaneous
#define NOFILENAME "<defined on command-line>"

// fft dependent stuff
#define FFTSIZESCALE 1

#endif __DEFVALS_INC
