/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* display class interface definitions                                    */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: display.h,v 0.8 1995/04/15 18:36:25 drewvel Exp $             

/*******************************************************************/
#ifndef __DISPLAYH_INC
#define __DISPLAYH_INC

/*******************************************************************/
#include "configuration.h"
#include "parameters.h"
#include "screen.h"
#include "ftypes.h"
#include "controls.h"
#include "rms.h"

/*******************************************************************/
class Signal;
class SpectrumAnalyzer;
struct globalConfig;
class Controls;


/*******************************************************************/
extern globalConfig gConfig;
extern globalConfig gPassConfig;
extern char *gProgInfo;
extern aScreen Screens[];


/*******************************************************************/
void ClrScr();
void KeyCont();


/*******************************************************************/
/* Abstract Display Class */
/*******************************************************************/
/*******************************************************************/
/* To create a new type of display, derive from this class
   and fill in the blanks (or derive from SVGA_Display) */
/*******************************************************************/
class Display {
protected:
  Signal* s;  
  SpectrumAnalyzer* analyzer;

  real *coefficients;
  aScreen theScreen;

//  int width, height;

  int num, sizescale; // # of display elements & size scale factor 

  boolean logscale;
  boolean granularity;
  int irms_val;
  float rrms_val;
  int type; // display method

  short *index;
  short *i_length;


  void AllocIndex(short *index[], short *i_length[], int num);
  void FreeIndex(short *a[], short *b[]);
  void CreateFreqIndex(int low, int high, int srate, boolean logscale,
		       short index[], short i_length[],
		       int size, int num=0);
    

  // optional functions (useful if there are sub-display methods)
  virtual void EnableClipping() { }
  virtual void DisableClipping() { }
  virtual void UpdateFreqIndex();
  virtual void DrawInit() { }

  int LogNum(int num, int high);
  float LogNum(float num, float high);
  virtual float GetFreqFromBufferIndex(int a);

public: 
  int logatten;
  Controls controls;

  // ctor and dtor
  Display(int n, Signal& S, 
	  aScreen &screen, int t=1,
	  boolean st=DEFLOGSCALE);
  virtual ~Display();


  // base functionality
  void SetParent(SpectrumAnalyzer& a);
  void SetScreen(aScreen& screen);
  void SetSignal(Signal& sig);
  void SetBuffer(real *abuffer);

  void SetExtents(int X1=DEFX1, int Y1=DEFY1, 
		  int X2=DEFX2, int Y2=DEFY2);

  void SetAtten(int Atten);
  void SetLogAtten(int LogAtten);

  int CalculateFreqNum(int freq);

  int GetDisplayMethod() 
    { return type; }

  int GetNumBands() 
    { return num; }

  int Height() { return theScreen.y2-theScreen.y1+1; }
  int Width() { return theScreen.x2-theScreen.x1+1; }
  
  // virtual functions
  virtual void InitRange(int SizeScale=-1);

  // abstract (pure virtual) functions
  virtual void Show()=0;
  virtual void UnShow()=0;
  virtual void ChangeScreen(int num)=0;
  virtual void Reset()=0;
  virtual void ClearGraph()=0;
  
  // optional functions (useful if there are sub-display methods)
  virtual void WriteInfo() { }
  virtual void RefreshFreqs(); // calls UpdateFreqIndex
  virtual void DisplayChange() { }
  virtual void RenewDisplayMethod(int t) { }

  // member to process inherited control signals 
  virtual void ProcessControl(char control); 

  // main looping function
  virtual void UpdateCoefficients()=0;
};

#endif __DISPLAYH_INC
